/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Metadata about a callback step.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CallbackStepMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<CallbackStepMetadata.Builder, CallbackStepMetadata> {
    private static final SdkField<String> CALLBACK_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CallbackToken").getter(getter(CallbackStepMetadata::callbackToken))
            .setter(setter(Builder::callbackToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CallbackToken").build()).build();

    private static final SdkField<String> SQS_QUEUE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SqsQueueUrl").getter(getter(CallbackStepMetadata::sqsQueueUrl)).setter(setter(Builder::sqsQueueUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueUrl").build()).build();

    private static final SdkField<List<OutputParameter>> OUTPUT_PARAMETERS_FIELD = SdkField
            .<List<OutputParameter>> builder(MarshallingType.LIST)
            .memberName("OutputParameters")
            .getter(getter(CallbackStepMetadata::outputParameters))
            .setter(setter(Builder::outputParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputParameters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OutputParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OutputParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CALLBACK_TOKEN_FIELD,
            SQS_QUEUE_URL_FIELD, OUTPUT_PARAMETERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String callbackToken;

    private final String sqsQueueUrl;

    private final List<OutputParameter> outputParameters;

    private CallbackStepMetadata(BuilderImpl builder) {
        this.callbackToken = builder.callbackToken;
        this.sqsQueueUrl = builder.sqsQueueUrl;
        this.outputParameters = builder.outputParameters;
    }

    /**
     * <p>
     * The pipeline generated token from the Amazon SQS queue.
     * </p>
     * 
     * @return The pipeline generated token from the Amazon SQS queue.
     */
    public final String callbackToken() {
        return callbackToken;
    }

    /**
     * <p>
     * The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.
     * </p>
     * 
     * @return The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.
     */
    public final String sqsQueueUrl() {
        return sqsQueueUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputParameters() {
        return outputParameters != null && !(outputParameters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the output parameters of the callback step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputParameters} method.
     * </p>
     * 
     * @return A list of the output parameters of the callback step.
     */
    public final List<OutputParameter> outputParameters() {
        return outputParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(callbackToken());
        hashCode = 31 * hashCode + Objects.hashCode(sqsQueueUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputParameters() ? outputParameters() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CallbackStepMetadata)) {
            return false;
        }
        CallbackStepMetadata other = (CallbackStepMetadata) obj;
        return Objects.equals(callbackToken(), other.callbackToken()) && Objects.equals(sqsQueueUrl(), other.sqsQueueUrl())
                && hasOutputParameters() == other.hasOutputParameters()
                && Objects.equals(outputParameters(), other.outputParameters());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CallbackStepMetadata").add("CallbackToken", callbackToken()).add("SqsQueueUrl", sqsQueueUrl())
                .add("OutputParameters", hasOutputParameters() ? outputParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CallbackToken":
            return Optional.ofNullable(clazz.cast(callbackToken()));
        case "SqsQueueUrl":
            return Optional.ofNullable(clazz.cast(sqsQueueUrl()));
        case "OutputParameters":
            return Optional.ofNullable(clazz.cast(outputParameters()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CallbackToken", CALLBACK_TOKEN_FIELD);
        map.put("SqsQueueUrl", SQS_QUEUE_URL_FIELD);
        map.put("OutputParameters", OUTPUT_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CallbackStepMetadata, T> g) {
        return obj -> g.apply((CallbackStepMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CallbackStepMetadata> {
        /**
         * <p>
         * The pipeline generated token from the Amazon SQS queue.
         * </p>
         * 
         * @param callbackToken
         *        The pipeline generated token from the Amazon SQS queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder callbackToken(String callbackToken);

        /**
         * <p>
         * The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.
         * </p>
         * 
         * @param sqsQueueUrl
         *        The URL of the Amazon Simple Queue Service (Amazon SQS) queue used by the callback step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sqsQueueUrl(String sqsQueueUrl);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the callback step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(Collection<OutputParameter> outputParameters);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * 
         * @param outputParameters
         *        A list of the output parameters of the callback step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputParameters(OutputParameter... outputParameters);

        /**
         * <p>
         * A list of the output parameters of the callback step.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.OutputParameter.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.OutputParameter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.OutputParameter.Builder#build()} is called immediately
         * and its result is passed to {@link #outputParameters(List<OutputParameter>)}.
         * 
         * @param outputParameters
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.OutputParameter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputParameters(java.util.Collection<OutputParameter>)
         */
        Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters);
    }

    static final class BuilderImpl implements Builder {
        private String callbackToken;

        private String sqsQueueUrl;

        private List<OutputParameter> outputParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CallbackStepMetadata model) {
            callbackToken(model.callbackToken);
            sqsQueueUrl(model.sqsQueueUrl);
            outputParameters(model.outputParameters);
        }

        public final String getCallbackToken() {
            return callbackToken;
        }

        public final void setCallbackToken(String callbackToken) {
            this.callbackToken = callbackToken;
        }

        @Override
        public final Builder callbackToken(String callbackToken) {
            this.callbackToken = callbackToken;
            return this;
        }

        public final String getSqsQueueUrl() {
            return sqsQueueUrl;
        }

        public final void setSqsQueueUrl(String sqsQueueUrl) {
            this.sqsQueueUrl = sqsQueueUrl;
        }

        @Override
        public final Builder sqsQueueUrl(String sqsQueueUrl) {
            this.sqsQueueUrl = sqsQueueUrl;
            return this;
        }

        public final List<OutputParameter.Builder> getOutputParameters() {
            List<OutputParameter.Builder> result = OutputParameterListCopier.copyToBuilder(this.outputParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputParameters(Collection<OutputParameter.BuilderImpl> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copyFromBuilder(outputParameters);
        }

        @Override
        public final Builder outputParameters(Collection<OutputParameter> outputParameters) {
            this.outputParameters = OutputParameterListCopier.copy(outputParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputParameters(OutputParameter... outputParameters) {
            outputParameters(Arrays.asList(outputParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputParameters(Consumer<OutputParameter.Builder>... outputParameters) {
            outputParameters(Stream.of(outputParameters).map(c -> OutputParameter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CallbackStepMetadata build() {
            return new CallbackStepMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
