/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The lifecycle configuration for a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterLifeCycleConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterLifeCycleConfig.Builder, ClusterLifeCycleConfig> {
    private static final SdkField<String> SOURCE_S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceS3Uri").getter(getter(ClusterLifeCycleConfig::sourceS3Uri)).setter(setter(Builder::sourceS3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceS3Uri").build()).build();

    private static final SdkField<String> ON_CREATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnCreate").getter(getter(ClusterLifeCycleConfig::onCreate)).setter(setter(Builder::onCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnCreate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_S3_URI_FIELD,
            ON_CREATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceS3Uri;

    private final String onCreate;

    private ClusterLifeCycleConfig(BuilderImpl builder) {
        this.sourceS3Uri = builder.sourceS3Uri;
        this.onCreate = builder.onCreate;
    }

    /**
     * <p>
     * An Amazon S3 bucket path where your lifecycle scripts are stored.
     * </p>
     * <important>
     * <p>
     * Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code>. The <a href=
     * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod"
     * >IAM role for SageMaker HyperPod</a> has the managed <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html">
     * <code>AmazonSageMakerClusterInstanceRolePolicy</code> </a> attached, which allows access to S3 buckets with the
     * specific prefix <code>sagemaker-</code>.
     * </p>
     * </important>
     * 
     * @return An Amazon S3 bucket path where your lifecycle scripts are stored.</p> <important>
     *         <p>
     *         Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code>. The <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod"
     *         >IAM role for SageMaker HyperPod</a> has the managed <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html">
     *         <code>AmazonSageMakerClusterInstanceRolePolicy</code> </a> attached, which allows access to S3 buckets
     *         with the specific prefix <code>sagemaker-</code>.
     *         </p>
     */
    public final String sourceS3Uri() {
        return sourceS3Uri;
    }

    /**
     * <p>
     * The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code>. This entrypoint
     * script runs during cluster creation.
     * </p>
     * 
     * @return The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code>. This
     *         entrypoint script runs during cluster creation.
     */
    public final String onCreate() {
        return onCreate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(onCreate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterLifeCycleConfig)) {
            return false;
        }
        ClusterLifeCycleConfig other = (ClusterLifeCycleConfig) obj;
        return Objects.equals(sourceS3Uri(), other.sourceS3Uri()) && Objects.equals(onCreate(), other.onCreate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterLifeCycleConfig").add("SourceS3Uri", sourceS3Uri()).add("OnCreate", onCreate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceS3Uri":
            return Optional.ofNullable(clazz.cast(sourceS3Uri()));
        case "OnCreate":
            return Optional.ofNullable(clazz.cast(onCreate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceS3Uri", SOURCE_S3_URI_FIELD);
        map.put("OnCreate", ON_CREATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterLifeCycleConfig, T> g) {
        return obj -> g.apply((ClusterLifeCycleConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterLifeCycleConfig> {
        /**
         * <p>
         * An Amazon S3 bucket path where your lifecycle scripts are stored.
         * </p>
         * <important>
         * <p>
         * Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code>. The <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod"
         * >IAM role for SageMaker HyperPod</a> has the managed <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html">
         * <code>AmazonSageMakerClusterInstanceRolePolicy</code> </a> attached, which allows access to S3 buckets with
         * the specific prefix <code>sagemaker-</code>.
         * </p>
         * </important>
         * 
         * @param sourceS3Uri
         *        An Amazon S3 bucket path where your lifecycle scripts are stored.</p> <important>
         *        <p>
         *        Make sure that the S3 bucket path starts with <code>s3://sagemaker-</code>. The <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-hyperpod-prerequisites.html#sagemaker-hyperpod-prerequisites-iam-role-for-hyperpod"
         *        >IAM role for SageMaker HyperPod</a> has the managed <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/security-iam-awsmanpol-cluster.html">
         *        <code>AmazonSageMakerClusterInstanceRolePolicy</code> </a> attached, which allows access to S3 buckets
         *        with the specific prefix <code>sagemaker-</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceS3Uri(String sourceS3Uri);

        /**
         * <p>
         * The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code>. This entrypoint
         * script runs during cluster creation.
         * </p>
         * 
         * @param onCreate
         *        The file name of the entrypoint script of lifecycle scripts under <code>SourceS3Uri</code>. This
         *        entrypoint script runs during cluster creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onCreate(String onCreate);
    }

    static final class BuilderImpl implements Builder {
        private String sourceS3Uri;

        private String onCreate;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterLifeCycleConfig model) {
            sourceS3Uri(model.sourceS3Uri);
            onCreate(model.onCreate);
        }

        public final String getSourceS3Uri() {
            return sourceS3Uri;
        }

        public final void setSourceS3Uri(String sourceS3Uri) {
            this.sourceS3Uri = sourceS3Uri;
        }

        @Override
        public final Builder sourceS3Uri(String sourceS3Uri) {
            this.sourceS3Uri = sourceS3Uri;
            return this;
        }

        public final String getOnCreate() {
            return onCreate;
        }

        public final void setOnCreate(String onCreate) {
            this.onCreate = onCreate;
        }

        @Override
        public final Builder onCreate(String onCreate) {
            this.onCreate = onCreate;
            return this;
        }

        @Override
        public ClusterLifeCycleConfig build() {
            return new ClusterLifeCycleConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
