/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details of an instance (also called a <i>node</i> interchangeably) in a SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterNodeDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterNodeDetails.Builder, ClusterNodeDetails> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(ClusterNodeDetails::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ClusterNodeDetails::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<ClusterInstanceStatusDetails> INSTANCE_STATUS_FIELD = SdkField
            .<ClusterInstanceStatusDetails> builder(MarshallingType.SDK_POJO).memberName("InstanceStatus")
            .getter(getter(ClusterNodeDetails::instanceStatus)).setter(setter(Builder::instanceStatus))
            .constructor(ClusterInstanceStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStatus").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(ClusterNodeDetails::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Instant> LAUNCH_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LaunchTime").getter(getter(ClusterNodeDetails::launchTime)).setter(setter(Builder::launchTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTime").build()).build();

    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField
            .<ClusterLifeCycleConfig> builder(MarshallingType.SDK_POJO).memberName("LifeCycleConfig")
            .getter(getter(ClusterNodeDetails::lifeCycleConfig)).setter(setter(Builder::lifeCycleConfig))
            .constructor(ClusterLifeCycleConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()).build();

    private static final SdkField<VpcConfig> OVERRIDE_VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OverrideVpcConfig").getter(getter(ClusterNodeDetails::overrideVpcConfig))
            .setter(setter(Builder::overrideVpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideVpcConfig").build()).build();

    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ThreadsPerCore").getter(getter(ClusterNodeDetails::threadsPerCore))
            .setter(setter(Builder::threadsPerCore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()).build();

    private static final SdkField<List<ClusterInstanceStorageConfig>> INSTANCE_STORAGE_CONFIGS_FIELD = SdkField
            .<List<ClusterInstanceStorageConfig>> builder(MarshallingType.LIST)
            .memberName("InstanceStorageConfigs")
            .getter(getter(ClusterNodeDetails::instanceStorageConfigs))
            .setter(setter(Builder::instanceStorageConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterInstanceStorageConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterInstanceStorageConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PRIVATE_PRIMARY_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivatePrimaryIp").getter(getter(ClusterNodeDetails::privatePrimaryIp))
            .setter(setter(Builder::privatePrimaryIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivatePrimaryIp").build()).build();

    private static final SdkField<String> PRIVATE_PRIMARY_IPV6_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivatePrimaryIpv6").getter(getter(ClusterNodeDetails::privatePrimaryIpv6))
            .setter(setter(Builder::privatePrimaryIpv6))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivatePrimaryIpv6").build())
            .build();

    private static final SdkField<String> PRIVATE_DNS_HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateDnsHostname").getter(getter(ClusterNodeDetails::privateDnsHostname))
            .setter(setter(Builder::privateDnsHostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDnsHostname").build())
            .build();

    private static final SdkField<ClusterInstancePlacement> PLACEMENT_FIELD = SdkField
            .<ClusterInstancePlacement> builder(MarshallingType.SDK_POJO).memberName("Placement")
            .getter(getter(ClusterNodeDetails::placement)).setter(setter(Builder::placement))
            .constructor(ClusterInstancePlacement::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD,
            INSTANCE_ID_FIELD, INSTANCE_STATUS_FIELD, INSTANCE_TYPE_FIELD, LAUNCH_TIME_FIELD, LIFE_CYCLE_CONFIG_FIELD,
            OVERRIDE_VPC_CONFIG_FIELD, THREADS_PER_CORE_FIELD, INSTANCE_STORAGE_CONFIGS_FIELD, PRIVATE_PRIMARY_IP_FIELD,
            PRIVATE_PRIMARY_IPV6_FIELD, PRIVATE_DNS_HOSTNAME_FIELD, PLACEMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceGroupName;

    private final String instanceId;

    private final ClusterInstanceStatusDetails instanceStatus;

    private final String instanceType;

    private final Instant launchTime;

    private final ClusterLifeCycleConfig lifeCycleConfig;

    private final VpcConfig overrideVpcConfig;

    private final Integer threadsPerCore;

    private final List<ClusterInstanceStorageConfig> instanceStorageConfigs;

    private final String privatePrimaryIp;

    private final String privatePrimaryIpv6;

    private final String privateDnsHostname;

    private final ClusterInstancePlacement placement;

    private ClusterNodeDetails(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceId = builder.instanceId;
        this.instanceStatus = builder.instanceStatus;
        this.instanceType = builder.instanceType;
        this.launchTime = builder.launchTime;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.overrideVpcConfig = builder.overrideVpcConfig;
        this.threadsPerCore = builder.threadsPerCore;
        this.instanceStorageConfigs = builder.instanceStorageConfigs;
        this.privatePrimaryIp = builder.privatePrimaryIp;
        this.privatePrimaryIpv6 = builder.privatePrimaryIpv6;
        this.privateDnsHostname = builder.privateDnsHostname;
        this.placement = builder.placement;
    }

    /**
     * <p>
     * The instance group name in which the instance is.
     * </p>
     * 
     * @return The instance group name in which the instance is.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The status of the instance.
     * </p>
     * 
     * @return The status of the instance.
     */
    public final ClusterInstanceStatusDetails instanceStatus() {
        return instanceStatus;
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The type of the instance.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link ClusterInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The type of the instance.
     * @see ClusterInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The time when the instance is launched.
     * </p>
     * 
     * @return The time when the instance is launched.
     */
    public final Instant launchTime() {
        return launchTime;
    }

    /**
     * <p>
     * The LifeCycle configuration applied to the instance.
     * </p>
     * 
     * @return The LifeCycle configuration applied to the instance.
     */
    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return lifeCycleConfig;
    }

    /**
     * Returns the value of the OverrideVpcConfig property for this object.
     * 
     * @return The value of the OverrideVpcConfig property for this object.
     */
    public final VpcConfig overrideVpcConfig() {
        return overrideVpcConfig;
    }

    /**
     * <p>
     * The number of threads per CPU core you specified under <code>CreateCluster</code>.
     * </p>
     * 
     * @return The number of threads per CPU core you specified under <code>CreateCluster</code>.
     */
    public final Integer threadsPerCore() {
        return threadsPerCore;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceStorageConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasInstanceStorageConfigs() {
        return instanceStorageConfigs != null && !(instanceStorageConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The configurations of additional storage specified to the instance group where the instance (node) is launched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceStorageConfigs} method.
     * </p>
     * 
     * @return The configurations of additional storage specified to the instance group where the instance (node) is
     *         launched.
     */
    public final List<ClusterInstanceStorageConfig> instanceStorageConfigs() {
        return instanceStorageConfigs;
    }

    /**
     * <p>
     * The private primary IP address of the SageMaker HyperPod cluster node.
     * </p>
     * 
     * @return The private primary IP address of the SageMaker HyperPod cluster node.
     */
    public final String privatePrimaryIp() {
        return privatePrimaryIp;
    }

    /**
     * <p>
     * The private primary IPv6 address of the SageMaker HyperPod cluster node.
     * </p>
     * 
     * @return The private primary IPv6 address of the SageMaker HyperPod cluster node.
     */
    public final String privatePrimaryIpv6() {
        return privatePrimaryIpv6;
    }

    /**
     * <p>
     * The private DNS hostname of the SageMaker HyperPod cluster node.
     * </p>
     * 
     * @return The private DNS hostname of the SageMaker HyperPod cluster node.
     */
    public final String privateDnsHostname() {
        return privateDnsHostname;
    }

    /**
     * <p>
     * The placement details of the SageMaker HyperPod cluster node.
     * </p>
     * 
     * @return The placement details of the SageMaker HyperPod cluster node.
     */
    public final ClusterInstancePlacement placement() {
        return placement;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(launchTime());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(overrideVpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceStorageConfigs() ? instanceStorageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(privatePrimaryIp());
        hashCode = 31 * hashCode + Objects.hashCode(privatePrimaryIpv6());
        hashCode = 31 * hashCode + Objects.hashCode(privateDnsHostname());
        hashCode = 31 * hashCode + Objects.hashCode(placement());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterNodeDetails)) {
            return false;
        }
        ClusterNodeDetails other = (ClusterNodeDetails) obj;
        return Objects.equals(instanceGroupName(), other.instanceGroupName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceStatus(), other.instanceStatus())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(launchTime(), other.launchTime()) && Objects.equals(lifeCycleConfig(), other.lifeCycleConfig())
                && Objects.equals(overrideVpcConfig(), other.overrideVpcConfig())
                && Objects.equals(threadsPerCore(), other.threadsPerCore())
                && hasInstanceStorageConfigs() == other.hasInstanceStorageConfigs()
                && Objects.equals(instanceStorageConfigs(), other.instanceStorageConfigs())
                && Objects.equals(privatePrimaryIp(), other.privatePrimaryIp())
                && Objects.equals(privatePrimaryIpv6(), other.privatePrimaryIpv6())
                && Objects.equals(privateDnsHostname(), other.privateDnsHostname())
                && Objects.equals(placement(), other.placement());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterNodeDetails").add("InstanceGroupName", instanceGroupName())
                .add("InstanceId", instanceId()).add("InstanceStatus", instanceStatus())
                .add("InstanceType", instanceTypeAsString()).add("LaunchTime", launchTime())
                .add("LifeCycleConfig", lifeCycleConfig()).add("OverrideVpcConfig", overrideVpcConfig())
                .add("ThreadsPerCore", threadsPerCore())
                .add("InstanceStorageConfigs", hasInstanceStorageConfigs() ? instanceStorageConfigs() : null)
                .add("PrivatePrimaryIp", privatePrimaryIp()).add("PrivatePrimaryIpv6", privatePrimaryIpv6())
                .add("PrivateDnsHostname", privateDnsHostname()).add("Placement", placement()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceStatus":
            return Optional.ofNullable(clazz.cast(instanceStatus()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "LaunchTime":
            return Optional.ofNullable(clazz.cast(launchTime()));
        case "LifeCycleConfig":
            return Optional.ofNullable(clazz.cast(lifeCycleConfig()));
        case "OverrideVpcConfig":
            return Optional.ofNullable(clazz.cast(overrideVpcConfig()));
        case "ThreadsPerCore":
            return Optional.ofNullable(clazz.cast(threadsPerCore()));
        case "InstanceStorageConfigs":
            return Optional.ofNullable(clazz.cast(instanceStorageConfigs()));
        case "PrivatePrimaryIp":
            return Optional.ofNullable(clazz.cast(privatePrimaryIp()));
        case "PrivatePrimaryIpv6":
            return Optional.ofNullable(clazz.cast(privatePrimaryIpv6()));
        case "PrivateDnsHostname":
            return Optional.ofNullable(clazz.cast(privateDnsHostname()));
        case "Placement":
            return Optional.ofNullable(clazz.cast(placement()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("InstanceStatus", INSTANCE_STATUS_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("LaunchTime", LAUNCH_TIME_FIELD);
        map.put("LifeCycleConfig", LIFE_CYCLE_CONFIG_FIELD);
        map.put("OverrideVpcConfig", OVERRIDE_VPC_CONFIG_FIELD);
        map.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
        map.put("InstanceStorageConfigs", INSTANCE_STORAGE_CONFIGS_FIELD);
        map.put("PrivatePrimaryIp", PRIVATE_PRIMARY_IP_FIELD);
        map.put("PrivatePrimaryIpv6", PRIVATE_PRIMARY_IPV6_FIELD);
        map.put("PrivateDnsHostname", PRIVATE_DNS_HOSTNAME_FIELD);
        map.put("Placement", PLACEMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterNodeDetails, T> g) {
        return obj -> g.apply((ClusterNodeDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterNodeDetails> {
        /**
         * <p>
         * The instance group name in which the instance is.
         * </p>
         * 
         * @param instanceGroupName
         *        The instance group name in which the instance is.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * 
         * @param instanceStatus
         *        The status of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus);

        /**
         * <p>
         * The status of the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterInstanceStatusDetails.Builder}
         * avoiding the need to create one manually via {@link ClusterInstanceStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterInstanceStatusDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceStatus(ClusterInstanceStatusDetails)}.
         * 
         * @param instanceStatus
         *        a consumer that will call methods on {@link ClusterInstanceStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStatus(ClusterInstanceStatusDetails)
         */
        default Builder instanceStatus(Consumer<ClusterInstanceStatusDetails.Builder> instanceStatus) {
            return instanceStatus(ClusterInstanceStatusDetails.builder().applyMutation(instanceStatus).build());
        }

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The type of the instance.
         * </p>
         * 
         * @param instanceType
         *        The type of the instance.
         * @see ClusterInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterInstanceType
         */
        Builder instanceType(ClusterInstanceType instanceType);

        /**
         * <p>
         * The time when the instance is launched.
         * </p>
         * 
         * @param launchTime
         *        The time when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchTime(Instant launchTime);

        /**
         * <p>
         * The LifeCycle configuration applied to the instance.
         * </p>
         * 
         * @param lifeCycleConfig
         *        The LifeCycle configuration applied to the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig);

        /**
         * <p>
         * The LifeCycle configuration applied to the instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterLifeCycleConfig.Builder} avoiding
         * the need to create one manually via {@link ClusterLifeCycleConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterLifeCycleConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lifeCycleConfig(ClusterLifeCycleConfig)}.
         * 
         * @param lifeCycleConfig
         *        a consumer that will call methods on {@link ClusterLifeCycleConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycleConfig(ClusterLifeCycleConfig)
         */
        default Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return lifeCycleConfig(ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig).build());
        }

        /**
         * Sets the value of the OverrideVpcConfig property for this object.
         *
         * @param overrideVpcConfig
         *        The new value for the OverrideVpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overrideVpcConfig(VpcConfig overrideVpcConfig);

        /**
         * Sets the value of the OverrideVpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #overrideVpcConfig(VpcConfig)}.
         * 
         * @param overrideVpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overrideVpcConfig(VpcConfig)
         */
        default Builder overrideVpcConfig(Consumer<VpcConfig.Builder> overrideVpcConfig) {
            return overrideVpcConfig(VpcConfig.builder().applyMutation(overrideVpcConfig).build());
        }

        /**
         * <p>
         * The number of threads per CPU core you specified under <code>CreateCluster</code>.
         * </p>
         * 
         * @param threadsPerCore
         *        The number of threads per CPU core you specified under <code>CreateCluster</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threadsPerCore(Integer threadsPerCore);

        /**
         * <p>
         * The configurations of additional storage specified to the instance group where the instance (node) is
         * launched.
         * </p>
         * 
         * @param instanceStorageConfigs
         *        The configurations of additional storage specified to the instance group where the instance (node) is
         *        launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs);

        /**
         * <p>
         * The configurations of additional storage specified to the instance group where the instance (node) is
         * launched.
         * </p>
         * 
         * @param instanceStorageConfigs
         *        The configurations of additional storage specified to the instance group where the instance (node) is
         *        launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceStorageConfigs(ClusterInstanceStorageConfig... instanceStorageConfigs);

        /**
         * <p>
         * The configurations of additional storage specified to the instance group where the instance (node) is
         * launched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #instanceStorageConfigs(List<ClusterInstanceStorageConfig>)}.
         * 
         * @param instanceStorageConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceStorageConfigs(java.util.Collection<ClusterInstanceStorageConfig>)
         */
        Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder>... instanceStorageConfigs);

        /**
         * <p>
         * The private primary IP address of the SageMaker HyperPod cluster node.
         * </p>
         * 
         * @param privatePrimaryIp
         *        The private primary IP address of the SageMaker HyperPod cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privatePrimaryIp(String privatePrimaryIp);

        /**
         * <p>
         * The private primary IPv6 address of the SageMaker HyperPod cluster node.
         * </p>
         * 
         * @param privatePrimaryIpv6
         *        The private primary IPv6 address of the SageMaker HyperPod cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privatePrimaryIpv6(String privatePrimaryIpv6);

        /**
         * <p>
         * The private DNS hostname of the SageMaker HyperPod cluster node.
         * </p>
         * 
         * @param privateDnsHostname
         *        The private DNS hostname of the SageMaker HyperPod cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDnsHostname(String privateDnsHostname);

        /**
         * <p>
         * The placement details of the SageMaker HyperPod cluster node.
         * </p>
         * 
         * @param placement
         *        The placement details of the SageMaker HyperPod cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(ClusterInstancePlacement placement);

        /**
         * <p>
         * The placement details of the SageMaker HyperPod cluster node.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterInstancePlacement.Builder}
         * avoiding the need to create one manually via {@link ClusterInstancePlacement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterInstancePlacement.Builder#build()} is called immediately
         * and its result is passed to {@link #placement(ClusterInstancePlacement)}.
         * 
         * @param placement
         *        a consumer that will call methods on {@link ClusterInstancePlacement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placement(ClusterInstancePlacement)
         */
        default Builder placement(Consumer<ClusterInstancePlacement.Builder> placement) {
            return placement(ClusterInstancePlacement.builder().applyMutation(placement).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceGroupName;

        private String instanceId;

        private ClusterInstanceStatusDetails instanceStatus;

        private String instanceType;

        private Instant launchTime;

        private ClusterLifeCycleConfig lifeCycleConfig;

        private VpcConfig overrideVpcConfig;

        private Integer threadsPerCore;

        private List<ClusterInstanceStorageConfig> instanceStorageConfigs = DefaultSdkAutoConstructList.getInstance();

        private String privatePrimaryIp;

        private String privatePrimaryIpv6;

        private String privateDnsHostname;

        private ClusterInstancePlacement placement;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterNodeDetails model) {
            instanceGroupName(model.instanceGroupName);
            instanceId(model.instanceId);
            instanceStatus(model.instanceStatus);
            instanceType(model.instanceType);
            launchTime(model.launchTime);
            lifeCycleConfig(model.lifeCycleConfig);
            overrideVpcConfig(model.overrideVpcConfig);
            threadsPerCore(model.threadsPerCore);
            instanceStorageConfigs(model.instanceStorageConfigs);
            privatePrimaryIp(model.privatePrimaryIp);
            privatePrimaryIpv6(model.privatePrimaryIpv6);
            privateDnsHostname(model.privateDnsHostname);
            placement(model.placement);
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final ClusterInstanceStatusDetails.Builder getInstanceStatus() {
            return instanceStatus != null ? instanceStatus.toBuilder() : null;
        }

        public final void setInstanceStatus(ClusterInstanceStatusDetails.BuilderImpl instanceStatus) {
            this.instanceStatus = instanceStatus != null ? instanceStatus.build() : null;
        }

        @Override
        public final Builder instanceStatus(ClusterInstanceStatusDetails instanceStatus) {
            this.instanceStatus = instanceStatus;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Instant getLaunchTime() {
            return launchTime;
        }

        public final void setLaunchTime(Instant launchTime) {
            this.launchTime = launchTime;
        }

        @Override
        public final Builder launchTime(Instant launchTime) {
            this.launchTime = launchTime;
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return lifeCycleConfig != null ? lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final VpcConfig.Builder getOverrideVpcConfig() {
            return overrideVpcConfig != null ? overrideVpcConfig.toBuilder() : null;
        }

        public final void setOverrideVpcConfig(VpcConfig.BuilderImpl overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig != null ? overrideVpcConfig.build() : null;
        }

        @Override
        public final Builder overrideVpcConfig(VpcConfig overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final List<ClusterInstanceStorageConfig.Builder> getInstanceStorageConfigs() {
            List<ClusterInstanceStorageConfig.Builder> result = ClusterInstanceStorageConfigsCopier
                    .copyToBuilder(this.instanceStorageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStorageConfigs(Collection<ClusterInstanceStorageConfig.BuilderImpl> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copyFromBuilder(instanceStorageConfigs);
        }

        @Override
        public final Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copy(instanceStorageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(ClusterInstanceStorageConfig... instanceStorageConfigs) {
            instanceStorageConfigs(Arrays.asList(instanceStorageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder>... instanceStorageConfigs) {
            instanceStorageConfigs(Stream.of(instanceStorageConfigs)
                    .map(c -> ClusterInstanceStorageConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrivatePrimaryIp() {
            return privatePrimaryIp;
        }

        public final void setPrivatePrimaryIp(String privatePrimaryIp) {
            this.privatePrimaryIp = privatePrimaryIp;
        }

        @Override
        public final Builder privatePrimaryIp(String privatePrimaryIp) {
            this.privatePrimaryIp = privatePrimaryIp;
            return this;
        }

        public final String getPrivatePrimaryIpv6() {
            return privatePrimaryIpv6;
        }

        public final void setPrivatePrimaryIpv6(String privatePrimaryIpv6) {
            this.privatePrimaryIpv6 = privatePrimaryIpv6;
        }

        @Override
        public final Builder privatePrimaryIpv6(String privatePrimaryIpv6) {
            this.privatePrimaryIpv6 = privatePrimaryIpv6;
            return this;
        }

        public final String getPrivateDnsHostname() {
            return privateDnsHostname;
        }

        public final void setPrivateDnsHostname(String privateDnsHostname) {
            this.privateDnsHostname = privateDnsHostname;
        }

        @Override
        public final Builder privateDnsHostname(String privateDnsHostname) {
            this.privateDnsHostname = privateDnsHostname;
            return this;
        }

        public final ClusterInstancePlacement.Builder getPlacement() {
            return placement != null ? placement.toBuilder() : null;
        }

        public final void setPlacement(ClusterInstancePlacement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        @Override
        public final Builder placement(ClusterInstancePlacement placement) {
            this.placement = placement;
            return this;
        }

        @Override
        public ClusterNodeDetails build() {
            return new ClusterNodeDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
