/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of orchestrator used for the SageMaker HyperPod cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterOrchestrator implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterOrchestrator.Builder, ClusterOrchestrator> {
    private static final SdkField<ClusterOrchestratorEksConfig> EKS_FIELD = SdkField
            .<ClusterOrchestratorEksConfig> builder(MarshallingType.SDK_POJO).memberName("Eks")
            .getter(getter(ClusterOrchestrator::eks)).setter(setter(Builder::eks))
            .constructor(ClusterOrchestratorEksConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Eks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClusterOrchestratorEksConfig eks;

    private ClusterOrchestrator(BuilderImpl builder) {
        this.eks = builder.eks;
    }

    /**
     * <p>
     * The Amazon EKS cluster used as the orchestrator for the SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The Amazon EKS cluster used as the orchestrator for the SageMaker HyperPod cluster.
     */
    public final ClusterOrchestratorEksConfig eks() {
        return eks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(eks());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOrchestrator)) {
            return false;
        }
        ClusterOrchestrator other = (ClusterOrchestrator) obj;
        return Objects.equals(eks(), other.eks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterOrchestrator").add("Eks", eks()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Eks":
            return Optional.ofNullable(clazz.cast(eks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Eks", EKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterOrchestrator, T> g) {
        return obj -> g.apply((ClusterOrchestrator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterOrchestrator> {
        /**
         * <p>
         * The Amazon EKS cluster used as the orchestrator for the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param eks
         *        The Amazon EKS cluster used as the orchestrator for the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eks(ClusterOrchestratorEksConfig eks);

        /**
         * <p>
         * The Amazon EKS cluster used as the orchestrator for the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOrchestratorEksConfig.Builder}
         * avoiding the need to create one manually via {@link ClusterOrchestratorEksConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOrchestratorEksConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #eks(ClusterOrchestratorEksConfig)}.
         * 
         * @param eks
         *        a consumer that will call methods on {@link ClusterOrchestratorEksConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eks(ClusterOrchestratorEksConfig)
         */
        default Builder eks(Consumer<ClusterOrchestratorEksConfig.Builder> eks) {
            return eks(ClusterOrchestratorEksConfig.builder().applyMutation(eks).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClusterOrchestratorEksConfig eks;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOrchestrator model) {
            eks(model.eks);
        }

        public final ClusterOrchestratorEksConfig.Builder getEks() {
            return eks != null ? eks.toBuilder() : null;
        }

        public final void setEks(ClusterOrchestratorEksConfig.BuilderImpl eks) {
            this.eks = eks != null ? eks.build() : null;
        }

        @Override
        public final Builder eks(ClusterOrchestratorEksConfig eks) {
            this.eks = eks;
            return this;
        }

        @Override
        public ClusterOrchestrator build() {
            return new ClusterOrchestrator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
