/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary of the cluster policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterSchedulerConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterSchedulerConfigSummary.Builder, ClusterSchedulerConfigSummary> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigArn").getter(getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigArn))
            .setter(setter(Builder::clusterSchedulerConfigArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigArn").build())
            .build();

    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterSchedulerConfigId").getter(getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigId))
            .setter(setter(Builder::clusterSchedulerConfigId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build())
            .build();

    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("ClusterSchedulerConfigVersion")
            .getter(getter(ClusterSchedulerConfigSummary::clusterSchedulerConfigVersion))
            .setter(setter(Builder::clusterSchedulerConfigVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ClusterSchedulerConfigSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ClusterSchedulerConfigSummary::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ClusterSchedulerConfigSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ClusterSchedulerConfigSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ClusterSchedulerConfigSummary::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_SCHEDULER_CONFIG_ARN_FIELD, CLUSTER_SCHEDULER_CONFIG_ID_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD,
            NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, STATUS_FIELD, CLUSTER_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String clusterSchedulerConfigArn;

    private final String clusterSchedulerConfigId;

    private final Integer clusterSchedulerConfigVersion;

    private final String name;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String status;

    private final String clusterArn;

    private ClusterSchedulerConfigSummary(BuilderImpl builder) {
        this.clusterSchedulerConfigArn = builder.clusterSchedulerConfigArn;
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
        this.name = builder.name;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.status = builder.status;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * <p>
     * ARN of the cluster policy.
     * </p>
     * 
     * @return ARN of the cluster policy.
     */
    public final String clusterSchedulerConfigArn() {
        return clusterSchedulerConfigArn;
    }

    /**
     * <p>
     * ID of the cluster policy.
     * </p>
     * 
     * @return ID of the cluster policy.
     */
    public final String clusterSchedulerConfigId() {
        return clusterSchedulerConfigId;
    }

    /**
     * <p>
     * Version of the cluster policy.
     * </p>
     * 
     * @return Version of the cluster policy.
     */
    public final Integer clusterSchedulerConfigVersion() {
        return clusterSchedulerConfigVersion;
    }

    /**
     * <p>
     * Name of the cluster policy.
     * </p>
     * 
     * @return Name of the cluster policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Creation time of the cluster policy.
     * </p>
     * 
     * @return Creation time of the cluster policy.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * Last modified time of the cluster policy.
     * </p>
     * 
     * @return Last modified time of the cluster policy.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * Status of the cluster policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the cluster policy.
     * @see SchedulerResourceStatus
     */
    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Status of the cluster policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Status of the cluster policy.
     * @see SchedulerResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * ARN of the cluster.
     * </p>
     * 
     * @return ARN of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterSchedulerConfigVersion());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSchedulerConfigSummary)) {
            return false;
        }
        ClusterSchedulerConfigSummary other = (ClusterSchedulerConfigSummary) obj;
        return Objects.equals(clusterSchedulerConfigArn(), other.clusterSchedulerConfigArn())
                && Objects.equals(clusterSchedulerConfigId(), other.clusterSchedulerConfigId())
                && Objects.equals(clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion())
                && Objects.equals(name(), other.name()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ClusterSchedulerConfigSummary").add("ClusterSchedulerConfigArn", clusterSchedulerConfigArn())
                .add("ClusterSchedulerConfigId", clusterSchedulerConfigId())
                .add("ClusterSchedulerConfigVersion", clusterSchedulerConfigVersion()).add("Name", name())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime()).add("Status", statusAsString())
                .add("ClusterArn", clusterArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterSchedulerConfigArn":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigArn()));
        case "ClusterSchedulerConfigId":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigId()));
        case "ClusterSchedulerConfigVersion":
            return Optional.ofNullable(clazz.cast(clusterSchedulerConfigVersion()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterSchedulerConfigArn", CLUSTER_SCHEDULER_CONFIG_ARN_FIELD);
        map.put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
        map.put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSchedulerConfigSummary, T> g) {
        return obj -> g.apply((ClusterSchedulerConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterSchedulerConfigSummary> {
        /**
         * <p>
         * ARN of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigArn
         *        ARN of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn);

        /**
         * <p>
         * ID of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigId
         *        ID of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigId(String clusterSchedulerConfigId);

        /**
         * <p>
         * Version of the cluster policy.
         * </p>
         * 
         * @param clusterSchedulerConfigVersion
         *        Version of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion);

        /**
         * <p>
         * Name of the cluster policy.
         * </p>
         * 
         * @param name
         *        Name of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Creation time of the cluster policy.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * Last modified time of the cluster policy.
         * </p>
         * 
         * @param lastModifiedTime
         *        Last modified time of the cluster policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * Status of the cluster policy.
         * </p>
         * 
         * @param status
         *        Status of the cluster policy.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Status of the cluster policy.
         * </p>
         * 
         * @param status
         *        Status of the cluster policy.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(SchedulerResourceStatus status);

        /**
         * <p>
         * ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        ARN of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);
    }

    static final class BuilderImpl implements Builder {
        private String clusterSchedulerConfigArn;

        private String clusterSchedulerConfigId;

        private Integer clusterSchedulerConfigVersion;

        private String name;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String status;

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSchedulerConfigSummary model) {
            clusterSchedulerConfigArn(model.clusterSchedulerConfigArn);
            clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
            name(model.name);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            status(model.status);
            clusterArn(model.clusterArn);
        }

        public final String getClusterSchedulerConfigArn() {
            return clusterSchedulerConfigArn;
        }

        public final void setClusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
        }

        @Override
        public final Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
            return this;
        }

        public final String getClusterSchedulerConfigId() {
            return clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        @Override
        public ClusterSchedulerConfigSummary build() {
            return new ClusterSchedulerConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
