/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for your collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CollectionConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CollectionConfig.Builder, CollectionConfig> {
    private static final SdkField<VectorConfig> VECTOR_CONFIG_FIELD = SdkField.<VectorConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VectorConfig").getter(getter(CollectionConfig::vectorConfig)).setter(setter(Builder::vectorConfig))
            .constructor(VectorConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VectorConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VectorConfig vectorConfig;

    private final Type type;

    private CollectionConfig(BuilderImpl builder) {
        this.vectorConfig = builder.vectorConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration for your vector collection type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Dimension</code>: The number of elements in your vector.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Configuration for your vector collection type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Dimension</code>: The number of elements in your vector.
     *         </p>
     *         </li>
     */
    public final VectorConfig vectorConfig() {
        return vectorConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionConfig)) {
            return false;
        }
        CollectionConfig other = (CollectionConfig) obj;
        return Objects.equals(vectorConfig(), other.vectorConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CollectionConfig").add("VectorConfig", vectorConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VectorConfig":
            return Optional.ofNullable(clazz.cast(vectorConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #vectorConfig()} initialized to the given value.
     *
     * <p>
     * Configuration for your vector collection type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Dimension</code>: The number of elements in your vector.
     * </p>
     * </li>
     * </ul>
     * 
     * @param vectorConfig
     *        Configuration for your vector collection type.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Dimension</code>: The number of elements in your vector.
     *        </p>
     *        </li>
     */
    public static CollectionConfig fromVectorConfig(VectorConfig vectorConfig) {
        return builder().vectorConfig(vectorConfig).build();
    }

    /**
     * Create an instance of this class with {@link #vectorConfig()} initialized to the given value.
     *
     * <p>
     * Configuration for your vector collection type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Dimension</code>: The number of elements in your vector.
     * </p>
     * </li>
     * </ul>
     * 
     * @param vectorConfig
     *        Configuration for your vector collection type.</p>
     *        <ul>
     *        <li>
     *        <p>
     *        <code>Dimension</code>: The number of elements in your vector.
     *        </p>
     *        </li>
     */
    public static CollectionConfig fromVectorConfig(Consumer<VectorConfig.Builder> vectorConfig) {
        VectorConfig.Builder builder = VectorConfig.builder();
        vectorConfig.accept(builder);
        return fromVectorConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VectorConfig", VECTOR_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CollectionConfig, T> g) {
        return obj -> g.apply((CollectionConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CollectionConfig> {
        /**
         * <p>
         * Configuration for your vector collection type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimension</code>: The number of elements in your vector.
         * </p>
         * </li>
         * </ul>
         * 
         * @param vectorConfig
         *        Configuration for your vector collection type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Dimension</code>: The number of elements in your vector.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorConfig(VectorConfig vectorConfig);

        /**
         * <p>
         * Configuration for your vector collection type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Dimension</code>: The number of elements in your vector.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link VectorConfig.Builder} avoiding the need
         * to create one manually via {@link VectorConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VectorConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vectorConfig(VectorConfig)}.
         * 
         * @param vectorConfig
         *        a consumer that will call methods on {@link VectorConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vectorConfig(VectorConfig)
         */
        default Builder vectorConfig(Consumer<VectorConfig.Builder> vectorConfig) {
            return vectorConfig(VectorConfig.builder().applyMutation(vectorConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VectorConfig vectorConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CollectionConfig model) {
            vectorConfig(model.vectorConfig);
        }

        public final VectorConfig.Builder getVectorConfig() {
            return vectorConfig != null ? vectorConfig.toBuilder() : null;
        }

        public final void setVectorConfig(VectorConfig.BuilderImpl vectorConfig) {
            Object oldValue = this.vectorConfig;
            this.vectorConfig = vectorConfig != null ? vectorConfig.build() : null;
            handleUnionValueChange(Type.VECTOR_CONFIG, oldValue, this.vectorConfig);
        }

        @Override
        public final Builder vectorConfig(VectorConfig vectorConfig) {
            Object oldValue = this.vectorConfig;
            this.vectorConfig = vectorConfig;
            handleUnionValueChange(Type.VECTOR_CONFIG, oldValue, this.vectorConfig);
            return this;
        }

        @Override
        public CollectionConfig build() {
            return new CollectionConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CollectionConfig#type()
     */
    public enum Type {
        VECTOR_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
