/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a model compilation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompilationJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompilationJobSummary.Builder, CompilationJobSummary> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(CompilationJobSummary::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> COMPILATION_JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobArn").getter(getter(CompilationJobSummary::compilationJobArn))
            .setter(setter(Builder::compilationJobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(CompilationJobSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> COMPILATION_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompilationStartTime").getter(getter(CompilationJobSummary::compilationStartTime))
            .setter(setter(Builder::compilationStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationStartTime").build())
            .build();

    private static final SdkField<Instant> COMPILATION_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CompilationEndTime").getter(getter(CompilationJobSummary::compilationEndTime))
            .setter(setter(Builder::compilationEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationEndTime").build())
            .build();

    private static final SdkField<String> COMPILATION_TARGET_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationTargetDevice").getter(getter(CompilationJobSummary::compilationTargetDeviceAsString))
            .setter(setter(Builder::compilationTargetDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetDevice").build())
            .build();

    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_OS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompilationTargetPlatformOs")
            .getter(getter(CompilationJobSummary::compilationTargetPlatformOsAsString))
            .setter(setter(Builder::compilationTargetPlatformOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetPlatformOs")
                    .build()).build();

    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_ARCH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompilationTargetPlatformArch")
            .getter(getter(CompilationJobSummary::compilationTargetPlatformArchAsString))
            .setter(setter(Builder::compilationTargetPlatformArch))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationTargetPlatformArch")
                    .build()).build();

    private static final SdkField<String> COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CompilationTargetPlatformAccelerator")
            .getter(getter(CompilationJobSummary::compilationTargetPlatformAcceleratorAsString))
            .setter(setter(Builder::compilationTargetPlatformAccelerator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CompilationTargetPlatformAccelerator").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(CompilationJobSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> COMPILATION_JOB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobStatus").getter(getter(CompilationJobSummary::compilationJobStatusAsString))
            .setter(setter(Builder::compilationJobStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD,
            COMPILATION_JOB_ARN_FIELD, CREATION_TIME_FIELD, COMPILATION_START_TIME_FIELD, COMPILATION_END_TIME_FIELD,
            COMPILATION_TARGET_DEVICE_FIELD, COMPILATION_TARGET_PLATFORM_OS_FIELD, COMPILATION_TARGET_PLATFORM_ARCH_FIELD,
            COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD, LAST_MODIFIED_TIME_FIELD, COMPILATION_JOB_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String compilationJobName;

    private final String compilationJobArn;

    private final Instant creationTime;

    private final Instant compilationStartTime;

    private final Instant compilationEndTime;

    private final String compilationTargetDevice;

    private final String compilationTargetPlatformOs;

    private final String compilationTargetPlatformArch;

    private final String compilationTargetPlatformAccelerator;

    private final Instant lastModifiedTime;

    private final String compilationJobStatus;

    private CompilationJobSummary(BuilderImpl builder) {
        this.compilationJobName = builder.compilationJobName;
        this.compilationJobArn = builder.compilationJobArn;
        this.creationTime = builder.creationTime;
        this.compilationStartTime = builder.compilationStartTime;
        this.compilationEndTime = builder.compilationEndTime;
        this.compilationTargetDevice = builder.compilationTargetDevice;
        this.compilationTargetPlatformOs = builder.compilationTargetPlatformOs;
        this.compilationTargetPlatformArch = builder.compilationTargetPlatformArch;
        this.compilationTargetPlatformAccelerator = builder.compilationTargetPlatformAccelerator;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.compilationJobStatus = builder.compilationJobStatus;
    }

    /**
     * <p>
     * The name of the model compilation job that you want a summary for.
     * </p>
     * 
     * @return The name of the model compilation job that you want a summary for.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model compilation job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model compilation job.
     */
    public final String compilationJobArn() {
        return compilationJobArn;
    }

    /**
     * <p>
     * The time when the model compilation job was created.
     * </p>
     * 
     * @return The time when the model compilation job was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time when the model compilation job started.
     * </p>
     * 
     * @return The time when the model compilation job started.
     */
    public final Instant compilationStartTime() {
        return compilationStartTime;
    }

    /**
     * <p>
     * The time when the model compilation job completed.
     * </p>
     * 
     * @return The time when the model compilation job completed.
     */
    public final Instant compilationEndTime() {
        return compilationEndTime;
    }

    /**
     * <p>
     * The type of device that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetDevice} will return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compilationTargetDeviceAsString}.
     * </p>
     * 
     * @return The type of device that the model will run on after the compilation job has completed.
     * @see TargetDevice
     */
    public final TargetDevice compilationTargetDevice() {
        return TargetDevice.fromValue(compilationTargetDevice);
    }

    /**
     * <p>
     * The type of device that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetDevice} will return {@link TargetDevice#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #compilationTargetDeviceAsString}.
     * </p>
     * 
     * @return The type of device that the model will run on after the compilation job has completed.
     * @see TargetDevice
     */
    public final String compilationTargetDeviceAsString() {
        return compilationTargetDevice;
    }

    /**
     * <p>
     * The type of OS that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformOs} will return {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationTargetPlatformOsAsString}.
     * </p>
     * 
     * @return The type of OS that the model will run on after the compilation job has completed.
     * @see TargetPlatformOs
     */
    public final TargetPlatformOs compilationTargetPlatformOs() {
        return TargetPlatformOs.fromValue(compilationTargetPlatformOs);
    }

    /**
     * <p>
     * The type of OS that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformOs} will return {@link TargetPlatformOs#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationTargetPlatformOsAsString}.
     * </p>
     * 
     * @return The type of OS that the model will run on after the compilation job has completed.
     * @see TargetPlatformOs
     */
    public final String compilationTargetPlatformOsAsString() {
        return compilationTargetPlatformOs;
    }

    /**
     * <p>
     * The type of architecture that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformArch} will return {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #compilationTargetPlatformArchAsString}.
     * </p>
     * 
     * @return The type of architecture that the model will run on after the compilation job has completed.
     * @see TargetPlatformArch
     */
    public final TargetPlatformArch compilationTargetPlatformArch() {
        return TargetPlatformArch.fromValue(compilationTargetPlatformArch);
    }

    /**
     * <p>
     * The type of architecture that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformArch} will return {@link TargetPlatformArch#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #compilationTargetPlatformArchAsString}.
     * </p>
     * 
     * @return The type of architecture that the model will run on after the compilation job has completed.
     * @see TargetPlatformArch
     */
    public final String compilationTargetPlatformArchAsString() {
        return compilationTargetPlatformArch;
    }

    /**
     * <p>
     * The type of accelerator that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformAccelerator} will return
     * {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compilationTargetPlatformAcceleratorAsString}.
     * </p>
     * 
     * @return The type of accelerator that the model will run on after the compilation job has completed.
     * @see TargetPlatformAccelerator
     */
    public final TargetPlatformAccelerator compilationTargetPlatformAccelerator() {
        return TargetPlatformAccelerator.fromValue(compilationTargetPlatformAccelerator);
    }

    /**
     * <p>
     * The type of accelerator that the model will run on after the compilation job has completed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationTargetPlatformAccelerator} will return
     * {@link TargetPlatformAccelerator#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #compilationTargetPlatformAcceleratorAsString}.
     * </p>
     * 
     * @return The type of accelerator that the model will run on after the compilation job has completed.
     * @see TargetPlatformAccelerator
     */
    public final String compilationTargetPlatformAcceleratorAsString() {
        return compilationTargetPlatformAccelerator;
    }

    /**
     * <p>
     * The time when the model compilation job was last modified.
     * </p>
     * 
     * @return The time when the model compilation job was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public final CompilationJobStatus compilationJobStatus() {
        return CompilationJobStatus.fromValue(compilationJobStatus);
    }

    /**
     * <p>
     * The status of the model compilation job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #compilationJobStatus} will return {@link CompilationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #compilationJobStatusAsString}.
     * </p>
     * 
     * @return The status of the model compilation job.
     * @see CompilationJobStatus
     */
    public final String compilationJobStatusAsString() {
        return compilationJobStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationTargetDeviceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compilationTargetPlatformOsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compilationTargetPlatformArchAsString());
        hashCode = 31 * hashCode + Objects.hashCode(compilationTargetPlatformAcceleratorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompilationJobSummary)) {
            return false;
        }
        CompilationJobSummary other = (CompilationJobSummary) obj;
        return Objects.equals(compilationJobName(), other.compilationJobName())
                && Objects.equals(compilationJobArn(), other.compilationJobArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(compilationStartTime(), other.compilationStartTime())
                && Objects.equals(compilationEndTime(), other.compilationEndTime())
                && Objects.equals(compilationTargetDeviceAsString(), other.compilationTargetDeviceAsString())
                && Objects.equals(compilationTargetPlatformOsAsString(), other.compilationTargetPlatformOsAsString())
                && Objects.equals(compilationTargetPlatformArchAsString(), other.compilationTargetPlatformArchAsString())
                && Objects.equals(compilationTargetPlatformAcceleratorAsString(),
                        other.compilationTargetPlatformAcceleratorAsString())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(compilationJobStatusAsString(), other.compilationJobStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompilationJobSummary").add("CompilationJobName", compilationJobName())
                .add("CompilationJobArn", compilationJobArn()).add("CreationTime", creationTime())
                .add("CompilationStartTime", compilationStartTime()).add("CompilationEndTime", compilationEndTime())
                .add("CompilationTargetDevice", compilationTargetDeviceAsString())
                .add("CompilationTargetPlatformOs", compilationTargetPlatformOsAsString())
                .add("CompilationTargetPlatformArch", compilationTargetPlatformArchAsString())
                .add("CompilationTargetPlatformAccelerator", compilationTargetPlatformAcceleratorAsString())
                .add("LastModifiedTime", lastModifiedTime()).add("CompilationJobStatus", compilationJobStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "CompilationJobArn":
            return Optional.ofNullable(clazz.cast(compilationJobArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CompilationStartTime":
            return Optional.ofNullable(clazz.cast(compilationStartTime()));
        case "CompilationEndTime":
            return Optional.ofNullable(clazz.cast(compilationEndTime()));
        case "CompilationTargetDevice":
            return Optional.ofNullable(clazz.cast(compilationTargetDeviceAsString()));
        case "CompilationTargetPlatformOs":
            return Optional.ofNullable(clazz.cast(compilationTargetPlatformOsAsString()));
        case "CompilationTargetPlatformArch":
            return Optional.ofNullable(clazz.cast(compilationTargetPlatformArchAsString()));
        case "CompilationTargetPlatformAccelerator":
            return Optional.ofNullable(clazz.cast(compilationTargetPlatformAcceleratorAsString()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "CompilationJobStatus":
            return Optional.ofNullable(clazz.cast(compilationJobStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompilationJobName", COMPILATION_JOB_NAME_FIELD);
        map.put("CompilationJobArn", COMPILATION_JOB_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CompilationStartTime", COMPILATION_START_TIME_FIELD);
        map.put("CompilationEndTime", COMPILATION_END_TIME_FIELD);
        map.put("CompilationTargetDevice", COMPILATION_TARGET_DEVICE_FIELD);
        map.put("CompilationTargetPlatformOs", COMPILATION_TARGET_PLATFORM_OS_FIELD);
        map.put("CompilationTargetPlatformArch", COMPILATION_TARGET_PLATFORM_ARCH_FIELD);
        map.put("CompilationTargetPlatformAccelerator", COMPILATION_TARGET_PLATFORM_ACCELERATOR_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("CompilationJobStatus", COMPILATION_JOB_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompilationJobSummary, T> g) {
        return obj -> g.apply((CompilationJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompilationJobSummary> {
        /**
         * <p>
         * The name of the model compilation job that you want a summary for.
         * </p>
         * 
         * @param compilationJobName
         *        The name of the model compilation job that you want a summary for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model compilation job.
         * </p>
         * 
         * @param compilationJobArn
         *        The Amazon Resource Name (ARN) of the model compilation job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobArn(String compilationJobArn);

        /**
         * <p>
         * The time when the model compilation job was created.
         * </p>
         * 
         * @param creationTime
         *        The time when the model compilation job was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time when the model compilation job started.
         * </p>
         * 
         * @param compilationStartTime
         *        The time when the model compilation job started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationStartTime(Instant compilationStartTime);

        /**
         * <p>
         * The time when the model compilation job completed.
         * </p>
         * 
         * @param compilationEndTime
         *        The time when the model compilation job completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationEndTime(Instant compilationEndTime);

        /**
         * <p>
         * The type of device that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetDevice
         *        The type of device that the model will run on after the compilation job has completed.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder compilationTargetDevice(String compilationTargetDevice);

        /**
         * <p>
         * The type of device that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetDevice
         *        The type of device that the model will run on after the compilation job has completed.
         * @see TargetDevice
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetDevice
         */
        Builder compilationTargetDevice(TargetDevice compilationTargetDevice);

        /**
         * <p>
         * The type of OS that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformOs
         *        The type of OS that the model will run on after the compilation job has completed.
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder compilationTargetPlatformOs(String compilationTargetPlatformOs);

        /**
         * <p>
         * The type of OS that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformOs
         *        The type of OS that the model will run on after the compilation job has completed.
         * @see TargetPlatformOs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformOs
         */
        Builder compilationTargetPlatformOs(TargetPlatformOs compilationTargetPlatformOs);

        /**
         * <p>
         * The type of architecture that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformArch
         *        The type of architecture that the model will run on after the compilation job has completed.
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder compilationTargetPlatformArch(String compilationTargetPlatformArch);

        /**
         * <p>
         * The type of architecture that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformArch
         *        The type of architecture that the model will run on after the compilation job has completed.
         * @see TargetPlatformArch
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformArch
         */
        Builder compilationTargetPlatformArch(TargetPlatformArch compilationTargetPlatformArch);

        /**
         * <p>
         * The type of accelerator that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformAccelerator
         *        The type of accelerator that the model will run on after the compilation job has completed.
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder compilationTargetPlatformAccelerator(String compilationTargetPlatformAccelerator);

        /**
         * <p>
         * The type of accelerator that the model will run on after the compilation job has completed.
         * </p>
         * 
         * @param compilationTargetPlatformAccelerator
         *        The type of accelerator that the model will run on after the compilation job has completed.
         * @see TargetPlatformAccelerator
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetPlatformAccelerator
         */
        Builder compilationTargetPlatformAccelerator(TargetPlatformAccelerator compilationTargetPlatformAccelerator);

        /**
         * <p>
         * The time when the model compilation job was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The time when the model compilation job was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(String compilationJobStatus);

        /**
         * <p>
         * The status of the model compilation job.
         * </p>
         * 
         * @param compilationJobStatus
         *        The status of the model compilation job.
         * @see CompilationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CompilationJobStatus
         */
        Builder compilationJobStatus(CompilationJobStatus compilationJobStatus);
    }

    static final class BuilderImpl implements Builder {
        private String compilationJobName;

        private String compilationJobArn;

        private Instant creationTime;

        private Instant compilationStartTime;

        private Instant compilationEndTime;

        private String compilationTargetDevice;

        private String compilationTargetPlatformOs;

        private String compilationTargetPlatformArch;

        private String compilationTargetPlatformAccelerator;

        private Instant lastModifiedTime;

        private String compilationJobStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CompilationJobSummary model) {
            compilationJobName(model.compilationJobName);
            compilationJobArn(model.compilationJobArn);
            creationTime(model.creationTime);
            compilationStartTime(model.compilationStartTime);
            compilationEndTime(model.compilationEndTime);
            compilationTargetDevice(model.compilationTargetDevice);
            compilationTargetPlatformOs(model.compilationTargetPlatformOs);
            compilationTargetPlatformArch(model.compilationTargetPlatformArch);
            compilationTargetPlatformAccelerator(model.compilationTargetPlatformAccelerator);
            lastModifiedTime(model.lastModifiedTime);
            compilationJobStatus(model.compilationJobStatus);
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getCompilationJobArn() {
            return compilationJobArn;
        }

        public final void setCompilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
        }

        @Override
        public final Builder compilationJobArn(String compilationJobArn) {
            this.compilationJobArn = compilationJobArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getCompilationStartTime() {
            return compilationStartTime;
        }

        public final void setCompilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
        }

        @Override
        public final Builder compilationStartTime(Instant compilationStartTime) {
            this.compilationStartTime = compilationStartTime;
            return this;
        }

        public final Instant getCompilationEndTime() {
            return compilationEndTime;
        }

        public final void setCompilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
        }

        @Override
        public final Builder compilationEndTime(Instant compilationEndTime) {
            this.compilationEndTime = compilationEndTime;
            return this;
        }

        public final String getCompilationTargetDevice() {
            return compilationTargetDevice;
        }

        public final void setCompilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
        }

        @Override
        public final Builder compilationTargetDevice(String compilationTargetDevice) {
            this.compilationTargetDevice = compilationTargetDevice;
            return this;
        }

        @Override
        public final Builder compilationTargetDevice(TargetDevice compilationTargetDevice) {
            this.compilationTargetDevice(compilationTargetDevice == null ? null : compilationTargetDevice.toString());
            return this;
        }

        public final String getCompilationTargetPlatformOs() {
            return compilationTargetPlatformOs;
        }

        public final void setCompilationTargetPlatformOs(String compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs = compilationTargetPlatformOs;
        }

        @Override
        public final Builder compilationTargetPlatformOs(String compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs = compilationTargetPlatformOs;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformOs(TargetPlatformOs compilationTargetPlatformOs) {
            this.compilationTargetPlatformOs(compilationTargetPlatformOs == null ? null : compilationTargetPlatformOs.toString());
            return this;
        }

        public final String getCompilationTargetPlatformArch() {
            return compilationTargetPlatformArch;
        }

        public final void setCompilationTargetPlatformArch(String compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch = compilationTargetPlatformArch;
        }

        @Override
        public final Builder compilationTargetPlatformArch(String compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch = compilationTargetPlatformArch;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformArch(TargetPlatformArch compilationTargetPlatformArch) {
            this.compilationTargetPlatformArch(compilationTargetPlatformArch == null ? null : compilationTargetPlatformArch
                    .toString());
            return this;
        }

        public final String getCompilationTargetPlatformAccelerator() {
            return compilationTargetPlatformAccelerator;
        }

        public final void setCompilationTargetPlatformAccelerator(String compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator = compilationTargetPlatformAccelerator;
        }

        @Override
        public final Builder compilationTargetPlatformAccelerator(String compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator = compilationTargetPlatformAccelerator;
            return this;
        }

        @Override
        public final Builder compilationTargetPlatformAccelerator(TargetPlatformAccelerator compilationTargetPlatformAccelerator) {
            this.compilationTargetPlatformAccelerator(compilationTargetPlatformAccelerator == null ? null
                    : compilationTargetPlatformAccelerator.toString());
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getCompilationJobStatus() {
            return compilationJobStatus;
        }

        public final void setCompilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
        }

        @Override
        public final Builder compilationJobStatus(String compilationJobStatus) {
            this.compilationJobStatus = compilationJobStatus;
            return this;
        }

        @Override
        public final Builder compilationJobStatus(CompilationJobStatus compilationJobStatus) {
            this.compilationJobStatus(compilationJobStatus == null ? null : compilationJobStatus.toString());
            return this;
        }

        @Override
        public CompilationJobSummary build() {
            return new CompilationJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
