/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of the compute allocation definition for an entity. This includes the resource sharing option and the
 * setting to preempt low priority tasks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeQuotaConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeQuotaConfig.Builder, ComputeQuotaConfig> {
    private static final SdkField<List<ComputeQuotaResourceConfig>> COMPUTE_QUOTA_RESOURCES_FIELD = SdkField
            .<List<ComputeQuotaResourceConfig>> builder(MarshallingType.LIST)
            .memberName("ComputeQuotaResources")
            .getter(getter(ComputeQuotaConfig::computeQuotaResources))
            .setter(setter(Builder::computeQuotaResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComputeQuotaResourceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComputeQuotaResourceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ResourceSharingConfig> RESOURCE_SHARING_CONFIG_FIELD = SdkField
            .<ResourceSharingConfig> builder(MarshallingType.SDK_POJO).memberName("ResourceSharingConfig")
            .getter(getter(ComputeQuotaConfig::resourceSharingConfig)).setter(setter(Builder::resourceSharingConfig))
            .constructor(ResourceSharingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSharingConfig").build())
            .build();

    private static final SdkField<String> PREEMPT_TEAM_TASKS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreemptTeamTasks").getter(getter(ComputeQuotaConfig::preemptTeamTasksAsString))
            .setter(setter(Builder::preemptTeamTasks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreemptTeamTasks").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_RESOURCES_FIELD,
            RESOURCE_SHARING_CONFIG_FIELD, PREEMPT_TEAM_TASKS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ComputeQuotaResourceConfig> computeQuotaResources;

    private final ResourceSharingConfig resourceSharingConfig;

    private final String preemptTeamTasks;

    private ComputeQuotaConfig(BuilderImpl builder) {
        this.computeQuotaResources = builder.computeQuotaResources;
        this.resourceSharingConfig = builder.resourceSharingConfig;
        this.preemptTeamTasks = builder.preemptTeamTasks;
    }

    /**
     * For responses, this returns true if the service returned a value for the ComputeQuotaResources property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasComputeQuotaResources() {
        return computeQuotaResources != null && !(computeQuotaResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Allocate compute resources by instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasComputeQuotaResources} method.
     * </p>
     * 
     * @return Allocate compute resources by instance types.
     */
    public final List<ComputeQuotaResourceConfig> computeQuotaResources() {
        return computeQuotaResources;
    }

    /**
     * <p>
     * Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other entities
     * within the cluster.
     * </p>
     * 
     * @return Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other
     *         entities within the cluster.
     */
    public final ResourceSharingConfig resourceSharingConfig() {
        return resourceSharingConfig;
    }

    /**
     * <p>
     * Allows workloads from within an entity to preempt same-team workloads. When set to <code>LowerPriority</code>,
     * the entity's lower priority tasks are preempted by their own higher priority tasks.
     * </p>
     * <p>
     * Default is <code>LowerPriority</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preemptTeamTasks}
     * will return {@link PreemptTeamTasks#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preemptTeamTasksAsString}.
     * </p>
     * 
     * @return Allows workloads from within an entity to preempt same-team workloads. When set to
     *         <code>LowerPriority</code>, the entity's lower priority tasks are preempted by their own higher priority
     *         tasks.</p>
     *         <p>
     *         Default is <code>LowerPriority</code>.
     * @see PreemptTeamTasks
     */
    public final PreemptTeamTasks preemptTeamTasks() {
        return PreemptTeamTasks.fromValue(preemptTeamTasks);
    }

    /**
     * <p>
     * Allows workloads from within an entity to preempt same-team workloads. When set to <code>LowerPriority</code>,
     * the entity's lower priority tasks are preempted by their own higher priority tasks.
     * </p>
     * <p>
     * Default is <code>LowerPriority</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preemptTeamTasks}
     * will return {@link PreemptTeamTasks#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preemptTeamTasksAsString}.
     * </p>
     * 
     * @return Allows workloads from within an entity to preempt same-team workloads. When set to
     *         <code>LowerPriority</code>, the entity's lower priority tasks are preempted by their own higher priority
     *         tasks.</p>
     *         <p>
     *         Default is <code>LowerPriority</code>.
     * @see PreemptTeamTasks
     */
    public final String preemptTeamTasksAsString() {
        return preemptTeamTasks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasComputeQuotaResources() ? computeQuotaResources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceSharingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(preemptTeamTasksAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeQuotaConfig)) {
            return false;
        }
        ComputeQuotaConfig other = (ComputeQuotaConfig) obj;
        return hasComputeQuotaResources() == other.hasComputeQuotaResources()
                && Objects.equals(computeQuotaResources(), other.computeQuotaResources())
                && Objects.equals(resourceSharingConfig(), other.resourceSharingConfig())
                && Objects.equals(preemptTeamTasksAsString(), other.preemptTeamTasksAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeQuotaConfig")
                .add("ComputeQuotaResources", hasComputeQuotaResources() ? computeQuotaResources() : null)
                .add("ResourceSharingConfig", resourceSharingConfig()).add("PreemptTeamTasks", preemptTeamTasksAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaResources":
            return Optional.ofNullable(clazz.cast(computeQuotaResources()));
        case "ResourceSharingConfig":
            return Optional.ofNullable(clazz.cast(resourceSharingConfig()));
        case "PreemptTeamTasks":
            return Optional.ofNullable(clazz.cast(preemptTeamTasksAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeQuotaResources", COMPUTE_QUOTA_RESOURCES_FIELD);
        map.put("ResourceSharingConfig", RESOURCE_SHARING_CONFIG_FIELD);
        map.put("PreemptTeamTasks", PREEMPT_TEAM_TASKS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeQuotaConfig, T> g) {
        return obj -> g.apply((ComputeQuotaConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeQuotaConfig> {
        /**
         * <p>
         * Allocate compute resources by instance types.
         * </p>
         * 
         * @param computeQuotaResources
         *        Allocate compute resources by instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaResources(Collection<ComputeQuotaResourceConfig> computeQuotaResources);

        /**
         * <p>
         * Allocate compute resources by instance types.
         * </p>
         * 
         * @param computeQuotaResources
         *        Allocate compute resources by instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaResources(ComputeQuotaResourceConfig... computeQuotaResources);

        /**
         * <p>
         * Allocate compute resources by instance types.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #computeQuotaResources(List<ComputeQuotaResourceConfig>)}.
         * 
         * @param computeQuotaResources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ComputeQuotaResourceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaResources(java.util.Collection<ComputeQuotaResourceConfig>)
         */
        Builder computeQuotaResources(Consumer<ComputeQuotaResourceConfig.Builder>... computeQuotaResources);

        /**
         * <p>
         * Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other
         * entities within the cluster.
         * </p>
         * 
         * @param resourceSharingConfig
         *        Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other
         *        entities within the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSharingConfig(ResourceSharingConfig resourceSharingConfig);

        /**
         * <p>
         * Resource sharing configuration. This defines how an entity can lend and borrow idle compute with other
         * entities within the cluster.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceSharingConfig.Builder} avoiding
         * the need to create one manually via {@link ResourceSharingConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceSharingConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceSharingConfig(ResourceSharingConfig)}.
         * 
         * @param resourceSharingConfig
         *        a consumer that will call methods on {@link ResourceSharingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSharingConfig(ResourceSharingConfig)
         */
        default Builder resourceSharingConfig(Consumer<ResourceSharingConfig.Builder> resourceSharingConfig) {
            return resourceSharingConfig(ResourceSharingConfig.builder().applyMutation(resourceSharingConfig).build());
        }

        /**
         * <p>
         * Allows workloads from within an entity to preempt same-team workloads. When set to <code>LowerPriority</code>
         * , the entity's lower priority tasks are preempted by their own higher priority tasks.
         * </p>
         * <p>
         * Default is <code>LowerPriority</code>.
         * </p>
         * 
         * @param preemptTeamTasks
         *        Allows workloads from within an entity to preempt same-team workloads. When set to
         *        <code>LowerPriority</code>, the entity's lower priority tasks are preempted by their own higher
         *        priority tasks.</p>
         *        <p>
         *        Default is <code>LowerPriority</code>.
         * @see PreemptTeamTasks
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreemptTeamTasks
         */
        Builder preemptTeamTasks(String preemptTeamTasks);

        /**
         * <p>
         * Allows workloads from within an entity to preempt same-team workloads. When set to <code>LowerPriority</code>
         * , the entity's lower priority tasks are preempted by their own higher priority tasks.
         * </p>
         * <p>
         * Default is <code>LowerPriority</code>.
         * </p>
         * 
         * @param preemptTeamTasks
         *        Allows workloads from within an entity to preempt same-team workloads. When set to
         *        <code>LowerPriority</code>, the entity's lower priority tasks are preempted by their own higher
         *        priority tasks.</p>
         *        <p>
         *        Default is <code>LowerPriority</code>.
         * @see PreemptTeamTasks
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreemptTeamTasks
         */
        Builder preemptTeamTasks(PreemptTeamTasks preemptTeamTasks);
    }

    static final class BuilderImpl implements Builder {
        private List<ComputeQuotaResourceConfig> computeQuotaResources = DefaultSdkAutoConstructList.getInstance();

        private ResourceSharingConfig resourceSharingConfig;

        private String preemptTeamTasks;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeQuotaConfig model) {
            computeQuotaResources(model.computeQuotaResources);
            resourceSharingConfig(model.resourceSharingConfig);
            preemptTeamTasks(model.preemptTeamTasks);
        }

        public final List<ComputeQuotaResourceConfig.Builder> getComputeQuotaResources() {
            List<ComputeQuotaResourceConfig.Builder> result = ComputeQuotaResourceConfigListCopier
                    .copyToBuilder(this.computeQuotaResources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setComputeQuotaResources(Collection<ComputeQuotaResourceConfig.BuilderImpl> computeQuotaResources) {
            this.computeQuotaResources = ComputeQuotaResourceConfigListCopier.copyFromBuilder(computeQuotaResources);
        }

        @Override
        public final Builder computeQuotaResources(Collection<ComputeQuotaResourceConfig> computeQuotaResources) {
            this.computeQuotaResources = ComputeQuotaResourceConfigListCopier.copy(computeQuotaResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaResources(ComputeQuotaResourceConfig... computeQuotaResources) {
            computeQuotaResources(Arrays.asList(computeQuotaResources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder computeQuotaResources(Consumer<ComputeQuotaResourceConfig.Builder>... computeQuotaResources) {
            computeQuotaResources(Stream.of(computeQuotaResources)
                    .map(c -> ComputeQuotaResourceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ResourceSharingConfig.Builder getResourceSharingConfig() {
            return resourceSharingConfig != null ? resourceSharingConfig.toBuilder() : null;
        }

        public final void setResourceSharingConfig(ResourceSharingConfig.BuilderImpl resourceSharingConfig) {
            this.resourceSharingConfig = resourceSharingConfig != null ? resourceSharingConfig.build() : null;
        }

        @Override
        public final Builder resourceSharingConfig(ResourceSharingConfig resourceSharingConfig) {
            this.resourceSharingConfig = resourceSharingConfig;
            return this;
        }

        public final String getPreemptTeamTasks() {
            return preemptTeamTasks;
        }

        public final void setPreemptTeamTasks(String preemptTeamTasks) {
            this.preemptTeamTasks = preemptTeamTasks;
        }

        @Override
        public final Builder preemptTeamTasks(String preemptTeamTasks) {
            this.preemptTeamTasks = preemptTeamTasks;
            return this;
        }

        @Override
        public final Builder preemptTeamTasks(PreemptTeamTasks preemptTeamTasks) {
            this.preemptTeamTasks(preemptTeamTasks == null ? null : preemptTeamTasks.toString());
            return this;
        }

        @Override
        public ComputeQuotaConfig build() {
            return new ComputeQuotaConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
