/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration used to run the application image container.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerConfig implements SdkPojo, Serializable, ToCopyableBuilder<ContainerConfig.Builder, ContainerConfig> {
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerArguments")
            .getter(getter(ContainerConfig::containerArguments))
            .setter(setter(Builder::containerArguments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContainerEntrypoint")
            .getter(getter(ContainerConfig::containerEntrypoint))
            .setter(setter(Builder::containerEntrypoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONTAINER_ENVIRONMENT_VARIABLES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("ContainerEnvironmentVariables")
            .getter(getter(ContainerConfig::containerEnvironmentVariables))
            .setter(setter(Builder::containerEnvironmentVariables))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEnvironmentVariables")
                    .build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_ARGUMENTS_FIELD,
            CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ENVIRONMENT_VARIABLES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> containerArguments;

    private final List<String> containerEntrypoint;

    private final Map<String, String> containerEnvironmentVariables;

    private ContainerConfig(BuilderImpl builder) {
        this.containerArguments = builder.containerArguments;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerEnvironmentVariables = builder.containerEnvironmentVariables;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerArguments property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerArguments() {
        return containerArguments != null && !(containerArguments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The arguments for the container when you're running the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerArguments} method.
     * </p>
     * 
     * @return The arguments for the container when you're running the application.
     */
    public final List<String> containerArguments() {
        return containerArguments;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerEntrypoint property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContainerEntrypoint() {
        return containerEntrypoint != null && !(containerEntrypoint instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The entrypoint used to run the application in the container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerEntrypoint} method.
     * </p>
     * 
     * @return The entrypoint used to run the application in the container.
     */
    public final List<String> containerEntrypoint() {
        return containerEntrypoint;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContainerEnvironmentVariables property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasContainerEnvironmentVariables() {
        return containerEnvironmentVariables != null && !(containerEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the container
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContainerEnvironmentVariables} method.
     * </p>
     * 
     * @return The environment variables to set in the container
     */
    public final Map<String, String> containerEnvironmentVariables() {
        return containerEnvironmentVariables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerArguments() ? containerArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerEntrypoint() ? containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasContainerEnvironmentVariables() ? containerEnvironmentVariables() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerConfig)) {
            return false;
        }
        ContainerConfig other = (ContainerConfig) obj;
        return hasContainerArguments() == other.hasContainerArguments()
                && Objects.equals(containerArguments(), other.containerArguments())
                && hasContainerEntrypoint() == other.hasContainerEntrypoint()
                && Objects.equals(containerEntrypoint(), other.containerEntrypoint())
                && hasContainerEnvironmentVariables() == other.hasContainerEnvironmentVariables()
                && Objects.equals(containerEnvironmentVariables(), other.containerEnvironmentVariables());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ContainerConfig")
                .add("ContainerArguments", hasContainerArguments() ? containerArguments() : null)
                .add("ContainerEntrypoint", hasContainerEntrypoint() ? containerEntrypoint() : null)
                .add("ContainerEnvironmentVariables", hasContainerEnvironmentVariables() ? containerEnvironmentVariables() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ContainerArguments":
            return Optional.ofNullable(clazz.cast(containerArguments()));
        case "ContainerEntrypoint":
            return Optional.ofNullable(clazz.cast(containerEntrypoint()));
        case "ContainerEnvironmentVariables":
            return Optional.ofNullable(clazz.cast(containerEnvironmentVariables()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ContainerArguments", CONTAINER_ARGUMENTS_FIELD);
        map.put("ContainerEntrypoint", CONTAINER_ENTRYPOINT_FIELD);
        map.put("ContainerEnvironmentVariables", CONTAINER_ENVIRONMENT_VARIABLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerConfig, T> g) {
        return obj -> g.apply((ContainerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerConfig> {
        /**
         * <p>
         * The arguments for the container when you're running the application.
         * </p>
         * 
         * @param containerArguments
         *        The arguments for the container when you're running the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerArguments(Collection<String> containerArguments);

        /**
         * <p>
         * The arguments for the container when you're running the application.
         * </p>
         * 
         * @param containerArguments
         *        The arguments for the container when you're running the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerArguments(String... containerArguments);

        /**
         * <p>
         * The entrypoint used to run the application in the container.
         * </p>
         * 
         * @param containerEntrypoint
         *        The entrypoint used to run the application in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerEntrypoint(Collection<String> containerEntrypoint);

        /**
         * <p>
         * The entrypoint used to run the application in the container.
         * </p>
         * 
         * @param containerEntrypoint
         *        The entrypoint used to run the application in the container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerEntrypoint(String... containerEntrypoint);

        /**
         * <p>
         * The environment variables to set in the container
         * </p>
         * 
         * @param containerEnvironmentVariables
         *        The environment variables to set in the container
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerEnvironmentVariables(Map<String, String> containerEnvironmentVariables);
    }

    static final class BuilderImpl implements Builder {
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();

        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> containerEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerConfig model) {
            containerArguments(model.containerArguments);
            containerEntrypoint(model.containerEntrypoint);
            containerEnvironmentVariables(model.containerEnvironmentVariables);
        }

        public final Collection<String> getContainerArguments() {
            if (containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return containerArguments;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = CustomImageContainerArgumentsCopier.copy(containerArguments);
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = CustomImageContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String... containerArguments) {
            containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return containerEntrypoint;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = CustomImageContainerEntrypointCopier.copy(containerEntrypoint);
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = CustomImageContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String... containerEntrypoint) {
            containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final Map<String, String> getContainerEnvironmentVariables() {
            if (containerEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return containerEnvironmentVariables;
        }

        public final void setContainerEnvironmentVariables(Map<String, String> containerEnvironmentVariables) {
            this.containerEnvironmentVariables = CustomImageContainerEnvironmentVariablesCopier
                    .copy(containerEnvironmentVariables);
        }

        @Override
        public final Builder containerEnvironmentVariables(Map<String, String> containerEnvironmentVariables) {
            this.containerEnvironmentVariables = CustomImageContainerEnvironmentVariablesCopier
                    .copy(containerEnvironmentVariables);
            return this;
        }

        @Override
        public ContainerConfig build() {
            return new ContainerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
