/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateClusterRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateClusterRequest.Builder, CreateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(CreateClusterRequest::clusterName)).setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<List<ClusterInstanceGroupSpecification>> INSTANCE_GROUPS_FIELD = SdkField
            .<List<ClusterInstanceGroupSpecification>> builder(MarshallingType.LIST)
            .memberName("InstanceGroups")
            .getter(getter(CreateClusterRequest::instanceGroups))
            .setter(setter(Builder::instanceGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterInstanceGroupSpecification> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterInstanceGroupSpecification::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateClusterRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ClusterOrchestrator> ORCHESTRATOR_FIELD = SdkField
            .<ClusterOrchestrator> builder(MarshallingType.SDK_POJO).memberName("Orchestrator")
            .getter(getter(CreateClusterRequest::orchestrator)).setter(setter(Builder::orchestrator))
            .constructor(ClusterOrchestrator::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Orchestrator").build()).build();

    private static final SdkField<String> NODE_RECOVERY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeRecovery").getter(getter(CreateClusterRequest::nodeRecoveryAsString))
            .setter(setter(Builder::nodeRecovery))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeRecovery").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD,
            INSTANCE_GROUPS_FIELD, VPC_CONFIG_FIELD, TAGS_FIELD, ORCHESTRATOR_FIELD, NODE_RECOVERY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clusterName;

    private final List<ClusterInstanceGroupSpecification> instanceGroups;

    private final VpcConfig vpcConfig;

    private final List<Tag> tags;

    private final ClusterOrchestrator orchestrator;

    private final String nodeRecovery;

    private CreateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.instanceGroups = builder.instanceGroups;
        this.vpcConfig = builder.vpcConfig;
        this.tags = builder.tags;
        this.orchestrator = builder.orchestrator;
        this.nodeRecovery = builder.nodeRecovery;
    }

    /**
     * <p>
     * The name for the new SageMaker HyperPod cluster.
     * </p>
     * 
     * @return The name for the new SageMaker HyperPod cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceGroups() {
        return instanceGroups != null && !(instanceGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance groups to be created in the SageMaker HyperPod cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceGroups} method.
     * </p>
     * 
     * @return The instance groups to be created in the SageMaker HyperPod cluster.
     */
    public final List<ClusterInstanceGroupSpecification> instanceGroups() {
        return instanceGroups;
    }

    /**
     * Returns the value of the VpcConfig property for this object.
     * 
     * @return The value of the VpcConfig property for this object.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags to
     * your cluster in the same way you add them in other Amazon Web Services services that support tagging. To learn
     * more about tagging Amazon Web Services resources in general, see <a
     * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services Resources
     * User Guide</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add
     *         tags to your cluster in the same way you add them in other Amazon Web Services services that support
     *         tagging. To learn more about tagging Amazon Web Services resources in general, see <a
     *         href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
     *         Resources User Guide</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value is
     * <code>"eks"</code>, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
     * </p>
     * 
     * @return The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value
     *         is <code>"eks"</code>, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the
     *         orchestrator.
     */
    public final ClusterOrchestrator orchestrator() {
        return orchestrator;
    }

    /**
     * <p>
     * The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker HyperPod
     * will automatically reboot or replace faulty nodes when issues are detected. When set to <code>None</code>,
     * cluster administrators will need to manually manage any faulty cluster instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker
     *         HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to
     *         <code>None</code>, cluster administrators will need to manually manage any faulty cluster instances.
     * @see ClusterNodeRecovery
     */
    public final ClusterNodeRecovery nodeRecovery() {
        return ClusterNodeRecovery.fromValue(nodeRecovery);
    }

    /**
     * <p>
     * The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker HyperPod
     * will automatically reboot or replace faulty nodes when issues are detected. When set to <code>None</code>,
     * cluster administrators will need to manually manage any faulty cluster instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeRecovery} will
     * return {@link ClusterNodeRecovery#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nodeRecoveryAsString}.
     * </p>
     * 
     * @return The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker
     *         HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to
     *         <code>None</code>, cluster administrators will need to manually manage any faulty cluster instances.
     * @see ClusterNodeRecovery
     */
    public final String nodeRecoveryAsString() {
        return nodeRecovery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroups() ? instanceGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(orchestrator());
        hashCode = 31 * hashCode + Objects.hashCode(nodeRecoveryAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest) obj;
        return Objects.equals(clusterName(), other.clusterName()) && hasInstanceGroups() == other.hasInstanceGroups()
                && Objects.equals(instanceGroups(), other.instanceGroups()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(orchestrator(), other.orchestrator())
                && Objects.equals(nodeRecoveryAsString(), other.nodeRecoveryAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateClusterRequest").add("ClusterName", clusterName())
                .add("InstanceGroups", hasInstanceGroups() ? instanceGroups() : null).add("VpcConfig", vpcConfig())
                .add("Tags", hasTags() ? tags() : null).add("Orchestrator", orchestrator())
                .add("NodeRecovery", nodeRecoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "InstanceGroups":
            return Optional.ofNullable(clazz.cast(instanceGroups()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "Orchestrator":
            return Optional.ofNullable(clazz.cast(orchestrator()));
        case "NodeRecovery":
            return Optional.ofNullable(clazz.cast(nodeRecoveryAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClusterName", CLUSTER_NAME_FIELD);
        map.put("InstanceGroups", INSTANCE_GROUPS_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("Orchestrator", ORCHESTRATOR_FIELD);
        map.put("NodeRecovery", NODE_RECOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateClusterRequest, T> g) {
        return obj -> g.apply((CreateClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateClusterRequest> {
        /**
         * <p>
         * The name for the new SageMaker HyperPod cluster.
         * </p>
         * 
         * @param clusterName
         *        The name for the new SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * The instance groups to be created in the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups to be created in the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups);

        /**
         * <p>
         * The instance groups to be created in the SageMaker HyperPod cluster.
         * </p>
         * 
         * @param instanceGroups
         *        The instance groups to be created in the SageMaker HyperPod cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroups(ClusterInstanceGroupSpecification... instanceGroups);

        /**
         * <p>
         * The instance groups to be created in the SageMaker HyperPod cluster.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #instanceGroups(List<ClusterInstanceGroupSpecification>)}.
         * 
         * @param instanceGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ClusterInstanceGroupSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceGroups(java.util.Collection<ClusterInstanceGroupSpecification>)
         */
        Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder>... instanceGroups);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * @param vpcConfig
         *        The new value for the VpcConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * Sets the value of the VpcConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags
         * to your cluster in the same way you add them in other Amazon Web Services services that support tagging. To
         * learn more about tagging Amazon Web Services resources in general, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources User Guide</a>.
         * </p>
         * 
         * @param tags
         *        Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can
         *        add tags to your cluster in the same way you add them in other Amazon Web Services services that
         *        support tagging. To learn more about tagging Amazon Web Services resources in general, see <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web
         *        Services Resources User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags
         * to your cluster in the same way you add them in other Amazon Web Services services that support tagging. To
         * learn more about tagging Amazon Web Services resources in general, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources User Guide</a>.
         * </p>
         * 
         * @param tags
         *        Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can
         *        add tags to your cluster in the same way you add them in other Amazon Web Services services that
         *        support tagging. To learn more about tagging Amazon Web Services resources in general, see <a
         *        href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web
         *        Services Resources User Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Custom tags for managing the SageMaker HyperPod cluster as an Amazon Web Services resource. You can add tags
         * to your cluster in the same way you add them in other Amazon Web Services services that support tagging. To
         * learn more about tagging Amazon Web Services resources in general, see <a
         * href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html">Tagging Amazon Web Services
         * Resources User Guide</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value is
         * <code>"eks"</code>, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
         * </p>
         * 
         * @param orchestrator
         *        The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported
         *        value is <code>"eks"</code>, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the
         *        orchestrator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orchestrator(ClusterOrchestrator orchestrator);

        /**
         * <p>
         * The type of orchestrator to use for the SageMaker HyperPod cluster. Currently, the only supported value is
         * <code>"eks"</code>, which is to use an Amazon Elastic Kubernetes Service (EKS) cluster as the orchestrator.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterOrchestrator.Builder} avoiding the
         * need to create one manually via {@link ClusterOrchestrator#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterOrchestrator.Builder#build()} is called immediately and
         * its result is passed to {@link #orchestrator(ClusterOrchestrator)}.
         * 
         * @param orchestrator
         *        a consumer that will call methods on {@link ClusterOrchestrator.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #orchestrator(ClusterOrchestrator)
         */
        default Builder orchestrator(Consumer<ClusterOrchestrator.Builder> orchestrator) {
            return orchestrator(ClusterOrchestrator.builder().applyMutation(orchestrator).build());
        }

        /**
         * <p>
         * The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker
         * HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to
         * <code>None</code>, cluster administrators will need to manually manage any faulty cluster instances.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>,
         *        SageMaker HyperPod will automatically reboot or replace faulty nodes when issues are detected. When
         *        set to <code>None</code>, cluster administrators will need to manually manage any faulty cluster
         *        instances.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(String nodeRecovery);

        /**
         * <p>
         * The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>, SageMaker
         * HyperPod will automatically reboot or replace faulty nodes when issues are detected. When set to
         * <code>None</code>, cluster administrators will need to manually manage any faulty cluster instances.
         * </p>
         * 
         * @param nodeRecovery
         *        The node recovery mode for the SageMaker HyperPod cluster. When set to <code>Automatic</code>,
         *        SageMaker HyperPod will automatically reboot or replace faulty nodes when issues are detected. When
         *        set to <code>None</code>, cluster administrators will need to manually manage any faulty cluster
         *        instances.
         * @see ClusterNodeRecovery
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClusterNodeRecovery
         */
        Builder nodeRecovery(ClusterNodeRecovery nodeRecovery);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String clusterName;

        private List<ClusterInstanceGroupSpecification> instanceGroups = DefaultSdkAutoConstructList.getInstance();

        private VpcConfig vpcConfig;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private ClusterOrchestrator orchestrator;

        private String nodeRecovery;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateClusterRequest model) {
            super(model);
            clusterName(model.clusterName);
            instanceGroups(model.instanceGroups);
            vpcConfig(model.vpcConfig);
            tags(model.tags);
            orchestrator(model.orchestrator);
            nodeRecovery(model.nodeRecovery);
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final List<ClusterInstanceGroupSpecification.Builder> getInstanceGroups() {
            List<ClusterInstanceGroupSpecification.Builder> result = ClusterInstanceGroupSpecificationsCopier
                    .copyToBuilder(this.instanceGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceGroups(Collection<ClusterInstanceGroupSpecification.BuilderImpl> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copyFromBuilder(instanceGroups);
        }

        @Override
        public final Builder instanceGroups(Collection<ClusterInstanceGroupSpecification> instanceGroups) {
            this.instanceGroups = ClusterInstanceGroupSpecificationsCopier.copy(instanceGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(ClusterInstanceGroupSpecification... instanceGroups) {
            instanceGroups(Arrays.asList(instanceGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroups(Consumer<ClusterInstanceGroupSpecification.Builder>... instanceGroups) {
            instanceGroups(Stream.of(instanceGroups)
                    .map(c -> ClusterInstanceGroupSpecification.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final ClusterOrchestrator.Builder getOrchestrator() {
            return orchestrator != null ? orchestrator.toBuilder() : null;
        }

        public final void setOrchestrator(ClusterOrchestrator.BuilderImpl orchestrator) {
            this.orchestrator = orchestrator != null ? orchestrator.build() : null;
        }

        @Override
        public final Builder orchestrator(ClusterOrchestrator orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        public final String getNodeRecovery() {
            return nodeRecovery;
        }

        public final void setNodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
        }

        @Override
        public final Builder nodeRecovery(String nodeRecovery) {
            this.nodeRecovery = nodeRecovery;
            return this;
        }

        @Override
        public final Builder nodeRecovery(ClusterNodeRecovery nodeRecovery) {
            this.nodeRecovery(nodeRecovery == null ? null : nodeRecovery.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateClusterRequest build() {
            return new CreateClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
