/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCompilationJobRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateCompilationJobRequest.Builder, CreateCompilationJobRequest> {
    private static final SdkField<String> COMPILATION_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompilationJobName").getter(getter(CreateCompilationJobRequest::compilationJobName))
            .setter(setter(Builder::compilationJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompilationJobName").build())
            .build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateCompilationJobRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<String> MODEL_PACKAGE_VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelPackageVersionArn").getter(getter(CreateCompilationJobRequest::modelPackageVersionArn))
            .setter(setter(Builder::modelPackageVersionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelPackageVersionArn").build())
            .build();

    private static final SdkField<InputConfig> INPUT_CONFIG_FIELD = SdkField.<InputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("InputConfig").getter(getter(CreateCompilationJobRequest::inputConfig))
            .setter(setter(Builder::inputConfig)).constructor(InputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()).build();

    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.<OutputConfig> builder(MarshallingType.SDK_POJO)
            .memberName("OutputConfig").getter(getter(CreateCompilationJobRequest::outputConfig))
            .setter(setter(Builder::outputConfig)).constructor(OutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()).build();

    private static final SdkField<NeoVpcConfig> VPC_CONFIG_FIELD = SdkField.<NeoVpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(CreateCompilationJobRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(NeoVpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField
            .<StoppingCondition> builder(MarshallingType.SDK_POJO).memberName("StoppingCondition")
            .getter(getter(CreateCompilationJobRequest::stoppingCondition)).setter(setter(Builder::stoppingCondition))
            .constructor(StoppingCondition::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateCompilationJobRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPILATION_JOB_NAME_FIELD,
            ROLE_ARN_FIELD, MODEL_PACKAGE_VERSION_ARN_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, VPC_CONFIG_FIELD,
            STOPPING_CONDITION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String compilationJobName;

    private final String roleArn;

    private final String modelPackageVersionArn;

    private final InputConfig inputConfig;

    private final OutputConfig outputConfig;

    private final NeoVpcConfig vpcConfig;

    private final StoppingCondition stoppingCondition;

    private final List<Tag> tags;

    private CreateCompilationJobRequest(BuilderImpl builder) {
        super(builder);
        this.compilationJobName = builder.compilationJobName;
        this.roleArn = builder.roleArn;
        this.modelPackageVersionArn = builder.modelPackageVersionArn;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A name for the model compilation job. The name must be unique within the Amazon Web Services Region and within
     * your Amazon Web Services account.
     * </p>
     * 
     * @return A name for the model compilation job. The name must be unique within the Amazon Web Services Region and
     *         within your Amazon Web Services account.
     */
    public final String compilationJobName() {
        return compilationJobName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker AI to perform tasks on your behalf.
     * </p>
     * <p>
     * During model compilation, Amazon SageMaker AI needs your permission to:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Read input data from an S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Write model artifacts to an S3 bucket
     * </p>
     * </li>
     * <li>
     * <p>
     * Write logs to Amazon CloudWatch Logs
     * </p>
     * </li>
     * <li>
     * <p>
     * Publish metrics to Amazon CloudWatch
     * </p>
     * </li>
     * </ul>
     * <p>
     * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker AI, the caller
     * of this API must have the <code>iam:PassRole</code> permission. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker AI Roles.</a>
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker AI to perform tasks on your
     *         behalf. </p>
     *         <p>
     *         During model compilation, Amazon SageMaker AI needs your permission to:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Read input data from an S3 bucket
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Write model artifacts to an S3 bucket
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Write logs to Amazon CloudWatch Logs
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Publish metrics to Amazon CloudWatch
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker AI,
     *         the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker AI
     *         Roles.</a>
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a versioned model package. Provide either a <code>ModelPackageVersionArn</code>
     * or an <code>InputConfig</code> object in the request syntax. The presence of both objects in the
     * <code>CreateCompilationJob</code> request will return an exception.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a versioned model package. Provide either a
     *         <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The
     *         presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.
     */
    public final String modelPackageVersionArn() {
        return modelPackageVersionArn;
    }

    /**
     * <p>
     * Provides information about the location of input model artifacts, the name and shape of the expected data inputs,
     * and the framework in which the model was trained.
     * </p>
     * 
     * @return Provides information about the location of input model artifacts, the name and shape of the expected data
     *         inputs, and the framework in which the model was trained.
     */
    public final InputConfig inputConfig() {
        return inputConfig;
    }

    /**
     * <p>
     * Provides information about the output location for the compiled model and the target device the model runs on.
     * </p>
     * 
     * @return Provides information about the output location for the compiled model and the target device the model
     *         runs on.
     */
    public final OutputConfig outputConfig() {
        return outputConfig;
    }

    /**
     * <p>
     * A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> object
     * that specifies the VPC that you want your compilation job to connect to. Control access to your models by
     * configuring the VPC. For more information, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an Amazon
     * Virtual Private Cloud</a>.
     * </p>
     * 
     * @return A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a>
     *         object that specifies the VPC that you want your compilation job to connect to. Control access to your
     *         models by configuring the VPC. For more information, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
     *         Amazon Virtual Private Cloud</a>.
     */
    public final NeoVpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
     * SageMaker AI ends the compilation job. Use this API to cap model training costs.
     * </p>
     * 
     * @return Specifies a limit to how long a model compilation job can run. When the job reaches the time limit,
     *         Amazon SageMaker AI ends the compilation job. Use this API to cap model training costs.
     */
    public final StoppingCondition stoppingCondition() {
        return stoppingCondition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different ways,
     * for example, by purpose, owner, or environment. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services Resources</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
     *         different ways, for example, by purpose, owner, or environment. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         Resources</a>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(compilationJobName());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelPackageVersionArn());
        hashCode = 31 * hashCode + Objects.hashCode(inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCompilationJobRequest)) {
            return false;
        }
        CreateCompilationJobRequest other = (CreateCompilationJobRequest) obj;
        return Objects.equals(compilationJobName(), other.compilationJobName()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(modelPackageVersionArn(), other.modelPackageVersionArn())
                && Objects.equals(inputConfig(), other.inputConfig()) && Objects.equals(outputConfig(), other.outputConfig())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(stoppingCondition(), other.stoppingCondition()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCompilationJobRequest").add("CompilationJobName", compilationJobName())
                .add("RoleArn", roleArn()).add("ModelPackageVersionArn", modelPackageVersionArn())
                .add("InputConfig", inputConfig()).add("OutputConfig", outputConfig()).add("VpcConfig", vpcConfig())
                .add("StoppingCondition", stoppingCondition()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompilationJobName":
            return Optional.ofNullable(clazz.cast(compilationJobName()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "ModelPackageVersionArn":
            return Optional.ofNullable(clazz.cast(modelPackageVersionArn()));
        case "InputConfig":
            return Optional.ofNullable(clazz.cast(inputConfig()));
        case "OutputConfig":
            return Optional.ofNullable(clazz.cast(outputConfig()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "StoppingCondition":
            return Optional.ofNullable(clazz.cast(stoppingCondition()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompilationJobName", COMPILATION_JOB_NAME_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("ModelPackageVersionArn", MODEL_PACKAGE_VERSION_ARN_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("StoppingCondition", STOPPING_CONDITION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCompilationJobRequest, T> g) {
        return obj -> g.apply((CreateCompilationJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCompilationJobRequest> {
        /**
         * <p>
         * A name for the model compilation job. The name must be unique within the Amazon Web Services Region and
         * within your Amazon Web Services account.
         * </p>
         * 
         * @param compilationJobName
         *        A name for the model compilation job. The name must be unique within the Amazon Web Services Region
         *        and within your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compilationJobName(String compilationJobName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker AI to perform tasks on your
         * behalf.
         * </p>
         * <p>
         * During model compilation, Amazon SageMaker AI needs your permission to:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Read input data from an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * Write model artifacts to an S3 bucket
         * </p>
         * </li>
         * <li>
         * <p>
         * Write logs to Amazon CloudWatch Logs
         * </p>
         * </li>
         * <li>
         * <p>
         * Publish metrics to Amazon CloudWatch
         * </p>
         * </li>
         * </ul>
         * <p>
         * You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker AI, the
         * caller of this API must have the <code>iam:PassRole</code> permission. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker AI Roles.</a>
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) of an IAM role that enables Amazon SageMaker AI to perform tasks on
         *        your behalf. </p>
         *        <p>
         *        During model compilation, Amazon SageMaker AI needs your permission to:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Read input data from an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Write model artifacts to an S3 bucket
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Write logs to Amazon CloudWatch Logs
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Publish metrics to Amazon CloudWatch
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        You grant permissions for all of these tasks to an IAM role. To pass this role to Amazon SageMaker AI,
         *        the caller of this API must have the <code>iam:PassRole</code> permission. For more information, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html">Amazon SageMaker AI
         *        Roles.</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a versioned model package. Provide either a
         * <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The presence
         * of both objects in the <code>CreateCompilationJob</code> request will return an exception.
         * </p>
         * 
         * @param modelPackageVersionArn
         *        The Amazon Resource Name (ARN) of a versioned model package. Provide either a
         *        <code>ModelPackageVersionArn</code> or an <code>InputConfig</code> object in the request syntax. The
         *        presence of both objects in the <code>CreateCompilationJob</code> request will return an exception.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelPackageVersionArn(String modelPackageVersionArn);

        /**
         * <p>
         * Provides information about the location of input model artifacts, the name and shape of the expected data
         * inputs, and the framework in which the model was trained.
         * </p>
         * 
         * @param inputConfig
         *        Provides information about the location of input model artifacts, the name and shape of the expected
         *        data inputs, and the framework in which the model was trained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputConfig(InputConfig inputConfig);

        /**
         * <p>
         * Provides information about the location of input model artifacts, the name and shape of the expected data
         * inputs, and the framework in which the model was trained.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputConfig.Builder} avoiding the need to
         * create one manually via {@link InputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #inputConfig(InputConfig)}.
         * 
         * @param inputConfig
         *        a consumer that will call methods on {@link InputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inputConfig(InputConfig)
         */
        default Builder inputConfig(Consumer<InputConfig.Builder> inputConfig) {
            return inputConfig(InputConfig.builder().applyMutation(inputConfig).build());
        }

        /**
         * <p>
         * Provides information about the output location for the compiled model and the target device the model runs
         * on.
         * </p>
         * 
         * @param outputConfig
         *        Provides information about the output location for the compiled model and the target device the model
         *        runs on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputConfig(OutputConfig outputConfig);

        /**
         * <p>
         * Provides information about the output location for the compiled model and the target device the model runs
         * on.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputConfig.Builder} avoiding the need
         * to create one manually via {@link OutputConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputConfig(OutputConfig)}.
         * 
         * @param outputConfig
         *        a consumer that will call methods on {@link OutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputConfig(OutputConfig)
         */
        default Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return outputConfig(OutputConfig.builder().applyMutation(outputConfig).build());
        }

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> object
         * that specifies the VPC that you want your compilation job to connect to. Control access to your models by
         * configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * 
         * @param vpcConfig
         *        A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a>
         *        object that specifies the VPC that you want your compilation job to connect to. Control access to your
         *        models by configuring the VPC. For more information, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using
         *        an Amazon Virtual Private Cloud</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(NeoVpcConfig vpcConfig);

        /**
         * <p>
         * A <a href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html">VpcConfig</a> object
         * that specifies the VPC that you want your compilation job to connect to. Control access to your models by
         * configuring the VPC. For more information, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/neo-vpc.html">Protect Compilation Jobs by Using an
         * Amazon Virtual Private Cloud</a>.
         * </p>
         * This is a convenience method that creates an instance of the {@link NeoVpcConfig.Builder} avoiding the need
         * to create one manually via {@link NeoVpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NeoVpcConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfig(NeoVpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link NeoVpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(NeoVpcConfig)
         */
        default Builder vpcConfig(Consumer<NeoVpcConfig.Builder> vpcConfig) {
            return vpcConfig(NeoVpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
         * SageMaker AI ends the compilation job. Use this API to cap model training costs.
         * </p>
         * 
         * @param stoppingCondition
         *        Specifies a limit to how long a model compilation job can run. When the job reaches the time limit,
         *        Amazon SageMaker AI ends the compilation job. Use this API to cap model training costs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stoppingCondition(StoppingCondition stoppingCondition);

        /**
         * <p>
         * Specifies a limit to how long a model compilation job can run. When the job reaches the time limit, Amazon
         * SageMaker AI ends the compilation job. Use this API to cap model training costs.
         * </p>
         * This is a convenience method that creates an instance of the {@link StoppingCondition.Builder} avoiding the
         * need to create one manually via {@link StoppingCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StoppingCondition.Builder#build()} is called immediately and its
         * result is passed to {@link #stoppingCondition(StoppingCondition)}.
         * 
         * @param stoppingCondition
         *        a consumer that will call methods on {@link StoppingCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stoppingCondition(StoppingCondition)
         */
        default Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return stoppingCondition(StoppingCondition.builder().applyMutation(stoppingCondition).build());
        }

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in
         *        different ways, for example, by purpose, owner, or environment. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        Resources</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs. You can use tags to categorize your Amazon Web Services resources in different
         * ways, for example, by purpose, owner, or environment. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * Resources</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String compilationJobName;

        private String roleArn;

        private String modelPackageVersionArn;

        private InputConfig inputConfig;

        private OutputConfig outputConfig;

        private NeoVpcConfig vpcConfig;

        private StoppingCondition stoppingCondition;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCompilationJobRequest model) {
            super(model);
            compilationJobName(model.compilationJobName);
            roleArn(model.roleArn);
            modelPackageVersionArn(model.modelPackageVersionArn);
            inputConfig(model.inputConfig);
            outputConfig(model.outputConfig);
            vpcConfig(model.vpcConfig);
            stoppingCondition(model.stoppingCondition);
            tags(model.tags);
        }

        public final String getCompilationJobName() {
            return compilationJobName;
        }

        public final void setCompilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
        }

        @Override
        public final Builder compilationJobName(String compilationJobName) {
            this.compilationJobName = compilationJobName;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getModelPackageVersionArn() {
            return modelPackageVersionArn;
        }

        public final void setModelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
        }

        @Override
        public final Builder modelPackageVersionArn(String modelPackageVersionArn) {
            this.modelPackageVersionArn = modelPackageVersionArn;
            return this;
        }

        public final InputConfig.Builder getInputConfig() {
            return inputConfig != null ? inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(InputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(InputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return outputConfig != null ? outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final NeoVpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(NeoVpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(NeoVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return stoppingCondition != null ? stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCompilationJobRequest build() {
            return new CreateCompilationJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
