/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateComputeQuotaRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateComputeQuotaRequest.Builder, CreateComputeQuotaRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateComputeQuotaRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateComputeQuotaRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(CreateComputeQuotaRequest::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<ComputeQuotaConfig> COMPUTE_QUOTA_CONFIG_FIELD = SdkField
            .<ComputeQuotaConfig> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaConfig")
            .getter(getter(CreateComputeQuotaRequest::computeQuotaConfig)).setter(setter(Builder::computeQuotaConfig))
            .constructor(ComputeQuotaConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaConfig").build())
            .build();

    private static final SdkField<ComputeQuotaTarget> COMPUTE_QUOTA_TARGET_FIELD = SdkField
            .<ComputeQuotaTarget> builder(MarshallingType.SDK_POJO).memberName("ComputeQuotaTarget")
            .getter(getter(CreateComputeQuotaRequest::computeQuotaTarget)).setter(setter(Builder::computeQuotaTarget))
            .constructor(ComputeQuotaTarget::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaTarget").build())
            .build();

    private static final SdkField<String> ACTIVATION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationState").getter(getter(CreateComputeQuotaRequest::activationStateAsString))
            .setter(setter(Builder::activationState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationState").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateComputeQuotaRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            CLUSTER_ARN_FIELD, COMPUTE_QUOTA_CONFIG_FIELD, COMPUTE_QUOTA_TARGET_FIELD, ACTIVATION_STATE_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final String clusterArn;

    private final ComputeQuotaConfig computeQuotaConfig;

    private final ComputeQuotaTarget computeQuotaTarget;

    private final String activationState;

    private final List<Tag> tags;

    private CreateComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.clusterArn = builder.clusterArn;
        this.computeQuotaConfig = builder.computeQuotaConfig;
        this.computeQuotaTarget = builder.computeQuotaTarget;
        this.activationState = builder.activationState;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Name to the compute allocation definition.
     * </p>
     * 
     * @return Name to the compute allocation definition.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Description of the compute allocation definition.
     * </p>
     * 
     * @return Description of the compute allocation definition.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * ARN of the cluster.
     * </p>
     * 
     * @return ARN of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * Configuration of the compute allocation definition. This includes the resource sharing option, and the setting to
     * preempt low priority tasks.
     * </p>
     * 
     * @return Configuration of the compute allocation definition. This includes the resource sharing option, and the
     *         setting to preempt low priority tasks.
     */
    public final ComputeQuotaConfig computeQuotaConfig() {
        return computeQuotaConfig;
    }

    /**
     * <p>
     * The target entity to allocate compute resources to.
     * </p>
     * 
     * @return The target entity to allocate compute resources to.
     */
    public final ComputeQuotaTarget computeQuotaTarget() {
        return computeQuotaTarget;
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final ActivationState activationState() {
        return ActivationState.fromValue(activationState);
    }

    /**
     * <p>
     * The state of the compute allocation being described. Use to enable or disable compute allocation.
     * </p>
     * <p>
     * Default is <code>Enabled</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #activationState}
     * will return {@link ActivationState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #activationStateAsString}.
     * </p>
     * 
     * @return The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
     *         <p>
     *         Default is <code>Enabled</code>.
     * @see ActivationState
     */
    public final String activationStateAsString() {
        return activationState;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags of the compute allocation definition.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags of the compute allocation definition.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaTarget());
        hashCode = 31 * hashCode + Objects.hashCode(activationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeQuotaRequest)) {
            return false;
        }
        CreateComputeQuotaRequest other = (CreateComputeQuotaRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(computeQuotaConfig(), other.computeQuotaConfig())
                && Objects.equals(computeQuotaTarget(), other.computeQuotaTarget())
                && Objects.equals(activationStateAsString(), other.activationStateAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateComputeQuotaRequest").add("Name", name()).add("Description", description())
                .add("ClusterArn", clusterArn()).add("ComputeQuotaConfig", computeQuotaConfig())
                .add("ComputeQuotaTarget", computeQuotaTarget()).add("ActivationState", activationStateAsString())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "ComputeQuotaConfig":
            return Optional.ofNullable(clazz.cast(computeQuotaConfig()));
        case "ComputeQuotaTarget":
            return Optional.ofNullable(clazz.cast(computeQuotaTarget()));
        case "ActivationState":
            return Optional.ofNullable(clazz.cast(activationStateAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("ComputeQuotaConfig", COMPUTE_QUOTA_CONFIG_FIELD);
        map.put("ComputeQuotaTarget", COMPUTE_QUOTA_TARGET_FIELD);
        map.put("ActivationState", ACTIVATION_STATE_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateComputeQuotaRequest, T> g) {
        return obj -> g.apply((CreateComputeQuotaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateComputeQuotaRequest> {
        /**
         * <p>
         * Name to the compute allocation definition.
         * </p>
         * 
         * @param name
         *        Name to the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Description of the compute allocation definition.
         * </p>
         * 
         * @param description
         *        Description of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        ARN of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * 
         * @param computeQuotaConfig
         *        Configuration of the compute allocation definition. This includes the resource sharing option, and the
         *        setting to preempt low priority tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig);

        /**
         * <p>
         * Configuration of the compute allocation definition. This includes the resource sharing option, and the
         * setting to preempt low priority tasks.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaConfig.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaConfig(ComputeQuotaConfig)}.
         * 
         * @param computeQuotaConfig
         *        a consumer that will call methods on {@link ComputeQuotaConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaConfig(ComputeQuotaConfig)
         */
        default Builder computeQuotaConfig(Consumer<ComputeQuotaConfig.Builder> computeQuotaConfig) {
            return computeQuotaConfig(ComputeQuotaConfig.builder().applyMutation(computeQuotaConfig).build());
        }

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * 
         * @param computeQuotaTarget
         *        The target entity to allocate compute resources to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget);

        /**
         * <p>
         * The target entity to allocate compute resources to.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeQuotaTarget.Builder} avoiding the
         * need to create one manually via {@link ComputeQuotaTarget#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeQuotaTarget.Builder#build()} is called immediately and its
         * result is passed to {@link #computeQuotaTarget(ComputeQuotaTarget)}.
         * 
         * @param computeQuotaTarget
         *        a consumer that will call methods on {@link ComputeQuotaTarget.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeQuotaTarget(ComputeQuotaTarget)
         */
        default Builder computeQuotaTarget(Consumer<ComputeQuotaTarget.Builder> computeQuotaTarget) {
            return computeQuotaTarget(ComputeQuotaTarget.builder().applyMutation(computeQuotaTarget).build());
        }

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(String activationState);

        /**
         * <p>
         * The state of the compute allocation being described. Use to enable or disable compute allocation.
         * </p>
         * <p>
         * Default is <code>Enabled</code>.
         * </p>
         * 
         * @param activationState
         *        The state of the compute allocation being described. Use to enable or disable compute allocation.</p>
         *        <p>
         *        Default is <code>Enabled</code>.
         * @see ActivationState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActivationState
         */
        Builder activationState(ActivationState activationState);

        /**
         * <p>
         * Tags of the compute allocation definition.
         * </p>
         * 
         * @param tags
         *        Tags of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags of the compute allocation definition.
         * </p>
         * 
         * @param tags
         *        Tags of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags of the compute allocation definition.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String clusterArn;

        private ComputeQuotaConfig computeQuotaConfig;

        private ComputeQuotaTarget computeQuotaTarget;

        private String activationState;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeQuotaRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            clusterArn(model.clusterArn);
            computeQuotaConfig(model.computeQuotaConfig);
            computeQuotaTarget(model.computeQuotaTarget);
            activationState(model.activationState);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final ComputeQuotaConfig.Builder getComputeQuotaConfig() {
            return computeQuotaConfig != null ? computeQuotaConfig.toBuilder() : null;
        }

        public final void setComputeQuotaConfig(ComputeQuotaConfig.BuilderImpl computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig != null ? computeQuotaConfig.build() : null;
        }

        @Override
        public final Builder computeQuotaConfig(ComputeQuotaConfig computeQuotaConfig) {
            this.computeQuotaConfig = computeQuotaConfig;
            return this;
        }

        public final ComputeQuotaTarget.Builder getComputeQuotaTarget() {
            return computeQuotaTarget != null ? computeQuotaTarget.toBuilder() : null;
        }

        public final void setComputeQuotaTarget(ComputeQuotaTarget.BuilderImpl computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget != null ? computeQuotaTarget.build() : null;
        }

        @Override
        public final Builder computeQuotaTarget(ComputeQuotaTarget computeQuotaTarget) {
            this.computeQuotaTarget = computeQuotaTarget;
            return this;
        }

        public final String getActivationState() {
            return activationState;
        }

        public final void setActivationState(String activationState) {
            this.activationState = activationState;
        }

        @Override
        public final Builder activationState(String activationState) {
            this.activationState = activationState;
            return this;
        }

        @Override
        public final Builder activationState(ActivationState activationState) {
            this.activationState(activationState == null ? null : activationState.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeQuotaRequest build() {
            return new CreateComputeQuotaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
