/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEdgeDeploymentPlanRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateEdgeDeploymentPlanRequest.Builder, CreateEdgeDeploymentPlanRequest> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanName").getter(getter(CreateEdgeDeploymentPlanRequest::edgeDeploymentPlanName))
            .setter(setter(Builder::edgeDeploymentPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build())
            .build();

    private static final SdkField<List<EdgeDeploymentModelConfig>> MODEL_CONFIGS_FIELD = SdkField
            .<List<EdgeDeploymentModelConfig>> builder(MarshallingType.LIST)
            .memberName("ModelConfigs")
            .getter(getter(CreateEdgeDeploymentPlanRequest::modelConfigs))
            .setter(setter(Builder::modelConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EdgeDeploymentModelConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EdgeDeploymentModelConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(CreateEdgeDeploymentPlanRequest::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<List<DeploymentStage>> STAGES_FIELD = SdkField
            .<List<DeploymentStage>> builder(MarshallingType.LIST)
            .memberName("Stages")
            .getter(getter(CreateEdgeDeploymentPlanRequest::stages))
            .setter(setter(Builder::stages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DeploymentStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeploymentStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateEdgeDeploymentPlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EDGE_DEPLOYMENT_PLAN_NAME_FIELD, MODEL_CONFIGS_FIELD, DEVICE_FLEET_NAME_FIELD, STAGES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String edgeDeploymentPlanName;

    private final List<EdgeDeploymentModelConfig> modelConfigs;

    private final String deviceFleetName;

    private final List<DeploymentStage> stages;

    private final List<Tag> tags;

    private CreateEdgeDeploymentPlanRequest(BuilderImpl builder) {
        super(builder);
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.modelConfigs = builder.modelConfigs;
        this.deviceFleetName = builder.deviceFleetName;
        this.stages = builder.stages;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the edge deployment plan.
     * </p>
     * 
     * @return The name of the edge deployment plan.
     */
    public final String edgeDeploymentPlanName() {
        return edgeDeploymentPlanName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelConfigs property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasModelConfigs() {
        return modelConfigs != null && !(modelConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of models associated with the edge deployment plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelConfigs} method.
     * </p>
     * 
     * @return List of models associated with the edge deployment plan.
     */
    public final List<EdgeDeploymentModelConfig> modelConfigs() {
        return modelConfigs;
    }

    /**
     * <p>
     * The device fleet used for this edge deployment plan.
     * </p>
     * 
     * @return The device fleet used for this edge deployment plan.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Stages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStages() {
        return stages != null && !(stages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStages} method.
     * </p>
     * 
     * @return List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
     */
    public final List<DeploymentStage> stages() {
        return stages;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of tags with which to tag the edge deployment plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return List of tags with which to tag the edge deployment plan.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(hasModelConfigs() ? modelConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(hasStages() ? stages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEdgeDeploymentPlanRequest)) {
            return false;
        }
        CreateEdgeDeploymentPlanRequest other = (CreateEdgeDeploymentPlanRequest) obj;
        return Objects.equals(edgeDeploymentPlanName(), other.edgeDeploymentPlanName())
                && hasModelConfigs() == other.hasModelConfigs() && Objects.equals(modelConfigs(), other.modelConfigs())
                && Objects.equals(deviceFleetName(), other.deviceFleetName()) && hasStages() == other.hasStages()
                && Objects.equals(stages(), other.stages()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEdgeDeploymentPlanRequest").add("EdgeDeploymentPlanName", edgeDeploymentPlanName())
                .add("ModelConfigs", hasModelConfigs() ? modelConfigs() : null).add("DeviceFleetName", deviceFleetName())
                .add("Stages", hasStages() ? stages() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeDeploymentPlanName":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanName()));
        case "ModelConfigs":
            return Optional.ofNullable(clazz.cast(modelConfigs()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "Stages":
            return Optional.ofNullable(clazz.cast(stages()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeDeploymentPlanName", EDGE_DEPLOYMENT_PLAN_NAME_FIELD);
        map.put("ModelConfigs", MODEL_CONFIGS_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("Stages", STAGES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEdgeDeploymentPlanRequest, T> g) {
        return obj -> g.apply((CreateEdgeDeploymentPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateEdgeDeploymentPlanRequest> {
        /**
         * <p>
         * The name of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanName
         *        The name of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanName(String edgeDeploymentPlanName);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * 
         * @param modelConfigs
         *        List of models associated with the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * 
         * @param modelConfigs
         *        List of models associated with the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelConfigs(EdgeDeploymentModelConfig... modelConfigs);

        /**
         * <p>
         * List of models associated with the edge deployment plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #modelConfigs(List<EdgeDeploymentModelConfig>)}.
         * 
         * @param modelConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentModelConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelConfigs(java.util.Collection<EdgeDeploymentModelConfig>)
         */
        Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder>... modelConfigs);

        /**
         * <p>
         * The device fleet used for this edge deployment plan.
         * </p>
         * 
         * @param deviceFleetName
         *        The device fleet used for this edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
         * </p>
         * 
         * @param stages
         *        List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(Collection<DeploymentStage> stages);

        /**
         * <p>
         * List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
         * </p>
         * 
         * @param stages
         *        List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stages(DeploymentStage... stages);

        /**
         * <p>
         * List of stages of the edge deployment plan. The number of stages is limited to 10 per deployment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.DeploymentStage.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.sagemaker.model.DeploymentStage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.DeploymentStage.Builder#build()} is called immediately
         * and its result is passed to {@link #stages(List<DeploymentStage>)}.
         * 
         * @param stages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.DeploymentStage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stages(java.util.Collection<DeploymentStage>)
         */
        Builder stages(Consumer<DeploymentStage.Builder>... stages);

        /**
         * <p>
         * List of tags with which to tag the edge deployment plan.
         * </p>
         * 
         * @param tags
         *        List of tags with which to tag the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * List of tags with which to tag the edge deployment plan.
         * </p>
         * 
         * @param tags
         *        List of tags with which to tag the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * List of tags with which to tag the edge deployment plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String edgeDeploymentPlanName;

        private List<EdgeDeploymentModelConfig> modelConfigs = DefaultSdkAutoConstructList.getInstance();

        private String deviceFleetName;

        private List<DeploymentStage> stages = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEdgeDeploymentPlanRequest model) {
            super(model);
            edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            modelConfigs(model.modelConfigs);
            deviceFleetName(model.deviceFleetName);
            stages(model.stages);
            tags(model.tags);
        }

        public final String getEdgeDeploymentPlanName() {
            return edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final List<EdgeDeploymentModelConfig.Builder> getModelConfigs() {
            List<EdgeDeploymentModelConfig.Builder> result = EdgeDeploymentModelConfigsCopier.copyToBuilder(this.modelConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelConfigs(Collection<EdgeDeploymentModelConfig.BuilderImpl> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copyFromBuilder(modelConfigs);
        }

        @Override
        public final Builder modelConfigs(Collection<EdgeDeploymentModelConfig> modelConfigs) {
            this.modelConfigs = EdgeDeploymentModelConfigsCopier.copy(modelConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(EdgeDeploymentModelConfig... modelConfigs) {
            modelConfigs(Arrays.asList(modelConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelConfigs(Consumer<EdgeDeploymentModelConfig.Builder>... modelConfigs) {
            modelConfigs(Stream.of(modelConfigs).map(c -> EdgeDeploymentModelConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final List<DeploymentStage.Builder> getStages() {
            List<DeploymentStage.Builder> result = DeploymentStagesCopier.copyToBuilder(this.stages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStages(Collection<DeploymentStage.BuilderImpl> stages) {
            this.stages = DeploymentStagesCopier.copyFromBuilder(stages);
        }

        @Override
        public final Builder stages(Collection<DeploymentStage> stages) {
            this.stages = DeploymentStagesCopier.copy(stages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(DeploymentStage... stages) {
            stages(Arrays.asList(stages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stages(Consumer<DeploymentStage.Builder>... stages) {
            stages(Stream.of(stages).map(c -> DeploymentStage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEdgeDeploymentPlanRequest build() {
            return new CreateEdgeDeploymentPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
