/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateEdgeDeploymentPlanResponse extends SageMakerResponse implements
        ToCopyableBuilder<CreateEdgeDeploymentPlanResponse.Builder, CreateEdgeDeploymentPlanResponse> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanArn").getter(getter(CreateEdgeDeploymentPlanResponse::edgeDeploymentPlanArn))
            .setter(setter(Builder::edgeDeploymentPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EDGE_DEPLOYMENT_PLAN_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String edgeDeploymentPlanArn;

    private CreateEdgeDeploymentPlanResponse(BuilderImpl builder) {
        super(builder);
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
    }

    /**
     * <p>
     * The ARN of the edge deployment plan.
     * </p>
     * 
     * @return The ARN of the edge deployment plan.
     */
    public final String edgeDeploymentPlanArn() {
        return edgeDeploymentPlanArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEdgeDeploymentPlanResponse)) {
            return false;
        }
        CreateEdgeDeploymentPlanResponse other = (CreateEdgeDeploymentPlanResponse) obj;
        return Objects.equals(edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateEdgeDeploymentPlanResponse").add("EdgeDeploymentPlanArn", edgeDeploymentPlanArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeDeploymentPlanArn":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeDeploymentPlanArn", EDGE_DEPLOYMENT_PLAN_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEdgeDeploymentPlanResponse, T> g) {
        return obj -> g.apply((CreateEdgeDeploymentPlanResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateEdgeDeploymentPlanResponse> {
        /**
         * <p>
         * The ARN of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanArn
         *        The ARN of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String edgeDeploymentPlanArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEdgeDeploymentPlanResponse model) {
            super(model);
            edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
        }

        public final String getEdgeDeploymentPlanArn() {
            return edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        @Override
        public CreateEdgeDeploymentPlanResponse build() {
            return new CreateEdgeDeploymentPlanResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
