/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateHubContentReferenceRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateHubContentReferenceRequest.Builder, CreateHubContentReferenceRequest> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(CreateHubContentReferenceRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("SageMakerPublicHubContentArn")
            .getter(getter(CreateHubContentReferenceRequest::sageMakerPublicHubContentArn))
            .setter(setter(Builder::sageMakerPublicHubContentArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPublicHubContentArn")
                    .build()).build();

    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(CreateHubContentReferenceRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> MIN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MinVersion").getter(getter(CreateHubContentReferenceRequest::minVersion))
            .setter(setter(Builder::minVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinVersion").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateHubContentReferenceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD,
            SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD, HUB_CONTENT_NAME_FIELD, MIN_VERSION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String sageMakerPublicHubContentArn;

    private final String hubContentName;

    private final String minVersion;

    private final List<Tag> tags;

    private CreateHubContentReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.sageMakerPublicHubContentArn = builder.sageMakerPublicHubContentArn;
        this.hubContentName = builder.hubContentName;
        this.minVersion = builder.minVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the hub to add the hub content reference to.
     * </p>
     * 
     * @return The name of the hub to add the hub content reference to.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The ARN of the public hub content to reference.
     * </p>
     * 
     * @return The ARN of the public hub content to reference.
     */
    public final String sageMakerPublicHubContentArn() {
        return sageMakerPublicHubContentArn;
    }

    /**
     * <p>
     * The name of the hub content to reference.
     * </p>
     * 
     * @return The name of the hub content to reference.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The minimum version of the hub content to reference.
     * </p>
     * 
     * @return The minimum version of the hub content to reference.
     */
    public final String minVersion() {
        return minVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags associated with the hub content to reference.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags associated with the hub content to reference.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(sageMakerPublicHubContentArn());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(minVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentReferenceRequest)) {
            return false;
        }
        CreateHubContentReferenceRequest other = (CreateHubContentReferenceRequest) obj;
        return Objects.equals(hubName(), other.hubName())
                && Objects.equals(sageMakerPublicHubContentArn(), other.sageMakerPublicHubContentArn())
                && Objects.equals(hubContentName(), other.hubContentName()) && Objects.equals(minVersion(), other.minVersion())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateHubContentReferenceRequest").add("HubName", hubName())
                .add("SageMakerPublicHubContentArn", sageMakerPublicHubContentArn()).add("HubContentName", hubContentName())
                .add("MinVersion", minVersion()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "SageMakerPublicHubContentArn":
            return Optional.ofNullable(clazz.cast(sageMakerPublicHubContentArn()));
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "MinVersion":
            return Optional.ofNullable(clazz.cast(minVersion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("SageMakerPublicHubContentArn", SAGE_MAKER_PUBLIC_HUB_CONTENT_ARN_FIELD);
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("MinVersion", MIN_VERSION_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentReferenceRequest, T> g) {
        return obj -> g.apply((CreateHubContentReferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateHubContentReferenceRequest> {
        /**
         * <p>
         * The name of the hub to add the hub content reference to.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to add the hub content reference to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The ARN of the public hub content to reference.
         * </p>
         * 
         * @param sageMakerPublicHubContentArn
         *        The ARN of the public hub content to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerPublicHubContentArn(String sageMakerPublicHubContentArn);

        /**
         * <p>
         * The name of the hub content to reference.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The minimum version of the hub content to reference.
         * </p>
         * 
         * @param minVersion
         *        The minimum version of the hub content to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minVersion(String minVersion);

        /**
         * <p>
         * Any tags associated with the hub content to reference.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the hub content to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags associated with the hub content to reference.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the hub content to reference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags associated with the hub content to reference.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubName;

        private String sageMakerPublicHubContentArn;

        private String hubContentName;

        private String minVersion;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentReferenceRequest model) {
            super(model);
            hubName(model.hubName);
            sageMakerPublicHubContentArn(model.sageMakerPublicHubContentArn);
            hubContentName(model.hubContentName);
            minVersion(model.minVersion);
            tags(model.tags);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getSageMakerPublicHubContentArn() {
            return sageMakerPublicHubContentArn;
        }

        public final void setSageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
        }

        @Override
        public final Builder sageMakerPublicHubContentArn(String sageMakerPublicHubContentArn) {
            this.sageMakerPublicHubContentArn = sageMakerPublicHubContentArn;
            return this;
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getMinVersion() {
            return minVersion;
        }

        public final void setMinVersion(String minVersion) {
            this.minVersion = minVersion;
        }

        @Override
        public final Builder minVersion(String minVersion) {
            this.minVersion = minVersion;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateHubContentReferenceRequest build() {
            return new CreateHubContentReferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
