/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMlflowTrackingServerRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateMlflowTrackingServerRequest.Builder, CreateMlflowTrackingServerRequest> {
    private static final SdkField<String> TRACKING_SERVER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerName").getter(getter(CreateMlflowTrackingServerRequest::trackingServerName))
            .setter(setter(Builder::trackingServerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerName").build())
            .build();

    private static final SdkField<String> ARTIFACT_STORE_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactStoreUri").getter(getter(CreateMlflowTrackingServerRequest::artifactStoreUri))
            .setter(setter(Builder::artifactStoreUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactStoreUri").build()).build();

    private static final SdkField<String> TRACKING_SERVER_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrackingServerSize").getter(getter(CreateMlflowTrackingServerRequest::trackingServerSizeAsString))
            .setter(setter(Builder::trackingServerSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingServerSize").build())
            .build();

    private static final SdkField<String> MLFLOW_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MlflowVersion").getter(getter(CreateMlflowTrackingServerRequest::mlflowVersion))
            .setter(setter(Builder::mlflowVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MlflowVersion").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleArn").getter(getter(CreateMlflowTrackingServerRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()).build();

    private static final SdkField<Boolean> AUTOMATIC_MODEL_REGISTRATION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutomaticModelRegistration")
            .getter(getter(CreateMlflowTrackingServerRequest::automaticModelRegistration))
            .setter(setter(Builder::automaticModelRegistration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomaticModelRegistration").build())
            .build();

    private static final SdkField<String> WEEKLY_MAINTENANCE_WINDOW_START_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("WeeklyMaintenanceWindowStart")
            .getter(getter(CreateMlflowTrackingServerRequest::weeklyMaintenanceWindowStart))
            .setter(setter(Builder::weeklyMaintenanceWindowStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeeklyMaintenanceWindowStart")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMlflowTrackingServerRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACKING_SERVER_NAME_FIELD,
            ARTIFACT_STORE_URI_FIELD, TRACKING_SERVER_SIZE_FIELD, MLFLOW_VERSION_FIELD, ROLE_ARN_FIELD,
            AUTOMATIC_MODEL_REGISTRATION_FIELD, WEEKLY_MAINTENANCE_WINDOW_START_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trackingServerName;

    private final String artifactStoreUri;

    private final String trackingServerSize;

    private final String mlflowVersion;

    private final String roleArn;

    private final Boolean automaticModelRegistration;

    private final String weeklyMaintenanceWindowStart;

    private final List<Tag> tags;

    private CreateMlflowTrackingServerRequest(BuilderImpl builder) {
        super(builder);
        this.trackingServerName = builder.trackingServerName;
        this.artifactStoreUri = builder.artifactStoreUri;
        this.trackingServerSize = builder.trackingServerSize;
        this.mlflowVersion = builder.mlflowVersion;
        this.roleArn = builder.roleArn;
        this.automaticModelRegistration = builder.automaticModelRegistration;
        this.weeklyMaintenanceWindowStart = builder.weeklyMaintenanceWindowStart;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique string identifying the tracking server name. This string is part of the tracking server ARN.
     * </p>
     * 
     * @return A unique string identifying the tracking server name. This string is part of the tracking server ARN.
     */
    public final String trackingServerName() {
        return trackingServerName;
    }

    /**
     * <p>
     * The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
     * </p>
     * 
     * @return The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
     */
    public final String artifactStoreUri() {
        return artifactStoreUri;
    }

    /**
     * <p>
     * The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
     * <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
     * <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as the
     * volume of data logged, number of users, and frequency of use.
     * </p>
     * <p>
     * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of up
     * to 50 users, and a large tracking server for teams of up to 100 users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
     *         <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
     *         <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as
     *         the volume of data logged, number of users, and frequency of use. </p>
     *         <p>
     *         We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for
     *         teams of up to 50 users, and a large tracking server for teams of up to 100 users.
     * @see TrackingServerSize
     */
    public final TrackingServerSize trackingServerSize() {
        return TrackingServerSize.fromValue(trackingServerSize);
    }

    /**
     * <p>
     * The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
     * <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
     * <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as the
     * volume of data logged, number of users, and frequency of use.
     * </p>
     * <p>
     * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of up
     * to 50 users, and a large tracking server for teams of up to 100 users.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #trackingServerSize} will return {@link TrackingServerSize#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #trackingServerSizeAsString}.
     * </p>
     * 
     * @return The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
     *         <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
     *         <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as
     *         the volume of data logged, number of users, and frequency of use. </p>
     *         <p>
     *         We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for
     *         teams of up to 50 users, and a large tracking server for teams of up to 100 users.
     * @see TrackingServerSize
     */
    public final String trackingServerSizeAsString() {
        return trackingServerSize;
    }

    /**
     * <p>
     * The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works">How
     * it works</a>.
     * </p>
     * 
     * @return The version of MLflow that the tracking server uses. To see which MLflow versions are available to use,
     *         see <a href=
     *         "https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works"
     *         >How it works</a>.
     */
    public final String mlflowVersion() {
        return mlflowVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access the
     * artifact store in Amazon S3. The role should have <code>AmazonS3FullAccess</code> permissions. For more
     * information on IAM permissions for tracking server creation, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html">Set up IAM
     * permissions for MLflow</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to
     *         access the artifact store in Amazon S3. The role should have <code>AmazonS3FullAccess</code> permissions.
     *         For more information on IAM permissions for tracking server creation, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html">Set up IAM
     *         permissions for MLflow</a>.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To
     * enable automatic model registration, set this value to <code>True</code>. To disable automatic model
     * registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code>
     * defaults to <code>False</code>.
     * </p>
     * 
     * @return Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry.
     *         To enable automatic model registration, set this value to <code>True</code>. To disable automatic model
     *         registration, set this value to <code>False</code>. If not specified,
     *         <code>AutomaticModelRegistration</code> defaults to <code>False</code>.
     */
    public final Boolean automaticModelRegistration() {
        return automaticModelRegistration;
    }

    /**
     * <p>
     * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly maintenance
     * updates are scheduled. For example: TUE:03:30.
     * </p>
     * 
     * @return The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
     *         maintenance updates are scheduled. For example: TUE:03:30.
     */
    public final String weeklyMaintenanceWindowStart() {
        return weeklyMaintenanceWindowStart;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags consisting of key-value pairs used to manage metadata for the tracking server.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags consisting of key-value pairs used to manage metadata for the tracking server.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerName());
        hashCode = 31 * hashCode + Objects.hashCode(artifactStoreUri());
        hashCode = 31 * hashCode + Objects.hashCode(trackingServerSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mlflowVersion());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(automaticModelRegistration());
        hashCode = 31 * hashCode + Objects.hashCode(weeklyMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMlflowTrackingServerRequest)) {
            return false;
        }
        CreateMlflowTrackingServerRequest other = (CreateMlflowTrackingServerRequest) obj;
        return Objects.equals(trackingServerName(), other.trackingServerName())
                && Objects.equals(artifactStoreUri(), other.artifactStoreUri())
                && Objects.equals(trackingServerSizeAsString(), other.trackingServerSizeAsString())
                && Objects.equals(mlflowVersion(), other.mlflowVersion()) && Objects.equals(roleArn(), other.roleArn())
                && Objects.equals(automaticModelRegistration(), other.automaticModelRegistration())
                && Objects.equals(weeklyMaintenanceWindowStart(), other.weeklyMaintenanceWindowStart())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMlflowTrackingServerRequest").add("TrackingServerName", trackingServerName())
                .add("ArtifactStoreUri", artifactStoreUri()).add("TrackingServerSize", trackingServerSizeAsString())
                .add("MlflowVersion", mlflowVersion()).add("RoleArn", roleArn())
                .add("AutomaticModelRegistration", automaticModelRegistration())
                .add("WeeklyMaintenanceWindowStart", weeklyMaintenanceWindowStart()).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrackingServerName":
            return Optional.ofNullable(clazz.cast(trackingServerName()));
        case "ArtifactStoreUri":
            return Optional.ofNullable(clazz.cast(artifactStoreUri()));
        case "TrackingServerSize":
            return Optional.ofNullable(clazz.cast(trackingServerSizeAsString()));
        case "MlflowVersion":
            return Optional.ofNullable(clazz.cast(mlflowVersion()));
        case "RoleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "AutomaticModelRegistration":
            return Optional.ofNullable(clazz.cast(automaticModelRegistration()));
        case "WeeklyMaintenanceWindowStart":
            return Optional.ofNullable(clazz.cast(weeklyMaintenanceWindowStart()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrackingServerName", TRACKING_SERVER_NAME_FIELD);
        map.put("ArtifactStoreUri", ARTIFACT_STORE_URI_FIELD);
        map.put("TrackingServerSize", TRACKING_SERVER_SIZE_FIELD);
        map.put("MlflowVersion", MLFLOW_VERSION_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("AutomaticModelRegistration", AUTOMATIC_MODEL_REGISTRATION_FIELD);
        map.put("WeeklyMaintenanceWindowStart", WEEKLY_MAINTENANCE_WINDOW_START_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMlflowTrackingServerRequest, T> g) {
        return obj -> g.apply((CreateMlflowTrackingServerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateMlflowTrackingServerRequest> {
        /**
         * <p>
         * A unique string identifying the tracking server name. This string is part of the tracking server ARN.
         * </p>
         * 
         * @param trackingServerName
         *        A unique string identifying the tracking server name. This string is part of the tracking server ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trackingServerName(String trackingServerName);

        /**
         * <p>
         * The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
         * </p>
         * 
         * @param artifactStoreUri
         *        The S3 URI for a general purpose bucket to use as the MLflow Tracking Server artifact store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactStoreUri(String artifactStoreUri);

        /**
         * <p>
         * The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
         * <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
         * <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as the
         * volume of data logged, number of users, and frequency of use.
         * </p>
         * <p>
         * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of
         * up to 50 users, and a large tracking server for teams of up to 100 users.
         * </p>
         * 
         * @param trackingServerSize
         *        The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
         *        <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size
         *        is <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server
         *        such as the volume of data logged, number of users, and frequency of use. </p>
         *        <p>
         *        We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for
         *        teams of up to 50 users, and a large tracking server for teams of up to 100 users.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(String trackingServerSize);

        /**
         * <p>
         * The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
         * <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size is
         * <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server such as the
         * volume of data logged, number of users, and frequency of use.
         * </p>
         * <p>
         * We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for teams of
         * up to 50 users, and a large tracking server for teams of up to 100 users.
         * </p>
         * 
         * @param trackingServerSize
         *        The size of the tracking server you want to create. You can choose between <code>"Small"</code>,
         *        <code>"Medium"</code>, and <code>"Large"</code>. The default MLflow Tracking Server configuration size
         *        is <code>"Small"</code>. You can choose a size depending on the projected use of the tracking server
         *        such as the volume of data logged, number of users, and frequency of use. </p>
         *        <p>
         *        We recommend using a small tracking server for teams of up to 25 users, a medium tracking server for
         *        teams of up to 50 users, and a large tracking server for teams of up to 100 users.
         * @see TrackingServerSize
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrackingServerSize
         */
        Builder trackingServerSize(TrackingServerSize trackingServerSize);

        /**
         * <p>
         * The version of MLflow that the tracking server uses. To see which MLflow versions are available to use, see
         * <a href=
         * "https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works">How
         * it works</a>.
         * </p>
         * 
         * @param mlflowVersion
         *        The version of MLflow that the tracking server uses. To see which MLflow versions are available to
         *        use, see <a href=
         *        "https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow.html#mlflow-create-tracking-server-how-it-works"
         *        >How it works</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlflowVersion(String mlflowVersion);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to access
         * the artifact store in Amazon S3. The role should have <code>AmazonS3FullAccess</code> permissions. For more
         * information on IAM permissions for tracking server creation, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html">Set up IAM
         * permissions for MLflow</a>.
         * </p>
         * 
         * @param roleArn
         *        The Amazon Resource Name (ARN) for an IAM role in your account that the MLflow Tracking Server uses to
         *        access the artifact store in Amazon S3. The role should have <code>AmazonS3FullAccess</code>
         *        permissions. For more information on IAM permissions for tracking server creation, see <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/dg/mlflow-create-tracking-server-iam.html">Set up
         *        IAM permissions for MLflow</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model Registry. To
         * enable automatic model registration, set this value to <code>True</code>. To disable automatic model
         * registration, set this value to <code>False</code>. If not specified, <code>AutomaticModelRegistration</code>
         * defaults to <code>False</code>.
         * </p>
         * 
         * @param automaticModelRegistration
         *        Whether to enable or disable automatic registration of new MLflow models to the SageMaker Model
         *        Registry. To enable automatic model registration, set this value to <code>True</code>. To disable
         *        automatic model registration, set this value to <code>False</code>. If not specified,
         *        <code>AutomaticModelRegistration</code> defaults to <code>False</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automaticModelRegistration(Boolean automaticModelRegistration);

        /**
         * <p>
         * The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         * maintenance updates are scheduled. For example: TUE:03:30.
         * </p>
         * 
         * @param weeklyMaintenanceWindowStart
         *        The day and time of the week in Coordinated Universal Time (UTC) 24-hour standard time that weekly
         *        maintenance updates are scheduled. For example: TUE:03:30.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart);

        /**
         * <p>
         * Tags consisting of key-value pairs used to manage metadata for the tracking server.
         * </p>
         * 
         * @param tags
         *        Tags consisting of key-value pairs used to manage metadata for the tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags consisting of key-value pairs used to manage metadata for the tracking server.
         * </p>
         * 
         * @param tags
         *        Tags consisting of key-value pairs used to manage metadata for the tracking server.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags consisting of key-value pairs used to manage metadata for the tracking server.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trackingServerName;

        private String artifactStoreUri;

        private String trackingServerSize;

        private String mlflowVersion;

        private String roleArn;

        private Boolean automaticModelRegistration;

        private String weeklyMaintenanceWindowStart;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMlflowTrackingServerRequest model) {
            super(model);
            trackingServerName(model.trackingServerName);
            artifactStoreUri(model.artifactStoreUri);
            trackingServerSize(model.trackingServerSize);
            mlflowVersion(model.mlflowVersion);
            roleArn(model.roleArn);
            automaticModelRegistration(model.automaticModelRegistration);
            weeklyMaintenanceWindowStart(model.weeklyMaintenanceWindowStart);
            tags(model.tags);
        }

        public final String getTrackingServerName() {
            return trackingServerName;
        }

        public final void setTrackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
        }

        @Override
        public final Builder trackingServerName(String trackingServerName) {
            this.trackingServerName = trackingServerName;
            return this;
        }

        public final String getArtifactStoreUri() {
            return artifactStoreUri;
        }

        public final void setArtifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
        }

        @Override
        public final Builder artifactStoreUri(String artifactStoreUri) {
            this.artifactStoreUri = artifactStoreUri;
            return this;
        }

        public final String getTrackingServerSize() {
            return trackingServerSize;
        }

        public final void setTrackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
        }

        @Override
        public final Builder trackingServerSize(String trackingServerSize) {
            this.trackingServerSize = trackingServerSize;
            return this;
        }

        @Override
        public final Builder trackingServerSize(TrackingServerSize trackingServerSize) {
            this.trackingServerSize(trackingServerSize == null ? null : trackingServerSize.toString());
            return this;
        }

        public final String getMlflowVersion() {
            return mlflowVersion;
        }

        public final void setMlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
        }

        @Override
        public final Builder mlflowVersion(String mlflowVersion) {
            this.mlflowVersion = mlflowVersion;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getAutomaticModelRegistration() {
            return automaticModelRegistration;
        }

        public final void setAutomaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
        }

        @Override
        public final Builder automaticModelRegistration(Boolean automaticModelRegistration) {
            this.automaticModelRegistration = automaticModelRegistration;
            return this;
        }

        public final String getWeeklyMaintenanceWindowStart() {
            return weeklyMaintenanceWindowStart;
        }

        public final void setWeeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
        }

        @Override
        public final Builder weeklyMaintenanceWindowStart(String weeklyMaintenanceWindowStart) {
            this.weeklyMaintenanceWindowStart = weeklyMaintenanceWindowStart;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMlflowTrackingServerRequest build() {
            return new CreateMlflowTrackingServerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
