/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateProjectRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateProjectRequest.Builder, CreateProjectRequest> {
    private static final SdkField<String> PROJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectName").getter(getter(CreateProjectRequest::projectName)).setter(setter(Builder::projectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectName").build()).build();

    private static final SdkField<String> PROJECT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProjectDescription").getter(getter(CreateProjectRequest::projectDescription))
            .setter(setter(Builder::projectDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectDescription").build())
            .build();

    private static final SdkField<ServiceCatalogProvisioningDetails> SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD = SdkField
            .<ServiceCatalogProvisioningDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ServiceCatalogProvisioningDetails")
            .getter(getter(CreateProjectRequest::serviceCatalogProvisioningDetails))
            .setter(setter(Builder::serviceCatalogProvisioningDetails))
            .constructor(ServiceCatalogProvisioningDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCatalogProvisioningDetails")
                    .build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateProjectRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_NAME_FIELD,
            PROJECT_DESCRIPTION_FIELD, SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String projectName;

    private final String projectDescription;

    private final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;

    private final List<Tag> tags;

    private CreateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.projectName = builder.projectName;
        this.projectDescription = builder.projectDescription;
        this.serviceCatalogProvisioningDetails = builder.serviceCatalogProvisioningDetails;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the project.
     * </p>
     * 
     * @return The name of the project.
     */
    public final String projectName() {
        return projectName;
    }

    /**
     * <p>
     * A description for the project.
     * </p>
     * 
     * @return A description for the project.
     */
    public final String projectDescription() {
        return projectDescription;
    }

    /**
     * <p>
     * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
     * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact ID.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web Services
     * Service Catalog</a>.
     * </p>
     * 
     * @return The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID
     *         will default to the latest provisioning artifact ID of the product, if you don't provide the provisioning
     *         artifact ID. For more information, see <a
     *         href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
     *         Services Service Catalog</a>.
     */
    public final ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails() {
        return serviceCatalogProvisioningDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource costs.
     * For more information, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon
     * Web Services resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource
     *         costs. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
     *         resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(projectName());
        hashCode = 31 * hashCode + Objects.hashCode(projectDescription());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCatalogProvisioningDetails());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProjectRequest)) {
            return false;
        }
        CreateProjectRequest other = (CreateProjectRequest) obj;
        return Objects.equals(projectName(), other.projectName())
                && Objects.equals(projectDescription(), other.projectDescription())
                && Objects.equals(serviceCatalogProvisioningDetails(), other.serviceCatalogProvisioningDetails())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateProjectRequest").add("ProjectName", projectName())
                .add("ProjectDescription", projectDescription())
                .add("ServiceCatalogProvisioningDetails", serviceCatalogProvisioningDetails())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectName":
            return Optional.ofNullable(clazz.cast(projectName()));
        case "ProjectDescription":
            return Optional.ofNullable(clazz.cast(projectDescription()));
        case "ServiceCatalogProvisioningDetails":
            return Optional.ofNullable(clazz.cast(serviceCatalogProvisioningDetails()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProjectName", PROJECT_NAME_FIELD);
        map.put("ProjectDescription", PROJECT_DESCRIPTION_FIELD);
        map.put("ServiceCatalogProvisioningDetails", SERVICE_CATALOG_PROVISIONING_DETAILS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateProjectRequest, T> g) {
        return obj -> g.apply((CreateProjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateProjectRequest> {
        /**
         * <p>
         * The name of the project.
         * </p>
         * 
         * @param projectName
         *        The name of the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectName(String projectName);

        /**
         * <p>
         * A description for the project.
         * </p>
         * 
         * @param projectDescription
         *        A description for the project.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectDescription(String projectDescription);

        /**
         * <p>
         * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
         * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact
         * ID. For more information, see <a
         * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
         * Services Service Catalog</a>.
         * </p>
         * 
         * @param serviceCatalogProvisioningDetails
         *        The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact
         *        ID will default to the latest provisioning artifact ID of the product, if you don't provide the
         *        provisioning artifact ID. For more information, see <a
         *        href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon
         *        Web Services Service Catalog</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails);

        /**
         * <p>
         * The product ID and provisioning artifact ID to provision a service catalog. The provisioning artifact ID will
         * default to the latest provisioning artifact ID of the product, if you don't provide the provisioning artifact
         * ID. For more information, see <a
         * href="https://docs.aws.amazon.com/servicecatalog/latest/adminguide/introduction.html">What is Amazon Web
         * Services Service Catalog</a>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceCatalogProvisioningDetails.Builder} avoiding the need to create one manually via
         * {@link ServiceCatalogProvisioningDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceCatalogProvisioningDetails.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails)}.
         * 
         * @param serviceCatalogProvisioningDetails
         *        a consumer that will call methods on {@link ServiceCatalogProvisioningDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails)
         */
        default Builder serviceCatalogProvisioningDetails(
                Consumer<ServiceCatalogProvisioningDetails.Builder> serviceCatalogProvisioningDetails) {
            return serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails.builder()
                    .applyMutation(serviceCatalogProvisioningDetails).build());
        }

        /**
         * <p>
         * An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource
         * costs. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that you want to use to organize and track your Amazon Web Services
         *        resource costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource
         * costs. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * 
         * @param tags
         *        An array of key-value pairs that you want to use to organize and track your Amazon Web Services
         *        resource costs. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         *        resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An array of key-value pairs that you want to use to organize and track your Amazon Web Services resource
         * costs. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging Amazon Web Services
         * resources</a> in the <i>Amazon Web Services General Reference Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String projectName;

        private String projectDescription;

        private ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProjectRequest model) {
            super(model);
            projectName(model.projectName);
            projectDescription(model.projectDescription);
            serviceCatalogProvisioningDetails(model.serviceCatalogProvisioningDetails);
            tags(model.tags);
        }

        public final String getProjectName() {
            return projectName;
        }

        public final void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public final Builder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public final String getProjectDescription() {
            return projectDescription;
        }

        public final void setProjectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
        }

        @Override
        public final Builder projectDescription(String projectDescription) {
            this.projectDescription = projectDescription;
            return this;
        }

        public final ServiceCatalogProvisioningDetails.Builder getServiceCatalogProvisioningDetails() {
            return serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails.toBuilder() : null;
        }

        public final void setServiceCatalogProvisioningDetails(
                ServiceCatalogProvisioningDetails.BuilderImpl serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails != null ? serviceCatalogProvisioningDetails
                    .build() : null;
        }

        @Override
        public final Builder serviceCatalogProvisioningDetails(ServiceCatalogProvisioningDetails serviceCatalogProvisioningDetails) {
            this.serviceCatalogProvisioningDetails = serviceCatalogProvisioningDetails;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateProjectRequest build() {
            return new CreateProjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
