/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTrialComponentRequest extends SageMakerRequest implements
        ToCopyableBuilder<CreateTrialComponentRequest.Builder, CreateTrialComponentRequest> {
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrialComponentName").getter(getter(CreateTrialComponentRequest::trialComponentName))
            .setter(setter(Builder::trialComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build())
            .build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(CreateTrialComponentRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<TrialComponentStatus> STATUS_FIELD = SdkField
            .<TrialComponentStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(CreateTrialComponentRequest::status)).setter(setter(Builder::status))
            .constructor(TrialComponentStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(CreateTrialComponentRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(CreateTrialComponentRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Map<String, TrialComponentParameterValue>> PARAMETERS_FIELD = SdkField
            .<Map<String, TrialComponentParameterValue>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(CreateTrialComponentRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentParameterValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentParameterValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> INPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("InputArtifacts")
            .getter(getter(CreateTrialComponentRequest::inputArtifacts))
            .setter(setter(Builder::inputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, TrialComponentArtifact>> OUTPUT_ARTIFACTS_FIELD = SdkField
            .<Map<String, TrialComponentArtifact>> builder(MarshallingType.MAP)
            .memberName("OutputArtifacts")
            .getter(getter(CreateTrialComponentRequest::outputArtifacts))
            .setter(setter(Builder::outputArtifacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputArtifacts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<TrialComponentArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialComponentArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MetadataProperties> METADATA_PROPERTIES_FIELD = SdkField
            .<MetadataProperties> builder(MarshallingType.SDK_POJO).memberName("MetadataProperties")
            .getter(getter(CreateTrialComponentRequest::metadataProperties)).setter(setter(Builder::metadataProperties))
            .constructor(MetadataProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataProperties").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateTrialComponentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_COMPONENT_NAME_FIELD,
            DISPLAY_NAME_FIELD, STATUS_FIELD, START_TIME_FIELD, END_TIME_FIELD, PARAMETERS_FIELD, INPUT_ARTIFACTS_FIELD,
            OUTPUT_ARTIFACTS_FIELD, METADATA_PROPERTIES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String trialComponentName;

    private final String displayName;

    private final TrialComponentStatus status;

    private final Instant startTime;

    private final Instant endTime;

    private final Map<String, TrialComponentParameterValue> parameters;

    private final Map<String, TrialComponentArtifact> inputArtifacts;

    private final Map<String, TrialComponentArtifact> outputArtifacts;

    private final MetadataProperties metadataProperties;

    private final List<Tag> tags;

    private CreateTrialComponentRequest(BuilderImpl builder) {
        super(builder);
        this.trialComponentName = builder.trialComponentName;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.parameters = builder.parameters;
        this.inputArtifacts = builder.inputArtifacts;
        this.outputArtifacts = builder.outputArtifacts;
        this.metadataProperties = builder.metadataProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the component. The name must be unique in your Amazon Web Services account and is not case-sensitive.
     * </p>
     * 
     * @return The name of the component. The name must be unique in your Amazon Web Services account and is not
     *         case-sensitive.
     */
    public final String trialComponentName() {
        return trialComponentName;
    }

    /**
     * <p>
     * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
     * specified, <code>TrialComponentName</code> is displayed.
     * </p>
     * 
     * @return The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code>
     *         isn't specified, <code>TrialComponentName</code> is displayed.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The status of the component. States include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * InProgress
     * </p>
     * </li>
     * <li>
     * <p>
     * Completed
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The status of the component. States include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         InProgress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Completed
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     */
    public final TrialComponentStatus status() {
        return status;
    }

    /**
     * <p>
     * When the component started.
     * </p>
     * 
     * @return When the component started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * When the component ended.
     * </p>
     * 
     * @return When the component ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The hyperparameters for the component.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return The hyperparameters for the component.
     */
    public final Map<String, TrialComponentParameterValue> parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the InputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInputArtifacts() {
        return inputArtifacts != null && !(inputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters,
     * source code, and instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputArtifacts} method.
     * </p>
     * 
     * @return The input artifacts for the component. Examples of input artifacts are datasets, algorithms,
     *         hyperparameters, source code, and instance types.
     */
    public final Map<String, TrialComponentArtifact> inputArtifacts() {
        return inputArtifacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the OutputArtifacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOutputArtifacts() {
        return outputArtifacts != null && !(outputArtifacts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOutputArtifacts} method.
     * </p>
     * 
     * @return The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
     *         images.
     */
    public final Map<String, TrialComponentArtifact> outputArtifacts() {
        return outputArtifacts;
    }

    /**
     * Returns the value of the MetadataProperties property for this object.
     * 
     * @return The value of the MetadataProperties property for this object.
     */
    public final MetadataProperties metadataProperties() {
        return metadataProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags to associate with the component. You can use <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on the
     * tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags to associate with the component. You can use <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search
     *         on the tags.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasInputArtifacts() ? inputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOutputArtifacts() ? outputArtifacts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metadataProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrialComponentRequest)) {
            return false;
        }
        CreateTrialComponentRequest other = (CreateTrialComponentRequest) obj;
        return Objects.equals(trialComponentName(), other.trialComponentName())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(status(), other.status())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && hasInputArtifacts() == other.hasInputArtifacts() && Objects.equals(inputArtifacts(), other.inputArtifacts())
                && hasOutputArtifacts() == other.hasOutputArtifacts()
                && Objects.equals(outputArtifacts(), other.outputArtifacts())
                && Objects.equals(metadataProperties(), other.metadataProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTrialComponentRequest").add("TrialComponentName", trialComponentName())
                .add("DisplayName", displayName()).add("Status", status()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Parameters", hasParameters() ? parameters() : null)
                .add("InputArtifacts", hasInputArtifacts() ? inputArtifacts() : null)
                .add("OutputArtifacts", hasOutputArtifacts() ? outputArtifacts() : null)
                .add("MetadataProperties", metadataProperties()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialComponentName":
            return Optional.ofNullable(clazz.cast(trialComponentName()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "InputArtifacts":
            return Optional.ofNullable(clazz.cast(inputArtifacts()));
        case "OutputArtifacts":
            return Optional.ofNullable(clazz.cast(outputArtifacts()));
        case "MetadataProperties":
            return Optional.ofNullable(clazz.cast(metadataProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrialComponentName", TRIAL_COMPONENT_NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("Parameters", PARAMETERS_FIELD);
        map.put("InputArtifacts", INPUT_ARTIFACTS_FIELD);
        map.put("OutputArtifacts", OUTPUT_ARTIFACTS_FIELD);
        map.put("MetadataProperties", METADATA_PROPERTIES_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTrialComponentRequest, T> g) {
        return obj -> g.apply((CreateTrialComponentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTrialComponentRequest> {
        /**
         * <p>
         * The name of the component. The name must be unique in your Amazon Web Services account and is not
         * case-sensitive.
         * </p>
         * 
         * @param trialComponentName
         *        The name of the component. The name must be unique in your Amazon Web Services account and is not
         *        case-sensitive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialComponentName(String trialComponentName);

        /**
         * <p>
         * The name of the component as displayed. The name doesn't need to be unique. If <code>DisplayName</code> isn't
         * specified, <code>TrialComponentName</code> is displayed.
         * </p>
         * 
         * @param displayName
         *        The name of the component as displayed. The name doesn't need to be unique. If
         *        <code>DisplayName</code> isn't specified, <code>TrialComponentName</code> is displayed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the component. States include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        InProgress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Completed
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(TrialComponentStatus status);

        /**
         * <p>
         * The status of the component. States include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * InProgress
         * </p>
         * </li>
         * <li>
         * <p>
         * Completed
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link TrialComponentStatus.Builder} avoiding
         * the need to create one manually via {@link TrialComponentStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrialComponentStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #status(TrialComponentStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link TrialComponentStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(TrialComponentStatus)
         */
        default Builder status(Consumer<TrialComponentStatus.Builder> status) {
            return status(TrialComponentStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * When the component started.
         * </p>
         * 
         * @param startTime
         *        When the component started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * When the component ended.
         * </p>
         * 
         * @param endTime
         *        When the component ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The hyperparameters for the component.
         * </p>
         * 
         * @param parameters
         *        The hyperparameters for the component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, TrialComponentParameterValue> parameters);

        /**
         * <p>
         * The input artifacts for the component. Examples of input artifacts are datasets, algorithms, hyperparameters,
         * source code, and instance types.
         * </p>
         * 
         * @param inputArtifacts
         *        The input artifacts for the component. Examples of input artifacts are datasets, algorithms,
         *        hyperparameters, source code, and instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts);

        /**
         * <p>
         * The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
         * images.
         * </p>
         * 
         * @param outputArtifacts
         *        The output artifacts for the component. Examples of output artifacts are metrics, snapshots, logs, and
         *        images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * @param metadataProperties
         *        The new value for the MetadataProperties property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataProperties(MetadataProperties metadataProperties);

        /**
         * Sets the value of the MetadataProperties property for this object.
         *
         * This is a convenience method that creates an instance of the {@link MetadataProperties.Builder} avoiding the
         * need to create one manually via {@link MetadataProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MetadataProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #metadataProperties(MetadataProperties)}.
         * 
         * @param metadataProperties
         *        a consumer that will call methods on {@link MetadataProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataProperties(MetadataProperties)
         */
        default Builder metadataProperties(Consumer<MetadataProperties.Builder> metadataProperties) {
            return metadataProperties(MetadataProperties.builder().applyMutation(metadataProperties).build());
        }

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the component. You can use <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to
         *        search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * 
         * @param tags
         *        A list of tags to associate with the component. You can use <a
         *        href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to
         *        search on the tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags to associate with the component. You can use <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_Search.html">Search</a> API to search on
         * the tags.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String trialComponentName;

        private String displayName;

        private TrialComponentStatus status;

        private Instant startTime;

        private Instant endTime;

        private Map<String, TrialComponentParameterValue> parameters = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> inputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, TrialComponentArtifact> outputArtifacts = DefaultSdkAutoConstructMap.getInstance();

        private MetadataProperties metadataProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrialComponentRequest model) {
            super(model);
            trialComponentName(model.trialComponentName);
            displayName(model.displayName);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            parameters(model.parameters);
            inputArtifacts(model.inputArtifacts);
            outputArtifacts(model.outputArtifacts);
            metadataProperties(model.metadataProperties);
            tags(model.tags);
        }

        public final String getTrialComponentName() {
            return trialComponentName;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final TrialComponentStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(TrialComponentStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public final Builder status(TrialComponentStatus status) {
            this.status = status;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Map<String, TrialComponentParameterValue.Builder> getParameters() {
            Map<String, TrialComponentParameterValue.Builder> result = TrialComponentParametersCopier
                    .copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, TrialComponentParameterValue.BuilderImpl> parameters) {
            this.parameters = TrialComponentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, TrialComponentParameterValue> parameters) {
            this.parameters = TrialComponentParametersCopier.copy(parameters);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getInputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier.copyToBuilder(this.inputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setInputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(inputArtifacts);
        }

        @Override
        public final Builder inputArtifacts(Map<String, TrialComponentArtifact> inputArtifacts) {
            this.inputArtifacts = TrialComponentArtifactsCopier.copy(inputArtifacts);
            return this;
        }

        public final Map<String, TrialComponentArtifact.Builder> getOutputArtifacts() {
            Map<String, TrialComponentArtifact.Builder> result = TrialComponentArtifactsCopier
                    .copyToBuilder(this.outputArtifacts);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOutputArtifacts(Map<String, TrialComponentArtifact.BuilderImpl> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copyFromBuilder(outputArtifacts);
        }

        @Override
        public final Builder outputArtifacts(Map<String, TrialComponentArtifact> outputArtifacts) {
            this.outputArtifacts = TrialComponentArtifactsCopier.copy(outputArtifacts);
            return this;
        }

        public final MetadataProperties.Builder getMetadataProperties() {
            return metadataProperties != null ? metadataProperties.toBuilder() : null;
        }

        public final void setMetadataProperties(MetadataProperties.BuilderImpl metadataProperties) {
            this.metadataProperties = metadataProperties != null ? metadataProperties.build() : null;
        }

        @Override
        public final Builder metadataProperties(MetadataProperties metadataProperties) {
            this.metadataProperties = metadataProperties;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrialComponentRequest build() {
            return new CreateTrialComponentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
