/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the location of the channel data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSource implements SdkPojo, Serializable, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private static final SdkField<S3DataSource> S3_DATA_SOURCE_FIELD = SdkField.<S3DataSource> builder(MarshallingType.SDK_POJO)
            .memberName("S3DataSource").getter(getter(DataSource::s3DataSource)).setter(setter(Builder::s3DataSource))
            .constructor(S3DataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3DataSource").build()).build();

    private static final SdkField<FileSystemDataSource> FILE_SYSTEM_DATA_SOURCE_FIELD = SdkField
            .<FileSystemDataSource> builder(MarshallingType.SDK_POJO).memberName("FileSystemDataSource")
            .getter(getter(DataSource::fileSystemDataSource)).setter(setter(Builder::fileSystemDataSource))
            .constructor(FileSystemDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FileSystemDataSource").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_DATA_SOURCE_FIELD,
            FILE_SYSTEM_DATA_SOURCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final S3DataSource s3DataSource;

    private final FileSystemDataSource fileSystemDataSource;

    private DataSource(BuilderImpl builder) {
        this.s3DataSource = builder.s3DataSource;
        this.fileSystemDataSource = builder.fileSystemDataSource;
    }

    /**
     * <p>
     * The S3 location of the data source that is associated with a channel.
     * </p>
     * 
     * @return The S3 location of the data source that is associated with a channel.
     */
    public final S3DataSource s3DataSource() {
        return s3DataSource;
    }

    /**
     * <p>
     * The file system that is associated with a channel.
     * </p>
     * 
     * @return The file system that is associated with a channel.
     */
    public final FileSystemDataSource fileSystemDataSource() {
        return fileSystemDataSource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3DataSource());
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemDataSource());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        return Objects.equals(s3DataSource(), other.s3DataSource())
                && Objects.equals(fileSystemDataSource(), other.fileSystemDataSource());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSource").add("S3DataSource", s3DataSource())
                .add("FileSystemDataSource", fileSystemDataSource()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "S3DataSource":
            return Optional.ofNullable(clazz.cast(s3DataSource()));
        case "FileSystemDataSource":
            return Optional.ofNullable(clazz.cast(fileSystemDataSource()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("S3DataSource", S3_DATA_SOURCE_FIELD);
        map.put("FileSystemDataSource", FILE_SYSTEM_DATA_SOURCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSource, T> g) {
        return obj -> g.apply((DataSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The S3 location of the data source that is associated with a channel.
         * </p>
         * 
         * @param s3DataSource
         *        The S3 location of the data source that is associated with a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3DataSource(S3DataSource s3DataSource);

        /**
         * <p>
         * The S3 location of the data source that is associated with a channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3DataSource.Builder} avoiding the need
         * to create one manually via {@link S3DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3DataSource.Builder#build()} is called immediately and its
         * result is passed to {@link #s3DataSource(S3DataSource)}.
         * 
         * @param s3DataSource
         *        a consumer that will call methods on {@link S3DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3DataSource(S3DataSource)
         */
        default Builder s3DataSource(Consumer<S3DataSource.Builder> s3DataSource) {
            return s3DataSource(S3DataSource.builder().applyMutation(s3DataSource).build());
        }

        /**
         * <p>
         * The file system that is associated with a channel.
         * </p>
         * 
         * @param fileSystemDataSource
         *        The file system that is associated with a channel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemDataSource(FileSystemDataSource fileSystemDataSource);

        /**
         * <p>
         * The file system that is associated with a channel.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileSystemDataSource.Builder} avoiding
         * the need to create one manually via {@link FileSystemDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileSystemDataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #fileSystemDataSource(FileSystemDataSource)}.
         * 
         * @param fileSystemDataSource
         *        a consumer that will call methods on {@link FileSystemDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fileSystemDataSource(FileSystemDataSource)
         */
        default Builder fileSystemDataSource(Consumer<FileSystemDataSource.Builder> fileSystemDataSource) {
            return fileSystemDataSource(FileSystemDataSource.builder().applyMutation(fileSystemDataSource).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private S3DataSource s3DataSource;

        private FileSystemDataSource fileSystemDataSource;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            s3DataSource(model.s3DataSource);
            fileSystemDataSource(model.fileSystemDataSource);
        }

        public final S3DataSource.Builder getS3DataSource() {
            return s3DataSource != null ? s3DataSource.toBuilder() : null;
        }

        public final void setS3DataSource(S3DataSource.BuilderImpl s3DataSource) {
            this.s3DataSource = s3DataSource != null ? s3DataSource.build() : null;
        }

        @Override
        public final Builder s3DataSource(S3DataSource s3DataSource) {
            this.s3DataSource = s3DataSource;
            return this;
        }

        public final FileSystemDataSource.Builder getFileSystemDataSource() {
            return fileSystemDataSource != null ? fileSystemDataSource.toBuilder() : null;
        }

        public final void setFileSystemDataSource(FileSystemDataSource.BuilderImpl fileSystemDataSource) {
            this.fileSystemDataSource = fileSystemDataSource != null ? fileSystemDataSource.build() : null;
        }

        @Override
        public final Builder fileSystemDataSource(FileSystemDataSource fileSystemDataSource) {
            this.fileSystemDataSource = fileSystemDataSource;
            return this;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
