/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback
 * configurations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeploymentConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DeploymentConfig.Builder, DeploymentConfig> {
    private static final SdkField<BlueGreenUpdatePolicy> BLUE_GREEN_UPDATE_POLICY_FIELD = SdkField
            .<BlueGreenUpdatePolicy> builder(MarshallingType.SDK_POJO).memberName("BlueGreenUpdatePolicy")
            .getter(getter(DeploymentConfig::blueGreenUpdatePolicy)).setter(setter(Builder::blueGreenUpdatePolicy))
            .constructor(BlueGreenUpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueGreenUpdatePolicy").build())
            .build();

    private static final SdkField<RollingUpdatePolicy> ROLLING_UPDATE_POLICY_FIELD = SdkField
            .<RollingUpdatePolicy> builder(MarshallingType.SDK_POJO).memberName("RollingUpdatePolicy")
            .getter(getter(DeploymentConfig::rollingUpdatePolicy)).setter(setter(Builder::rollingUpdatePolicy))
            .constructor(RollingUpdatePolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RollingUpdatePolicy").build())
            .build();

    private static final SdkField<AutoRollbackConfig> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField
            .<AutoRollbackConfig> builder(MarshallingType.SDK_POJO).memberName("AutoRollbackConfiguration")
            .getter(getter(DeploymentConfig::autoRollbackConfiguration)).setter(setter(Builder::autoRollbackConfiguration))
            .constructor(AutoRollbackConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRollbackConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            BLUE_GREEN_UPDATE_POLICY_FIELD, ROLLING_UPDATE_POLICY_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BlueGreenUpdatePolicy blueGreenUpdatePolicy;

    private final RollingUpdatePolicy rollingUpdatePolicy;

    private final AutoRollbackConfig autoRollbackConfiguration;

    private DeploymentConfig(BuilderImpl builder) {
        this.blueGreenUpdatePolicy = builder.blueGreenUpdatePolicy;
        this.rollingUpdatePolicy = builder.rollingUpdatePolicy;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
    }

    /**
     * <p>
     * Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet
     * during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to the
     * specified traffic routing configuration. Only one update policy should be used in the deployment configuration.
     * If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at once traffic
     * shifting by default.
     * </p>
     * 
     * @return Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new
     *         fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet
     *         according to the specified traffic routing configuration. Only one update policy should be used in the
     *         deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment
     *         strategy with all at once traffic shifting by default.
     */
    public final BlueGreenUpdatePolicy blueGreenUpdatePolicy() {
        return blueGreenUpdatePolicy;
    }

    /**
     * <p>
     * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
     * </p>
     * 
     * @return Specifies a rolling deployment strategy for updating a SageMaker endpoint.
     */
    public final RollingUpdatePolicy rollingUpdatePolicy() {
        return rollingUpdatePolicy;
    }

    /**
     * <p>
     * Automatic rollback configuration for handling endpoint deployment failures and recovery.
     * </p>
     * 
     * @return Automatic rollback configuration for handling endpoint deployment failures and recovery.
     */
    public final AutoRollbackConfig autoRollbackConfiguration() {
        return autoRollbackConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(blueGreenUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(rollingUpdatePolicy());
        hashCode = 31 * hashCode + Objects.hashCode(autoRollbackConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfig)) {
            return false;
        }
        DeploymentConfig other = (DeploymentConfig) obj;
        return Objects.equals(blueGreenUpdatePolicy(), other.blueGreenUpdatePolicy())
                && Objects.equals(rollingUpdatePolicy(), other.rollingUpdatePolicy())
                && Objects.equals(autoRollbackConfiguration(), other.autoRollbackConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeploymentConfig").add("BlueGreenUpdatePolicy", blueGreenUpdatePolicy())
                .add("RollingUpdatePolicy", rollingUpdatePolicy()).add("AutoRollbackConfiguration", autoRollbackConfiguration())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BlueGreenUpdatePolicy":
            return Optional.ofNullable(clazz.cast(blueGreenUpdatePolicy()));
        case "RollingUpdatePolicy":
            return Optional.ofNullable(clazz.cast(rollingUpdatePolicy()));
        case "AutoRollbackConfiguration":
            return Optional.ofNullable(clazz.cast(autoRollbackConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BlueGreenUpdatePolicy", BLUE_GREEN_UPDATE_POLICY_FIELD);
        map.put("RollingUpdatePolicy", ROLLING_UPDATE_POLICY_FIELD);
        map.put("AutoRollbackConfiguration", AUTO_ROLLBACK_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeploymentConfig, T> g) {
        return obj -> g.apply((DeploymentConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeploymentConfig> {
        /**
         * <p>
         * Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet
         * during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to
         * the specified traffic routing configuration. Only one update policy should be used in the deployment
         * configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at
         * once traffic shifting by default.
         * </p>
         * 
         * @param blueGreenUpdatePolicy
         *        Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new
         *        fleet during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet
         *        according to the specified traffic routing configuration. Only one update policy should be used in the
         *        deployment configuration. If no update policy is specified, SageMaker uses a blue/green deployment
         *        strategy with all at once traffic shifting by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy blueGreenUpdatePolicy);

        /**
         * <p>
         * Update policy for a blue/green deployment. If this update policy is specified, SageMaker creates a new fleet
         * during the deployment while maintaining the old fleet. SageMaker flips traffic to the new fleet according to
         * the specified traffic routing configuration. Only one update policy should be used in the deployment
         * configuration. If no update policy is specified, SageMaker uses a blue/green deployment strategy with all at
         * once traffic shifting by default.
         * </p>
         * This is a convenience method that creates an instance of the {@link BlueGreenUpdatePolicy.Builder} avoiding
         * the need to create one manually via {@link BlueGreenUpdatePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlueGreenUpdatePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #blueGreenUpdatePolicy(BlueGreenUpdatePolicy)}.
         * 
         * @param blueGreenUpdatePolicy
         *        a consumer that will call methods on {@link BlueGreenUpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blueGreenUpdatePolicy(BlueGreenUpdatePolicy)
         */
        default Builder blueGreenUpdatePolicy(Consumer<BlueGreenUpdatePolicy.Builder> blueGreenUpdatePolicy) {
            return blueGreenUpdatePolicy(BlueGreenUpdatePolicy.builder().applyMutation(blueGreenUpdatePolicy).build());
        }

        /**
         * <p>
         * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
         * </p>
         * 
         * @param rollingUpdatePolicy
         *        Specifies a rolling deployment strategy for updating a SageMaker endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rollingUpdatePolicy(RollingUpdatePolicy rollingUpdatePolicy);

        /**
         * <p>
         * Specifies a rolling deployment strategy for updating a SageMaker endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link RollingUpdatePolicy.Builder} avoiding the
         * need to create one manually via {@link RollingUpdatePolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RollingUpdatePolicy.Builder#build()} is called immediately and
         * its result is passed to {@link #rollingUpdatePolicy(RollingUpdatePolicy)}.
         * 
         * @param rollingUpdatePolicy
         *        a consumer that will call methods on {@link RollingUpdatePolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rollingUpdatePolicy(RollingUpdatePolicy)
         */
        default Builder rollingUpdatePolicy(Consumer<RollingUpdatePolicy.Builder> rollingUpdatePolicy) {
            return rollingUpdatePolicy(RollingUpdatePolicy.builder().applyMutation(rollingUpdatePolicy).build());
        }

        /**
         * <p>
         * Automatic rollback configuration for handling endpoint deployment failures and recovery.
         * </p>
         * 
         * @param autoRollbackConfiguration
         *        Automatic rollback configuration for handling endpoint deployment failures and recovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration);

        /**
         * <p>
         * Automatic rollback configuration for handling endpoint deployment failures and recovery.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutoRollbackConfig.Builder} avoiding the
         * need to create one manually via {@link AutoRollbackConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutoRollbackConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #autoRollbackConfiguration(AutoRollbackConfig)}.
         * 
         * @param autoRollbackConfiguration
         *        a consumer that will call methods on {@link AutoRollbackConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoRollbackConfiguration(AutoRollbackConfig)
         */
        default Builder autoRollbackConfiguration(Consumer<AutoRollbackConfig.Builder> autoRollbackConfiguration) {
            return autoRollbackConfiguration(AutoRollbackConfig.builder().applyMutation(autoRollbackConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlueGreenUpdatePolicy blueGreenUpdatePolicy;

        private RollingUpdatePolicy rollingUpdatePolicy;

        private AutoRollbackConfig autoRollbackConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentConfig model) {
            blueGreenUpdatePolicy(model.blueGreenUpdatePolicy);
            rollingUpdatePolicy(model.rollingUpdatePolicy);
            autoRollbackConfiguration(model.autoRollbackConfiguration);
        }

        public final BlueGreenUpdatePolicy.Builder getBlueGreenUpdatePolicy() {
            return blueGreenUpdatePolicy != null ? blueGreenUpdatePolicy.toBuilder() : null;
        }

        public final void setBlueGreenUpdatePolicy(BlueGreenUpdatePolicy.BuilderImpl blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy != null ? blueGreenUpdatePolicy.build() : null;
        }

        @Override
        public final Builder blueGreenUpdatePolicy(BlueGreenUpdatePolicy blueGreenUpdatePolicy) {
            this.blueGreenUpdatePolicy = blueGreenUpdatePolicy;
            return this;
        }

        public final RollingUpdatePolicy.Builder getRollingUpdatePolicy() {
            return rollingUpdatePolicy != null ? rollingUpdatePolicy.toBuilder() : null;
        }

        public final void setRollingUpdatePolicy(RollingUpdatePolicy.BuilderImpl rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy != null ? rollingUpdatePolicy.build() : null;
        }

        @Override
        public final Builder rollingUpdatePolicy(RollingUpdatePolicy rollingUpdatePolicy) {
            this.rollingUpdatePolicy = rollingUpdatePolicy;
            return this;
        }

        public final AutoRollbackConfig.Builder getAutoRollbackConfiguration() {
            return autoRollbackConfiguration != null ? autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfig.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfig autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        @Override
        public DeploymentConfig build() {
            return new DeploymentConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
