/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterNodeResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeClusterNodeResponse.Builder, DescribeClusterNodeResponse> {
    private static final SdkField<ClusterNodeDetails> NODE_DETAILS_FIELD = SdkField
            .<ClusterNodeDetails> builder(MarshallingType.SDK_POJO).memberName("NodeDetails")
            .getter(getter(DescribeClusterNodeResponse::nodeDetails)).setter(setter(Builder::nodeDetails))
            .constructor(ClusterNodeDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ClusterNodeDetails nodeDetails;

    private DescribeClusterNodeResponse(BuilderImpl builder) {
        super(builder);
        this.nodeDetails = builder.nodeDetails;
    }

    /**
     * <p>
     * The details of the SageMaker HyperPod cluster node.
     * </p>
     * 
     * @return The details of the SageMaker HyperPod cluster node.
     */
    public final ClusterNodeDetails nodeDetails() {
        return nodeDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nodeDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterNodeResponse)) {
            return false;
        }
        DescribeClusterNodeResponse other = (DescribeClusterNodeResponse) obj;
        return Objects.equals(nodeDetails(), other.nodeDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeClusterNodeResponse").add("NodeDetails", nodeDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeDetails":
            return Optional.ofNullable(clazz.cast(nodeDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeDetails", NODE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterNodeResponse, T> g) {
        return obj -> g.apply((DescribeClusterNodeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeClusterNodeResponse> {
        /**
         * <p>
         * The details of the SageMaker HyperPod cluster node.
         * </p>
         * 
         * @param nodeDetails
         *        The details of the SageMaker HyperPod cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeDetails(ClusterNodeDetails nodeDetails);

        /**
         * <p>
         * The details of the SageMaker HyperPod cluster node.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClusterNodeDetails.Builder} avoiding the
         * need to create one manually via {@link ClusterNodeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClusterNodeDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #nodeDetails(ClusterNodeDetails)}.
         * 
         * @param nodeDetails
         *        a consumer that will call methods on {@link ClusterNodeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nodeDetails(ClusterNodeDetails)
         */
        default Builder nodeDetails(Consumer<ClusterNodeDetails.Builder> nodeDetails) {
            return nodeDetails(ClusterNodeDetails.builder().applyMutation(nodeDetails).build());
        }
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private ClusterNodeDetails nodeDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterNodeResponse model) {
            super(model);
            nodeDetails(model.nodeDetails);
        }

        public final ClusterNodeDetails.Builder getNodeDetails() {
            return nodeDetails != null ? nodeDetails.toBuilder() : null;
        }

        public final void setNodeDetails(ClusterNodeDetails.BuilderImpl nodeDetails) {
            this.nodeDetails = nodeDetails != null ? nodeDetails.build() : null;
        }

        @Override
        public final Builder nodeDetails(ClusterNodeDetails nodeDetails) {
            this.nodeDetails = nodeDetails;
            return this;
        }

        @Override
        public DescribeClusterNodeResponse build() {
            return new DescribeClusterNodeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
