/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeComputeQuotaRequest extends SageMakerRequest implements
        ToCopyableBuilder<DescribeComputeQuotaRequest.Builder, DescribeComputeQuotaRequest> {
    private static final SdkField<String> COMPUTE_QUOTA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComputeQuotaId").getter(getter(DescribeComputeQuotaRequest::computeQuotaId))
            .setter(setter(Builder::computeQuotaId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaId").build()).build();

    private static final SdkField<Integer> COMPUTE_QUOTA_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ComputeQuotaVersion").getter(getter(DescribeComputeQuotaRequest::computeQuotaVersion))
            .setter(setter(Builder::computeQuotaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeQuotaVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPUTE_QUOTA_ID_FIELD,
            COMPUTE_QUOTA_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String computeQuotaId;

    private final Integer computeQuotaVersion;

    private DescribeComputeQuotaRequest(BuilderImpl builder) {
        super(builder);
        this.computeQuotaId = builder.computeQuotaId;
        this.computeQuotaVersion = builder.computeQuotaVersion;
    }

    /**
     * <p>
     * ID of the compute allocation definition.
     * </p>
     * 
     * @return ID of the compute allocation definition.
     */
    public final String computeQuotaId() {
        return computeQuotaId;
    }

    /**
     * <p>
     * Version of the compute allocation definition.
     * </p>
     * 
     * @return Version of the compute allocation definition.
     */
    public final Integer computeQuotaVersion() {
        return computeQuotaVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaId());
        hashCode = 31 * hashCode + Objects.hashCode(computeQuotaVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeComputeQuotaRequest)) {
            return false;
        }
        DescribeComputeQuotaRequest other = (DescribeComputeQuotaRequest) obj;
        return Objects.equals(computeQuotaId(), other.computeQuotaId())
                && Objects.equals(computeQuotaVersion(), other.computeQuotaVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeComputeQuotaRequest").add("ComputeQuotaId", computeQuotaId())
                .add("ComputeQuotaVersion", computeQuotaVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComputeQuotaId":
            return Optional.ofNullable(clazz.cast(computeQuotaId()));
        case "ComputeQuotaVersion":
            return Optional.ofNullable(clazz.cast(computeQuotaVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ComputeQuotaId", COMPUTE_QUOTA_ID_FIELD);
        map.put("ComputeQuotaVersion", COMPUTE_QUOTA_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeComputeQuotaRequest, T> g) {
        return obj -> g.apply((DescribeComputeQuotaRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeComputeQuotaRequest> {
        /**
         * <p>
         * ID of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaId
         *        ID of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaId(String computeQuotaId);

        /**
         * <p>
         * Version of the compute allocation definition.
         * </p>
         * 
         * @param computeQuotaVersion
         *        Version of the compute allocation definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeQuotaVersion(Integer computeQuotaVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String computeQuotaId;

        private Integer computeQuotaVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeComputeQuotaRequest model) {
            super(model);
            computeQuotaId(model.computeQuotaId);
            computeQuotaVersion(model.computeQuotaVersion);
        }

        public final String getComputeQuotaId() {
            return computeQuotaId;
        }

        public final void setComputeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
        }

        @Override
        public final Builder computeQuotaId(String computeQuotaId) {
            this.computeQuotaId = computeQuotaId;
            return this;
        }

        public final Integer getComputeQuotaVersion() {
            return computeQuotaVersion;
        }

        public final void setComputeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
        }

        @Override
        public final Builder computeQuotaVersion(Integer computeQuotaVersion) {
            this.computeQuotaVersion = computeQuotaVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeComputeQuotaRequest build() {
            return new DescribeComputeQuotaRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
