/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeHubResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeHubResponse.Builder, DescribeHubResponse> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(DescribeHubResponse::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("HubArn")
            .getter(getter(DescribeHubResponse::hubArn)).setter(setter(Builder::hubArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()).build();

    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDisplayName").getter(getter(DescribeHubResponse::hubDisplayName))
            .setter(setter(Builder::hubDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()).build();

    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubDescription").getter(getter(DescribeHubResponse::hubDescription))
            .setter(setter(Builder::hubDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()).build();

    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubSearchKeywords")
            .getter(getter(DescribeHubResponse::hubSearchKeywords))
            .setter(setter(Builder::hubSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<HubS3StorageConfig> S3_STORAGE_CONFIG_FIELD = SdkField
            .<HubS3StorageConfig> builder(MarshallingType.SDK_POJO).memberName("S3StorageConfig")
            .getter(getter(DescribeHubResponse::s3StorageConfig)).setter(setter(Builder::s3StorageConfig))
            .constructor(HubS3StorageConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3StorageConfig").build()).build();

    private static final SdkField<String> HUB_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubStatus").getter(getter(DescribeHubResponse::hubStatusAsString)).setter(setter(Builder::hubStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubStatus").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(DescribeHubResponse::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeHubResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeHubResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_ARN_FIELD,
            HUB_DISPLAY_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_SEARCH_KEYWORDS_FIELD, S3_STORAGE_CONFIG_FIELD, HUB_STATUS_FIELD,
            FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubName;

    private final String hubArn;

    private final String hubDisplayName;

    private final String hubDescription;

    private final List<String> hubSearchKeywords;

    private final HubS3StorageConfig s3StorageConfig;

    private final String hubStatus;

    private final String failureReason;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private DescribeHubResponse(BuilderImpl builder) {
        super(builder);
        this.hubName = builder.hubName;
        this.hubArn = builder.hubArn;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubDescription = builder.hubDescription;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.s3StorageConfig = builder.s3StorageConfig;
        this.hubStatus = builder.hubStatus;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the hub.
     * </p>
     * 
     * @return The name of the hub.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the hub.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the hub.
     */
    public final String hubArn() {
        return hubArn;
    }

    /**
     * <p>
     * The display name of the hub.
     * </p>
     * 
     * @return The display name of the hub.
     */
    public final String hubDisplayName() {
        return hubDisplayName;
    }

    /**
     * <p>
     * A description of the hub.
     * </p>
     * 
     * @return A description of the hub.
     */
    public final String hubDescription() {
        return hubDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubSearchKeywords property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHubSearchKeywords() {
        return hubSearchKeywords != null && !(hubSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords for the hub.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords for the hub.
     */
    public final List<String> hubSearchKeywords() {
        return hubSearchKeywords;
    }

    /**
     * <p>
     * The Amazon S3 storage configuration for the hub.
     * </p>
     * 
     * @return The Amazon S3 storage configuration for the hub.
     */
    public final HubS3StorageConfig s3StorageConfig() {
        return s3StorageConfig;
    }

    /**
     * <p>
     * The status of the hub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubStatus} will
     * return {@link HubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hubStatusAsString}.
     * </p>
     * 
     * @return The status of the hub.
     * @see HubStatus
     */
    public final HubStatus hubStatus() {
        return HubStatus.fromValue(hubStatus);
    }

    /**
     * <p>
     * The status of the hub.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubStatus} will
     * return {@link HubStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #hubStatusAsString}.
     * </p>
     * 
     * @return The status of the hub.
     * @see HubStatus
     */
    public final String hubStatusAsString() {
        return hubStatus;
    }

    /**
     * <p>
     * The failure reason if importing hub content failed.
     * </p>
     * 
     * @return The failure reason if importing hub content failed.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The date and time that the hub was created.
     * </p>
     * 
     * @return The date and time that the hub was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the hub was last modified.
     * </p>
     * 
     * @return The date and time that the hub was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubSearchKeywords() ? hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3StorageConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hubStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHubResponse)) {
            return false;
        }
        DescribeHubResponse other = (DescribeHubResponse) obj;
        return Objects.equals(hubName(), other.hubName()) && Objects.equals(hubArn(), other.hubArn())
                && Objects.equals(hubDisplayName(), other.hubDisplayName())
                && Objects.equals(hubDescription(), other.hubDescription())
                && hasHubSearchKeywords() == other.hasHubSearchKeywords()
                && Objects.equals(hubSearchKeywords(), other.hubSearchKeywords())
                && Objects.equals(s3StorageConfig(), other.s3StorageConfig())
                && Objects.equals(hubStatusAsString(), other.hubStatusAsString())
                && Objects.equals(failureReason(), other.failureReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeHubResponse").add("HubName", hubName()).add("HubArn", hubArn())
                .add("HubDisplayName", hubDisplayName()).add("HubDescription", hubDescription())
                .add("HubSearchKeywords", hasHubSearchKeywords() ? hubSearchKeywords() : null)
                .add("S3StorageConfig", s3StorageConfig()).add("HubStatus", hubStatusAsString())
                .add("FailureReason", failureReason()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubArn":
            return Optional.ofNullable(clazz.cast(hubArn()));
        case "HubDisplayName":
            return Optional.ofNullable(clazz.cast(hubDisplayName()));
        case "HubDescription":
            return Optional.ofNullable(clazz.cast(hubDescription()));
        case "HubSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubSearchKeywords()));
        case "S3StorageConfig":
            return Optional.ofNullable(clazz.cast(s3StorageConfig()));
        case "HubStatus":
            return Optional.ofNullable(clazz.cast(hubStatusAsString()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
        map.put("HubDescription", HUB_DESCRIPTION_FIELD);
        map.put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
        map.put("S3StorageConfig", S3_STORAGE_CONFIG_FIELD);
        map.put("HubStatus", HUB_STATUS_FIELD);
        map.put("FailureReason", FAILURE_REASON_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHubResponse, T> g) {
        return obj -> g.apply((DescribeHubResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeHubResponse> {
        /**
         * <p>
         * The name of the hub.
         * </p>
         * 
         * @param hubName
         *        The name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the hub.
         * </p>
         * 
         * @param hubArn
         *        The Amazon Resource Name (ARN) of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubArn(String hubArn);

        /**
         * <p>
         * The display name of the hub.
         * </p>
         * 
         * @param hubDisplayName
         *        The display name of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDisplayName(String hubDisplayName);

        /**
         * <p>
         * A description of the hub.
         * </p>
         * 
         * @param hubDescription
         *        A description of the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubDescription(String hubDescription);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(Collection<String> hubSearchKeywords);

        /**
         * <p>
         * The searchable keywords for the hub.
         * </p>
         * 
         * @param hubSearchKeywords
         *        The searchable keywords for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubSearchKeywords(String... hubSearchKeywords);

        /**
         * <p>
         * The Amazon S3 storage configuration for the hub.
         * </p>
         * 
         * @param s3StorageConfig
         *        The Amazon S3 storage configuration for the hub.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig);

        /**
         * <p>
         * The Amazon S3 storage configuration for the hub.
         * </p>
         * This is a convenience method that creates an instance of the {@link HubS3StorageConfig.Builder} avoiding the
         * need to create one manually via {@link HubS3StorageConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HubS3StorageConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3StorageConfig(HubS3StorageConfig)}.
         * 
         * @param s3StorageConfig
         *        a consumer that will call methods on {@link HubS3StorageConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3StorageConfig(HubS3StorageConfig)
         */
        default Builder s3StorageConfig(Consumer<HubS3StorageConfig.Builder> s3StorageConfig) {
            return s3StorageConfig(HubS3StorageConfig.builder().applyMutation(s3StorageConfig).build());
        }

        /**
         * <p>
         * The status of the hub.
         * </p>
         * 
         * @param hubStatus
         *        The status of the hub.
         * @see HubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubStatus
         */
        Builder hubStatus(String hubStatus);

        /**
         * <p>
         * The status of the hub.
         * </p>
         * 
         * @param hubStatus
         *        The status of the hub.
         * @see HubStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubStatus
         */
        Builder hubStatus(HubStatus hubStatus);

        /**
         * <p>
         * The failure reason if importing hub content failed.
         * </p>
         * 
         * @param failureReason
         *        The failure reason if importing hub content failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The date and time that the hub was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the hub was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the hub was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the hub was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String hubName;

        private String hubArn;

        private String hubDisplayName;

        private String hubDescription;

        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private HubS3StorageConfig s3StorageConfig;

        private String hubStatus;

        private String failureReason;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHubResponse model) {
            super(model);
            hubName(model.hubName);
            hubArn(model.hubArn);
            hubDisplayName(model.hubDisplayName);
            hubDescription(model.hubDescription);
            hubSearchKeywords(model.hubSearchKeywords);
            s3StorageConfig(model.s3StorageConfig);
            hubStatus(model.hubStatus);
            failureReason(model.failureReason);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubArn() {
            return hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubDisplayName() {
            return hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final String getHubDescription() {
            return hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String... hubSearchKeywords) {
            hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final HubS3StorageConfig.Builder getS3StorageConfig() {
            return s3StorageConfig != null ? s3StorageConfig.toBuilder() : null;
        }

        public final void setS3StorageConfig(HubS3StorageConfig.BuilderImpl s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig != null ? s3StorageConfig.build() : null;
        }

        @Override
        public final Builder s3StorageConfig(HubS3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public final String getHubStatus() {
            return hubStatus;
        }

        public final void setHubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
        }

        @Override
        public final Builder hubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
            return this;
        }

        @Override
        public final Builder hubStatus(HubStatus hubStatus) {
            this.hubStatus(hubStatus == null ? null : hubStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public DescribeHubResponse build() {
            return new DescribeHubResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
