/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeModelCardResponse extends SageMakerResponse implements
        ToCopyableBuilder<DescribeModelCardResponse.Builder, DescribeModelCardResponse> {
    private static final SdkField<String> MODEL_CARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardArn").getter(getter(DescribeModelCardResponse::modelCardArn))
            .setter(setter(Builder::modelCardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardArn").build()).build();

    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(DescribeModelCardResponse::modelCardName))
            .setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<Integer> MODEL_CARD_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ModelCardVersion").getter(getter(DescribeModelCardResponse::modelCardVersion))
            .setter(setter(Builder::modelCardVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardVersion").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(DescribeModelCardResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(DescribeModelCardResponse::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final SdkField<ModelCardSecurityConfig> SECURITY_CONFIG_FIELD = SdkField
            .<ModelCardSecurityConfig> builder(MarshallingType.SDK_POJO).memberName("SecurityConfig")
            .getter(getter(DescribeModelCardResponse::securityConfig)).setter(setter(Builder::securityConfig))
            .constructor(ModelCardSecurityConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(DescribeModelCardResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("CreatedBy").getter(getter(DescribeModelCardResponse::createdBy)).setter(setter(Builder::createdBy))
            .constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(DescribeModelCardResponse::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.<UserContext> builder(MarshallingType.SDK_POJO)
            .memberName("LastModifiedBy").getter(getter(DescribeModelCardResponse::lastModifiedBy))
            .setter(setter(Builder::lastModifiedBy)).constructor(UserContext::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()).build();

    private static final SdkField<String> MODEL_CARD_PROCESSING_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardProcessingStatus").getter(getter(DescribeModelCardResponse::modelCardProcessingStatusAsString))
            .setter(setter(Builder::modelCardProcessingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardProcessingStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_ARN_FIELD,
            MODEL_CARD_NAME_FIELD, MODEL_CARD_VERSION_FIELD, CONTENT_FIELD, MODEL_CARD_STATUS_FIELD, SECURITY_CONFIG_FIELD,
            CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD,
            MODEL_CARD_PROCESSING_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelCardArn;

    private final String modelCardName;

    private final Integer modelCardVersion;

    private final String content;

    private final String modelCardStatus;

    private final ModelCardSecurityConfig securityConfig;

    private final Instant creationTime;

    private final UserContext createdBy;

    private final Instant lastModifiedTime;

    private final UserContext lastModifiedBy;

    private final String modelCardProcessingStatus;

    private DescribeModelCardResponse(BuilderImpl builder) {
        super(builder);
        this.modelCardArn = builder.modelCardArn;
        this.modelCardName = builder.modelCardName;
        this.modelCardVersion = builder.modelCardVersion;
        this.content = builder.content;
        this.modelCardStatus = builder.modelCardStatus;
        this.securityConfig = builder.securityConfig;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.modelCardProcessingStatus = builder.modelCardProcessingStatus;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model card.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model card.
     */
    public final String modelCardArn() {
        return modelCardArn;
    }

    /**
     * <p>
     * The name of the model card.
     * </p>
     * 
     * @return The name of the model card.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The version of the model card.
     * </p>
     * 
     * @return The version of the model card.
     */
    public final Integer modelCardVersion() {
        return modelCardVersion;
    }

    /**
     * <p>
     * The content of the model card.
     * </p>
     * 
     * @return The content of the model card.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    /**
     * <p>
     * The security configuration used to protect model card content.
     * </p>
     * 
     * @return The security configuration used to protect model card content.
     */
    public final ModelCardSecurityConfig securityConfig() {
        return securityConfig;
    }

    /**
     * <p>
     * The date and time the model card was created.
     * </p>
     * 
     * @return The date and time the model card was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * Returns the value of the CreatedBy property for this object.
     * 
     * @return The value of the CreatedBy property for this object.
     */
    public final UserContext createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the model card was last modified.
     * </p>
     * 
     * @return The date and time the model card was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * Returns the value of the LastModifiedBy property for this object.
     * 
     * @return The value of the LastModifiedBy property for this object.
     */
    public final UserContext lastModifiedBy() {
        return lastModifiedBy;
    }

    /**
     * <p>
     * The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates throughout the
     * different deletion steps.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeletePending</code>: Model card deletion request received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code>: Model card deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContentDeleted</code>: Deleted model card content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteCompleted</code>: Successfully deleted the model card.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteFailed</code>: The model card failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelCardProcessingStatus} will return {@link ModelCardProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelCardProcessingStatusAsString}.
     * </p>
     * 
     * @return The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates
     *         throughout the different deletion steps.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeletePending</code>: Model card deletion request received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code>: Model card deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ContentDeleted</code>: Deleted model card content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteCompleted</code>: Successfully deleted the model card.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteFailed</code>: The model card failed to delete.
     *         </p>
     *         </li>
     * @see ModelCardProcessingStatus
     */
    public final ModelCardProcessingStatus modelCardProcessingStatus() {
        return ModelCardProcessingStatus.fromValue(modelCardProcessingStatus);
    }

    /**
     * <p>
     * The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates throughout the
     * different deletion steps.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>DeletePending</code>: Model card deletion request received.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteInProgress</code>: Model card deletion is in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContentDeleted</code>: Deleted model card content.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteCompleted</code>: Successfully deleted the model card.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DeleteFailed</code>: The model card failed to delete.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #modelCardProcessingStatus} will return {@link ModelCardProcessingStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #modelCardProcessingStatusAsString}.
     * </p>
     * 
     * @return The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates
     *         throughout the different deletion steps.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>DeletePending</code>: Model card deletion request received.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteInProgress</code>: Model card deletion is in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ContentDeleted</code>: Deleted model card content.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteCompleted</code>: Successfully deleted the model card.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DeleteFailed</code>: The model card failed to delete.
     *         </p>
     *         </li>
     * @see ModelCardProcessingStatus
     */
    public final String modelCardProcessingStatusAsString() {
        return modelCardProcessingStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelCardArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardVersion());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(securityConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedBy());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardProcessingStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeModelCardResponse)) {
            return false;
        }
        DescribeModelCardResponse other = (DescribeModelCardResponse) obj;
        return Objects.equals(modelCardArn(), other.modelCardArn()) && Objects.equals(modelCardName(), other.modelCardName())
                && Objects.equals(modelCardVersion(), other.modelCardVersion()) && Objects.equals(content(), other.content())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString())
                && Objects.equals(securityConfig(), other.securityConfig())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(lastModifiedBy(), other.lastModifiedBy())
                && Objects.equals(modelCardProcessingStatusAsString(), other.modelCardProcessingStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeModelCardResponse").add("ModelCardArn", modelCardArn())
                .add("ModelCardName", modelCardName()).add("ModelCardVersion", modelCardVersion())
                .add("Content", content() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ModelCardStatus", modelCardStatusAsString()).add("SecurityConfig", securityConfig())
                .add("CreationTime", creationTime()).add("CreatedBy", createdBy()).add("LastModifiedTime", lastModifiedTime())
                .add("LastModifiedBy", lastModifiedBy()).add("ModelCardProcessingStatus", modelCardProcessingStatusAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardArn":
            return Optional.ofNullable(clazz.cast(modelCardArn()));
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardVersion":
            return Optional.ofNullable(clazz.cast(modelCardVersion()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        case "SecurityConfig":
            return Optional.ofNullable(clazz.cast(securityConfig()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "LastModifiedBy":
            return Optional.ofNullable(clazz.cast(lastModifiedBy()));
        case "ModelCardProcessingStatus":
            return Optional.ofNullable(clazz.cast(modelCardProcessingStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCardArn", MODEL_CARD_ARN_FIELD);
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("ModelCardVersion", MODEL_CARD_VERSION_FIELD);
        map.put("Content", CONTENT_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        map.put("SecurityConfig", SECURITY_CONFIG_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        map.put("ModelCardProcessingStatus", MODEL_CARD_PROCESSING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeModelCardResponse, T> g) {
        return obj -> g.apply((DescribeModelCardResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeModelCardResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model card.
         * </p>
         * 
         * @param modelCardArn
         *        The Amazon Resource Name (ARN) of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardArn(String modelCardArn);

        /**
         * <p>
         * The name of the model card.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The version of the model card.
         * </p>
         * 
         * @param modelCardVersion
         *        The version of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardVersion(Integer modelCardVersion);

        /**
         * <p>
         * The content of the model card.
         * </p>
         * 
         * @param content
         *        The content of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        /**
         * <p>
         * The security configuration used to protect model card content.
         * </p>
         * 
         * @param securityConfig
         *        The security configuration used to protect model card content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfig(ModelCardSecurityConfig securityConfig);

        /**
         * <p>
         * The security configuration used to protect model card content.
         * </p>
         * This is a convenience method that creates an instance of the {@link ModelCardSecurityConfig.Builder} avoiding
         * the need to create one manually via {@link ModelCardSecurityConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ModelCardSecurityConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #securityConfig(ModelCardSecurityConfig)}.
         * 
         * @param securityConfig
         *        a consumer that will call methods on {@link ModelCardSecurityConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfig(ModelCardSecurityConfig)
         */
        default Builder securityConfig(Consumer<ModelCardSecurityConfig.Builder> securityConfig) {
            return securityConfig(ModelCardSecurityConfig.builder().applyMutation(securityConfig).build());
        }

        /**
         * <p>
         * The date and time the model card was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time the model card was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * @param createdBy
         *        The new value for the CreatedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(UserContext createdBy);

        /**
         * Sets the value of the CreatedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #createdBy(UserContext)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(UserContext)
         */
        default Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return createdBy(UserContext.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The date and time the model card was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time the model card was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * @param lastModifiedBy
         *        The new value for the LastModifiedBy property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedBy(UserContext lastModifiedBy);

        /**
         * Sets the value of the LastModifiedBy property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UserContext.Builder} avoiding the need to
         * create one manually via {@link UserContext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UserContext.Builder#build()} is called immediately and its result
         * is passed to {@link #lastModifiedBy(UserContext)}.
         * 
         * @param lastModifiedBy
         *        a consumer that will call methods on {@link UserContext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedBy(UserContext)
         */
        default Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return lastModifiedBy(UserContext.builder().applyMutation(lastModifiedBy).build());
        }

        /**
         * <p>
         * The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates throughout
         * the different deletion steps.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeletePending</code>: Model card deletion request received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code>: Model card deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContentDeleted</code>: Deleted model card content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteCompleted</code>: Successfully deleted the model card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteFailed</code>: The model card failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardProcessingStatus
         *        The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates
         *        throughout the different deletion steps.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeletePending</code>: Model card deletion request received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code>: Model card deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContentDeleted</code>: Deleted model card content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteCompleted</code>: Successfully deleted the model card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteFailed</code>: The model card failed to delete.
         *        </p>
         *        </li>
         * @see ModelCardProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardProcessingStatus
         */
        Builder modelCardProcessingStatus(String modelCardProcessingStatus);

        /**
         * <p>
         * The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates throughout
         * the different deletion steps.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>DeletePending</code>: Model card deletion request received.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteInProgress</code>: Model card deletion is in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContentDeleted</code>: Deleted model card content.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteCompleted</code>: Successfully deleted the model card.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DeleteFailed</code>: The model card failed to delete.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardProcessingStatus
         *        The processing status of model card deletion. The <code>ModelCardProcessingStatus</code> updates
         *        throughout the different deletion steps.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>DeletePending</code>: Model card deletion request received.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteInProgress</code>: Model card deletion is in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContentDeleted</code>: Deleted model card content.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ExportJobsDeleted</code>: Deleted all export jobs associated with the model card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteCompleted</code>: Successfully deleted the model card.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DeleteFailed</code>: The model card failed to delete.
         *        </p>
         *        </li>
         * @see ModelCardProcessingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardProcessingStatus
         */
        Builder modelCardProcessingStatus(ModelCardProcessingStatus modelCardProcessingStatus);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private String modelCardArn;

        private String modelCardName;

        private Integer modelCardVersion;

        private String content;

        private String modelCardStatus;

        private ModelCardSecurityConfig securityConfig;

        private Instant creationTime;

        private UserContext createdBy;

        private Instant lastModifiedTime;

        private UserContext lastModifiedBy;

        private String modelCardProcessingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeModelCardResponse model) {
            super(model);
            modelCardArn(model.modelCardArn);
            modelCardName(model.modelCardName);
            modelCardVersion(model.modelCardVersion);
            content(model.content);
            modelCardStatus(model.modelCardStatus);
            securityConfig(model.securityConfig);
            creationTime(model.creationTime);
            createdBy(model.createdBy);
            lastModifiedTime(model.lastModifiedTime);
            lastModifiedBy(model.lastModifiedBy);
            modelCardProcessingStatus(model.modelCardProcessingStatus);
        }

        public final String getModelCardArn() {
            return modelCardArn;
        }

        public final void setModelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
        }

        @Override
        public final Builder modelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
            return this;
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final Integer getModelCardVersion() {
            return modelCardVersion;
        }

        public final void setModelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
        }

        @Override
        public final Builder modelCardVersion(Integer modelCardVersion) {
            this.modelCardVersion = modelCardVersion;
            return this;
        }

        public final String getContent() {
            return content;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final ModelCardSecurityConfig.Builder getSecurityConfig() {
            return securityConfig != null ? securityConfig.toBuilder() : null;
        }

        public final void setSecurityConfig(ModelCardSecurityConfig.BuilderImpl securityConfig) {
            this.securityConfig = securityConfig != null ? securityConfig.build() : null;
        }

        @Override
        public final Builder securityConfig(ModelCardSecurityConfig securityConfig) {
            this.securityConfig = securityConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return lastModifiedBy != null ? lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public final String getModelCardProcessingStatus() {
            return modelCardProcessingStatus;
        }

        public final void setModelCardProcessingStatus(String modelCardProcessingStatus) {
            this.modelCardProcessingStatus = modelCardProcessingStatus;
        }

        @Override
        public final Builder modelCardProcessingStatus(String modelCardProcessingStatus) {
            this.modelCardProcessingStatus = modelCardProcessingStatus;
            return this;
        }

        @Override
        public final Builder modelCardProcessingStatus(ModelCardProcessingStatus modelCardProcessingStatus) {
            this.modelCardProcessingStatus(modelCardProcessingStatus == null ? null : modelCardProcessingStatus.toString());
            return this;
        }

        @Override
        public DescribeModelCardResponse build() {
            return new DescribeModelCardResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
