/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information of a particular device.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Device implements SdkPojo, Serializable, ToCopyableBuilder<Device.Builder, Device> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(Device::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Device::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IotThingName").getter(getter(Device::iotThingName)).setter(setter(Builder::iotThingName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            DESCRIPTION_FIELD, IOT_THING_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String description;

    private final String iotThingName;

    private Device(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.description = builder.description;
        this.iotThingName = builder.iotThingName;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Description of the device.
     * </p>
     * 
     * @return Description of the device.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Amazon Web Services Internet of Things (IoT) object name.
     * </p>
     * 
     * @return Amazon Web Services Internet of Things (IoT) object name.
     */
    public final String iotThingName() {
        return iotThingName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(iotThingName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(description(), other.description())
                && Objects.equals(iotThingName(), other.iotThingName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Device").add("DeviceName", deviceName()).add("Description", description())
                .add("IotThingName", iotThingName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "IotThingName":
            return Optional.ofNullable(clazz.cast(iotThingName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("IotThingName", IOT_THING_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Device> {
        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param deviceName
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Description of the device.
         * </p>
         * 
         * @param description
         *        Description of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Amazon Web Services Internet of Things (IoT) object name.
         * </p>
         * 
         * @param iotThingName
         *        Amazon Web Services Internet of Things (IoT) object name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iotThingName(String iotThingName);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String description;

        private String iotThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            deviceName(model.deviceName);
            description(model.description);
            iotThingName(model.iotThingName);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getIotThingName() {
            return iotThingName;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        @Override
        public Device build() {
            return new Device(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
