/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information summarizing device details and deployment status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeviceDeploymentSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<DeviceDeploymentSummary.Builder, DeviceDeploymentSummary> {
    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanArn").getter(getter(DeviceDeploymentSummary::edgeDeploymentPlanArn))
            .setter(setter(Builder::edgeDeploymentPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanArn").build())
            .build();

    private static final SdkField<String> EDGE_DEPLOYMENT_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgeDeploymentPlanName").getter(getter(DeviceDeploymentSummary::edgeDeploymentPlanName))
            .setter(setter(Builder::edgeDeploymentPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeDeploymentPlanName").build())
            .build();

    private static final SdkField<String> STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StageName").getter(getter(DeviceDeploymentSummary::stageName)).setter(setter(Builder::stageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StageName").build()).build();

    private static final SdkField<String> DEPLOYED_STAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeployedStageName").getter(getter(DeviceDeploymentSummary::deployedStageName))
            .setter(setter(Builder::deployedStageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployedStageName").build()).build();

    private static final SdkField<String> DEVICE_FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceFleetName").getter(getter(DeviceDeploymentSummary::deviceFleetName))
            .setter(setter(Builder::deviceFleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceFleetName").build()).build();

    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceName").getter(getter(DeviceDeploymentSummary::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> DEVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceArn").getter(getter(DeviceDeploymentSummary::deviceArn)).setter(setter(Builder::deviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceArn").build()).build();

    private static final SdkField<String> DEVICE_DEPLOYMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeviceDeploymentStatus").getter(getter(DeviceDeploymentSummary::deviceDeploymentStatusAsString))
            .setter(setter(Builder::deviceDeploymentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentStatus").build())
            .build();

    private static final SdkField<String> DEVICE_DEPLOYMENT_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("DeviceDeploymentStatusMessage")
            .getter(getter(DeviceDeploymentSummary::deviceDeploymentStatusMessage))
            .setter(setter(Builder::deviceDeploymentStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceDeploymentStatusMessage")
                    .build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(DeviceDeploymentSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> DEPLOYMENT_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("DeploymentStartTime").getter(getter(DeviceDeploymentSummary::deploymentStartTime))
            .setter(setter(Builder::deploymentStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentStartTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EDGE_DEPLOYMENT_PLAN_ARN_FIELD, EDGE_DEPLOYMENT_PLAN_NAME_FIELD, STAGE_NAME_FIELD, DEPLOYED_STAGE_NAME_FIELD,
            DEVICE_FLEET_NAME_FIELD, DEVICE_NAME_FIELD, DEVICE_ARN_FIELD, DEVICE_DEPLOYMENT_STATUS_FIELD,
            DEVICE_DEPLOYMENT_STATUS_MESSAGE_FIELD, DESCRIPTION_FIELD, DEPLOYMENT_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String edgeDeploymentPlanArn;

    private final String edgeDeploymentPlanName;

    private final String stageName;

    private final String deployedStageName;

    private final String deviceFleetName;

    private final String deviceName;

    private final String deviceArn;

    private final String deviceDeploymentStatus;

    private final String deviceDeploymentStatusMessage;

    private final String description;

    private final Instant deploymentStartTime;

    private DeviceDeploymentSummary(BuilderImpl builder) {
        this.edgeDeploymentPlanArn = builder.edgeDeploymentPlanArn;
        this.edgeDeploymentPlanName = builder.edgeDeploymentPlanName;
        this.stageName = builder.stageName;
        this.deployedStageName = builder.deployedStageName;
        this.deviceFleetName = builder.deviceFleetName;
        this.deviceName = builder.deviceName;
        this.deviceArn = builder.deviceArn;
        this.deviceDeploymentStatus = builder.deviceDeploymentStatus;
        this.deviceDeploymentStatusMessage = builder.deviceDeploymentStatusMessage;
        this.description = builder.description;
        this.deploymentStartTime = builder.deploymentStartTime;
    }

    /**
     * <p>
     * The ARN of the edge deployment plan.
     * </p>
     * 
     * @return The ARN of the edge deployment plan.
     */
    public final String edgeDeploymentPlanArn() {
        return edgeDeploymentPlanArn;
    }

    /**
     * <p>
     * The name of the edge deployment plan.
     * </p>
     * 
     * @return The name of the edge deployment plan.
     */
    public final String edgeDeploymentPlanName() {
        return edgeDeploymentPlanName;
    }

    /**
     * <p>
     * The name of the stage in the edge deployment plan.
     * </p>
     * 
     * @return The name of the stage in the edge deployment plan.
     */
    public final String stageName() {
        return stageName;
    }

    /**
     * <p>
     * The name of the deployed stage.
     * </p>
     * 
     * @return The name of the deployed stage.
     */
    public final String deployedStageName() {
        return deployedStageName;
    }

    /**
     * <p>
     * The name of the fleet to which the device belongs to.
     * </p>
     * 
     * @return The name of the fleet to which the device belongs to.
     */
    public final String deviceFleetName() {
        return deviceFleetName;
    }

    /**
     * <p>
     * The name of the device.
     * </p>
     * 
     * @return The name of the device.
     */
    public final String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * The ARN of the device.
     * </p>
     * 
     * @return The ARN of the device.
     */
    public final String deviceArn() {
        return deviceArn;
    }

    /**
     * <p>
     * The deployment status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceDeploymentStatus} will return {@link DeviceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceDeploymentStatusAsString}.
     * </p>
     * 
     * @return The deployment status of the device.
     * @see DeviceDeploymentStatus
     */
    public final DeviceDeploymentStatus deviceDeploymentStatus() {
        return DeviceDeploymentStatus.fromValue(deviceDeploymentStatus);
    }

    /**
     * <p>
     * The deployment status of the device.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #deviceDeploymentStatus} will return {@link DeviceDeploymentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #deviceDeploymentStatusAsString}.
     * </p>
     * 
     * @return The deployment status of the device.
     * @see DeviceDeploymentStatus
     */
    public final String deviceDeploymentStatusAsString() {
        return deviceDeploymentStatus;
    }

    /**
     * <p>
     * The detailed error message for the deployoment status result.
     * </p>
     * 
     * @return The detailed error message for the deployoment status result.
     */
    public final String deviceDeploymentStatusMessage() {
        return deviceDeploymentStatusMessage;
    }

    /**
     * <p>
     * The description of the device.
     * </p>
     * 
     * @return The description of the device.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time when the deployment on the device started.
     * </p>
     * 
     * @return The time when the deployment on the device started.
     */
    public final Instant deploymentStartTime() {
        return deploymentStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(edgeDeploymentPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(stageName());
        hashCode = 31 * hashCode + Objects.hashCode(deployedStageName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceFleetName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(deviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDeploymentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deviceDeploymentStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeviceDeploymentSummary)) {
            return false;
        }
        DeviceDeploymentSummary other = (DeviceDeploymentSummary) obj;
        return Objects.equals(edgeDeploymentPlanArn(), other.edgeDeploymentPlanArn())
                && Objects.equals(edgeDeploymentPlanName(), other.edgeDeploymentPlanName())
                && Objects.equals(stageName(), other.stageName())
                && Objects.equals(deployedStageName(), other.deployedStageName())
                && Objects.equals(deviceFleetName(), other.deviceFleetName()) && Objects.equals(deviceName(), other.deviceName())
                && Objects.equals(deviceArn(), other.deviceArn())
                && Objects.equals(deviceDeploymentStatusAsString(), other.deviceDeploymentStatusAsString())
                && Objects.equals(deviceDeploymentStatusMessage(), other.deviceDeploymentStatusMessage())
                && Objects.equals(description(), other.description())
                && Objects.equals(deploymentStartTime(), other.deploymentStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeviceDeploymentSummary").add("EdgeDeploymentPlanArn", edgeDeploymentPlanArn())
                .add("EdgeDeploymentPlanName", edgeDeploymentPlanName()).add("StageName", stageName())
                .add("DeployedStageName", deployedStageName()).add("DeviceFleetName", deviceFleetName())
                .add("DeviceName", deviceName()).add("DeviceArn", deviceArn())
                .add("DeviceDeploymentStatus", deviceDeploymentStatusAsString())
                .add("DeviceDeploymentStatusMessage", deviceDeploymentStatusMessage()).add("Description", description())
                .add("DeploymentStartTime", deploymentStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EdgeDeploymentPlanArn":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanArn()));
        case "EdgeDeploymentPlanName":
            return Optional.ofNullable(clazz.cast(edgeDeploymentPlanName()));
        case "StageName":
            return Optional.ofNullable(clazz.cast(stageName()));
        case "DeployedStageName":
            return Optional.ofNullable(clazz.cast(deployedStageName()));
        case "DeviceFleetName":
            return Optional.ofNullable(clazz.cast(deviceFleetName()));
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "DeviceArn":
            return Optional.ofNullable(clazz.cast(deviceArn()));
        case "DeviceDeploymentStatus":
            return Optional.ofNullable(clazz.cast(deviceDeploymentStatusAsString()));
        case "DeviceDeploymentStatusMessage":
            return Optional.ofNullable(clazz.cast(deviceDeploymentStatusMessage()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DeploymentStartTime":
            return Optional.ofNullable(clazz.cast(deploymentStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EdgeDeploymentPlanArn", EDGE_DEPLOYMENT_PLAN_ARN_FIELD);
        map.put("EdgeDeploymentPlanName", EDGE_DEPLOYMENT_PLAN_NAME_FIELD);
        map.put("StageName", STAGE_NAME_FIELD);
        map.put("DeployedStageName", DEPLOYED_STAGE_NAME_FIELD);
        map.put("DeviceFleetName", DEVICE_FLEET_NAME_FIELD);
        map.put("DeviceName", DEVICE_NAME_FIELD);
        map.put("DeviceArn", DEVICE_ARN_FIELD);
        map.put("DeviceDeploymentStatus", DEVICE_DEPLOYMENT_STATUS_FIELD);
        map.put("DeviceDeploymentStatusMessage", DEVICE_DEPLOYMENT_STATUS_MESSAGE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("DeploymentStartTime", DEPLOYMENT_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeviceDeploymentSummary, T> g) {
        return obj -> g.apply((DeviceDeploymentSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeviceDeploymentSummary> {
        /**
         * <p>
         * The ARN of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanArn
         *        The ARN of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn);

        /**
         * <p>
         * The name of the edge deployment plan.
         * </p>
         * 
         * @param edgeDeploymentPlanName
         *        The name of the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgeDeploymentPlanName(String edgeDeploymentPlanName);

        /**
         * <p>
         * The name of the stage in the edge deployment plan.
         * </p>
         * 
         * @param stageName
         *        The name of the stage in the edge deployment plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stageName(String stageName);

        /**
         * <p>
         * The name of the deployed stage.
         * </p>
         * 
         * @param deployedStageName
         *        The name of the deployed stage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployedStageName(String deployedStageName);

        /**
         * <p>
         * The name of the fleet to which the device belongs to.
         * </p>
         * 
         * @param deviceFleetName
         *        The name of the fleet to which the device belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceFleetName(String deviceFleetName);

        /**
         * <p>
         * The name of the device.
         * </p>
         * 
         * @param deviceName
         *        The name of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * The ARN of the device.
         * </p>
         * 
         * @param deviceArn
         *        The ARN of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceArn(String deviceArn);

        /**
         * <p>
         * The deployment status of the device.
         * </p>
         * 
         * @param deviceDeploymentStatus
         *        The deployment status of the device.
         * @see DeviceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDeploymentStatus
         */
        Builder deviceDeploymentStatus(String deviceDeploymentStatus);

        /**
         * <p>
         * The deployment status of the device.
         * </p>
         * 
         * @param deviceDeploymentStatus
         *        The deployment status of the device.
         * @see DeviceDeploymentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeviceDeploymentStatus
         */
        Builder deviceDeploymentStatus(DeviceDeploymentStatus deviceDeploymentStatus);

        /**
         * <p>
         * The detailed error message for the deployoment status result.
         * </p>
         * 
         * @param deviceDeploymentStatusMessage
         *        The detailed error message for the deployoment status result.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceDeploymentStatusMessage(String deviceDeploymentStatusMessage);

        /**
         * <p>
         * The description of the device.
         * </p>
         * 
         * @param description
         *        The description of the device.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time when the deployment on the device started.
         * </p>
         * 
         * @param deploymentStartTime
         *        The time when the deployment on the device started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentStartTime(Instant deploymentStartTime);
    }

    static final class BuilderImpl implements Builder {
        private String edgeDeploymentPlanArn;

        private String edgeDeploymentPlanName;

        private String stageName;

        private String deployedStageName;

        private String deviceFleetName;

        private String deviceName;

        private String deviceArn;

        private String deviceDeploymentStatus;

        private String deviceDeploymentStatusMessage;

        private String description;

        private Instant deploymentStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DeviceDeploymentSummary model) {
            edgeDeploymentPlanArn(model.edgeDeploymentPlanArn);
            edgeDeploymentPlanName(model.edgeDeploymentPlanName);
            stageName(model.stageName);
            deployedStageName(model.deployedStageName);
            deviceFleetName(model.deviceFleetName);
            deviceName(model.deviceName);
            deviceArn(model.deviceArn);
            deviceDeploymentStatus(model.deviceDeploymentStatus);
            deviceDeploymentStatusMessage(model.deviceDeploymentStatusMessage);
            description(model.description);
            deploymentStartTime(model.deploymentStartTime);
        }

        public final String getEdgeDeploymentPlanArn() {
            return edgeDeploymentPlanArn;
        }

        public final void setEdgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
        }

        @Override
        public final Builder edgeDeploymentPlanArn(String edgeDeploymentPlanArn) {
            this.edgeDeploymentPlanArn = edgeDeploymentPlanArn;
            return this;
        }

        public final String getEdgeDeploymentPlanName() {
            return edgeDeploymentPlanName;
        }

        public final void setEdgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
        }

        @Override
        public final Builder edgeDeploymentPlanName(String edgeDeploymentPlanName) {
            this.edgeDeploymentPlanName = edgeDeploymentPlanName;
            return this;
        }

        public final String getStageName() {
            return stageName;
        }

        public final void setStageName(String stageName) {
            this.stageName = stageName;
        }

        @Override
        public final Builder stageName(String stageName) {
            this.stageName = stageName;
            return this;
        }

        public final String getDeployedStageName() {
            return deployedStageName;
        }

        public final void setDeployedStageName(String deployedStageName) {
            this.deployedStageName = deployedStageName;
        }

        @Override
        public final Builder deployedStageName(String deployedStageName) {
            this.deployedStageName = deployedStageName;
            return this;
        }

        public final String getDeviceFleetName() {
            return deviceFleetName;
        }

        public final void setDeviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
        }

        @Override
        public final Builder deviceFleetName(String deviceFleetName) {
            this.deviceFleetName = deviceFleetName;
            return this;
        }

        public final String getDeviceName() {
            return deviceName;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final String getDeviceArn() {
            return deviceArn;
        }

        public final void setDeviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
        }

        @Override
        public final Builder deviceArn(String deviceArn) {
            this.deviceArn = deviceArn;
            return this;
        }

        public final String getDeviceDeploymentStatus() {
            return deviceDeploymentStatus;
        }

        public final void setDeviceDeploymentStatus(String deviceDeploymentStatus) {
            this.deviceDeploymentStatus = deviceDeploymentStatus;
        }

        @Override
        public final Builder deviceDeploymentStatus(String deviceDeploymentStatus) {
            this.deviceDeploymentStatus = deviceDeploymentStatus;
            return this;
        }

        @Override
        public final Builder deviceDeploymentStatus(DeviceDeploymentStatus deviceDeploymentStatus) {
            this.deviceDeploymentStatus(deviceDeploymentStatus == null ? null : deviceDeploymentStatus.toString());
            return this;
        }

        public final String getDeviceDeploymentStatusMessage() {
            return deviceDeploymentStatusMessage;
        }

        public final void setDeviceDeploymentStatusMessage(String deviceDeploymentStatusMessage) {
            this.deviceDeploymentStatusMessage = deviceDeploymentStatusMessage;
        }

        @Override
        public final Builder deviceDeploymentStatusMessage(String deviceDeploymentStatusMessage) {
            this.deviceDeploymentStatusMessage = deviceDeploymentStatusMessage;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getDeploymentStartTime() {
            return deploymentStartTime;
        }

        public final void setDeploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
        }

        @Override
        public final Builder deploymentStartTime(Instant deploymentStartTime) {
            this.deploymentStartTime = deploymentStartTime;
            return this;
        }

        @Override
        public DeviceDeploymentSummary build() {
            return new DeviceDeploymentSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
