/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the drift check baselines that can be used when the model monitor is set using the model package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DriftCheckBaselines implements SdkPojo, Serializable,
        ToCopyableBuilder<DriftCheckBaselines.Builder, DriftCheckBaselines> {
    private static final SdkField<DriftCheckBias> BIAS_FIELD = SdkField.<DriftCheckBias> builder(MarshallingType.SDK_POJO)
            .memberName("Bias").getter(getter(DriftCheckBaselines::bias)).setter(setter(Builder::bias))
            .constructor(DriftCheckBias::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Bias").build()).build();

    private static final SdkField<DriftCheckExplainability> EXPLAINABILITY_FIELD = SdkField
            .<DriftCheckExplainability> builder(MarshallingType.SDK_POJO).memberName("Explainability")
            .getter(getter(DriftCheckBaselines::explainability)).setter(setter(Builder::explainability))
            .constructor(DriftCheckExplainability::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Explainability").build()).build();

    private static final SdkField<DriftCheckModelQuality> MODEL_QUALITY_FIELD = SdkField
            .<DriftCheckModelQuality> builder(MarshallingType.SDK_POJO).memberName("ModelQuality")
            .getter(getter(DriftCheckBaselines::modelQuality)).setter(setter(Builder::modelQuality))
            .constructor(DriftCheckModelQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelQuality").build()).build();

    private static final SdkField<DriftCheckModelDataQuality> MODEL_DATA_QUALITY_FIELD = SdkField
            .<DriftCheckModelDataQuality> builder(MarshallingType.SDK_POJO).memberName("ModelDataQuality")
            .getter(getter(DriftCheckBaselines::modelDataQuality)).setter(setter(Builder::modelDataQuality))
            .constructor(DriftCheckModelDataQuality::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelDataQuality").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BIAS_FIELD,
            EXPLAINABILITY_FIELD, MODEL_QUALITY_FIELD, MODEL_DATA_QUALITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DriftCheckBias bias;

    private final DriftCheckExplainability explainability;

    private final DriftCheckModelQuality modelQuality;

    private final DriftCheckModelDataQuality modelDataQuality;

    private DriftCheckBaselines(BuilderImpl builder) {
        this.bias = builder.bias;
        this.explainability = builder.explainability;
        this.modelQuality = builder.modelQuality;
        this.modelDataQuality = builder.modelDataQuality;
    }

    /**
     * <p>
     * Represents the drift check bias baselines that can be used when the model monitor is set using the model package.
     * </p>
     * 
     * @return Represents the drift check bias baselines that can be used when the model monitor is set using the model
     *         package.
     */
    public final DriftCheckBias bias() {
        return bias;
    }

    /**
     * <p>
     * Represents the drift check explainability baselines that can be used when the model monitor is set using the
     * model package.
     * </p>
     * 
     * @return Represents the drift check explainability baselines that can be used when the model monitor is set using
     *         the model package.
     */
    public final DriftCheckExplainability explainability() {
        return explainability;
    }

    /**
     * <p>
     * Represents the drift check model quality baselines that can be used when the model monitor is set using the model
     * package.
     * </p>
     * 
     * @return Represents the drift check model quality baselines that can be used when the model monitor is set using
     *         the model package.
     */
    public final DriftCheckModelQuality modelQuality() {
        return modelQuality;
    }

    /**
     * <p>
     * Represents the drift check model data quality baselines that can be used when the model monitor is set using the
     * model package.
     * </p>
     * 
     * @return Represents the drift check model data quality baselines that can be used when the model monitor is set
     *         using the model package.
     */
    public final DriftCheckModelDataQuality modelDataQuality() {
        return modelDataQuality;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(bias());
        hashCode = 31 * hashCode + Objects.hashCode(explainability());
        hashCode = 31 * hashCode + Objects.hashCode(modelQuality());
        hashCode = 31 * hashCode + Objects.hashCode(modelDataQuality());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DriftCheckBaselines)) {
            return false;
        }
        DriftCheckBaselines other = (DriftCheckBaselines) obj;
        return Objects.equals(bias(), other.bias()) && Objects.equals(explainability(), other.explainability())
                && Objects.equals(modelQuality(), other.modelQuality())
                && Objects.equals(modelDataQuality(), other.modelDataQuality());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DriftCheckBaselines").add("Bias", bias()).add("Explainability", explainability())
                .add("ModelQuality", modelQuality()).add("ModelDataQuality", modelDataQuality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Bias":
            return Optional.ofNullable(clazz.cast(bias()));
        case "Explainability":
            return Optional.ofNullable(clazz.cast(explainability()));
        case "ModelQuality":
            return Optional.ofNullable(clazz.cast(modelQuality()));
        case "ModelDataQuality":
            return Optional.ofNullable(clazz.cast(modelDataQuality()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Bias", BIAS_FIELD);
        map.put("Explainability", EXPLAINABILITY_FIELD);
        map.put("ModelQuality", MODEL_QUALITY_FIELD);
        map.put("ModelDataQuality", MODEL_DATA_QUALITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DriftCheckBaselines, T> g) {
        return obj -> g.apply((DriftCheckBaselines) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DriftCheckBaselines> {
        /**
         * <p>
         * Represents the drift check bias baselines that can be used when the model monitor is set using the model
         * package.
         * </p>
         * 
         * @param bias
         *        Represents the drift check bias baselines that can be used when the model monitor is set using the
         *        model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bias(DriftCheckBias bias);

        /**
         * <p>
         * Represents the drift check bias baselines that can be used when the model monitor is set using the model
         * package.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftCheckBias.Builder} avoiding the need
         * to create one manually via {@link DriftCheckBias#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftCheckBias.Builder#build()} is called immediately and its
         * result is passed to {@link #bias(DriftCheckBias)}.
         * 
         * @param bias
         *        a consumer that will call methods on {@link DriftCheckBias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #bias(DriftCheckBias)
         */
        default Builder bias(Consumer<DriftCheckBias.Builder> bias) {
            return bias(DriftCheckBias.builder().applyMutation(bias).build());
        }

        /**
         * <p>
         * Represents the drift check explainability baselines that can be used when the model monitor is set using the
         * model package.
         * </p>
         * 
         * @param explainability
         *        Represents the drift check explainability baselines that can be used when the model monitor is set
         *        using the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder explainability(DriftCheckExplainability explainability);

        /**
         * <p>
         * Represents the drift check explainability baselines that can be used when the model monitor is set using the
         * model package.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftCheckExplainability.Builder}
         * avoiding the need to create one manually via {@link DriftCheckExplainability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftCheckExplainability.Builder#build()} is called immediately
         * and its result is passed to {@link #explainability(DriftCheckExplainability)}.
         * 
         * @param explainability
         *        a consumer that will call methods on {@link DriftCheckExplainability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #explainability(DriftCheckExplainability)
         */
        default Builder explainability(Consumer<DriftCheckExplainability.Builder> explainability) {
            return explainability(DriftCheckExplainability.builder().applyMutation(explainability).build());
        }

        /**
         * <p>
         * Represents the drift check model quality baselines that can be used when the model monitor is set using the
         * model package.
         * </p>
         * 
         * @param modelQuality
         *        Represents the drift check model quality baselines that can be used when the model monitor is set
         *        using the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelQuality(DriftCheckModelQuality modelQuality);

        /**
         * <p>
         * Represents the drift check model quality baselines that can be used when the model monitor is set using the
         * model package.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftCheckModelQuality.Builder} avoiding
         * the need to create one manually via {@link DriftCheckModelQuality#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftCheckModelQuality.Builder#build()} is called immediately and
         * its result is passed to {@link #modelQuality(DriftCheckModelQuality)}.
         * 
         * @param modelQuality
         *        a consumer that will call methods on {@link DriftCheckModelQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelQuality(DriftCheckModelQuality)
         */
        default Builder modelQuality(Consumer<DriftCheckModelQuality.Builder> modelQuality) {
            return modelQuality(DriftCheckModelQuality.builder().applyMutation(modelQuality).build());
        }

        /**
         * <p>
         * Represents the drift check model data quality baselines that can be used when the model monitor is set using
         * the model package.
         * </p>
         * 
         * @param modelDataQuality
         *        Represents the drift check model data quality baselines that can be used when the model monitor is set
         *        using the model package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelDataQuality(DriftCheckModelDataQuality modelDataQuality);

        /**
         * <p>
         * Represents the drift check model data quality baselines that can be used when the model monitor is set using
         * the model package.
         * </p>
         * This is a convenience method that creates an instance of the {@link DriftCheckModelDataQuality.Builder}
         * avoiding the need to create one manually via {@link DriftCheckModelDataQuality#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DriftCheckModelDataQuality.Builder#build()} is called immediately
         * and its result is passed to {@link #modelDataQuality(DriftCheckModelDataQuality)}.
         * 
         * @param modelDataQuality
         *        a consumer that will call methods on {@link DriftCheckModelDataQuality.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelDataQuality(DriftCheckModelDataQuality)
         */
        default Builder modelDataQuality(Consumer<DriftCheckModelDataQuality.Builder> modelDataQuality) {
            return modelDataQuality(DriftCheckModelDataQuality.builder().applyMutation(modelDataQuality).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DriftCheckBias bias;

        private DriftCheckExplainability explainability;

        private DriftCheckModelQuality modelQuality;

        private DriftCheckModelDataQuality modelDataQuality;

        private BuilderImpl() {
        }

        private BuilderImpl(DriftCheckBaselines model) {
            bias(model.bias);
            explainability(model.explainability);
            modelQuality(model.modelQuality);
            modelDataQuality(model.modelDataQuality);
        }

        public final DriftCheckBias.Builder getBias() {
            return bias != null ? bias.toBuilder() : null;
        }

        public final void setBias(DriftCheckBias.BuilderImpl bias) {
            this.bias = bias != null ? bias.build() : null;
        }

        @Override
        public final Builder bias(DriftCheckBias bias) {
            this.bias = bias;
            return this;
        }

        public final DriftCheckExplainability.Builder getExplainability() {
            return explainability != null ? explainability.toBuilder() : null;
        }

        public final void setExplainability(DriftCheckExplainability.BuilderImpl explainability) {
            this.explainability = explainability != null ? explainability.build() : null;
        }

        @Override
        public final Builder explainability(DriftCheckExplainability explainability) {
            this.explainability = explainability;
            return this;
        }

        public final DriftCheckModelQuality.Builder getModelQuality() {
            return modelQuality != null ? modelQuality.toBuilder() : null;
        }

        public final void setModelQuality(DriftCheckModelQuality.BuilderImpl modelQuality) {
            this.modelQuality = modelQuality != null ? modelQuality.build() : null;
        }

        @Override
        public final Builder modelQuality(DriftCheckModelQuality modelQuality) {
            this.modelQuality = modelQuality;
            return this;
        }

        public final DriftCheckModelDataQuality.Builder getModelDataQuality() {
            return modelDataQuality != null ? modelDataQuality.toBuilder() : null;
        }

        public final void setModelDataQuality(DriftCheckModelDataQuality.BuilderImpl modelDataQuality) {
            this.modelDataQuality = modelDataQuality != null ? modelDataQuality.build() : null;
        }

        @Override
        public final Builder modelDataQuality(DriftCheckModelDataQuality modelDataQuality) {
            this.modelDataQuality = modelDataQuality;
            return this;
        }

        @Override
        public DriftCheckBaselines build() {
            return new DriftCheckBaselines(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
