/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object with the recommended values for you to specify when creating an autoscaling policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DynamicScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<DynamicScalingConfiguration.Builder, DynamicScalingConfiguration> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinCapacity").getter(getter(DynamicScalingConfiguration::minCapacity))
            .setter(setter(Builder::minCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()).build();

    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxCapacity").getter(getter(DynamicScalingConfiguration::maxCapacity))
            .setter(setter(Builder::maxCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()).build();

    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScaleInCooldown").getter(getter(DynamicScalingConfiguration::scaleInCooldown))
            .setter(setter(Builder::scaleInCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()).build();

    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScaleOutCooldown").getter(getter(DynamicScalingConfiguration::scaleOutCooldown))
            .setter(setter(Builder::scaleOutCooldown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()).build();

    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField
            .<List<ScalingPolicy>> builder(MarshallingType.LIST)
            .memberName("ScalingPolicies")
            .getter(getter(DynamicScalingConfiguration::scalingPolicies))
            .setter(setter(Builder::scalingPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ScalingPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScalingPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD,
            MAX_CAPACITY_FIELD, SCALE_IN_COOLDOWN_FIELD, SCALE_OUT_COOLDOWN_FIELD, SCALING_POLICIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minCapacity;

    private final Integer maxCapacity;

    private final Integer scaleInCooldown;

    private final Integer scaleOutCooldown;

    private final List<ScalingPolicy> scalingPolicies;

    private DynamicScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scalingPolicies = builder.scalingPolicies;
    }

    /**
     * <p>
     * The recommended minimum capacity to specify for your autoscaling policy.
     * </p>
     * 
     * @return The recommended minimum capacity to specify for your autoscaling policy.
     */
    public final Integer minCapacity() {
        return minCapacity;
    }

    /**
     * <p>
     * The recommended maximum capacity to specify for your autoscaling policy.
     * </p>
     * 
     * @return The recommended maximum capacity to specify for your autoscaling policy.
     */
    public final Integer maxCapacity() {
        return maxCapacity;
    }

    /**
     * <p>
     * The recommended scale in cooldown time for your autoscaling policy.
     * </p>
     * 
     * @return The recommended scale in cooldown time for your autoscaling policy.
     */
    public final Integer scaleInCooldown() {
        return scaleInCooldown;
    }

    /**
     * <p>
     * The recommended scale out cooldown time for your autoscaling policy.
     * </p>
     * 
     * @return The recommended scale out cooldown time for your autoscaling policy.
     */
    public final Integer scaleOutCooldown() {
        return scaleOutCooldown;
    }

    /**
     * For responses, this returns true if the service returned a value for the ScalingPolicies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasScalingPolicies() {
        return scalingPolicies != null && !(scalingPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An object of the scaling policies for each metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasScalingPolicies} method.
     * </p>
     * 
     * @return An object of the scaling policies for each metric.
     */
    public final List<ScalingPolicy> scalingPolicies() {
        return scalingPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(hasScalingPolicies() ? scalingPolicies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicScalingConfiguration)) {
            return false;
        }
        DynamicScalingConfiguration other = (DynamicScalingConfiguration) obj;
        return Objects.equals(minCapacity(), other.minCapacity()) && Objects.equals(maxCapacity(), other.maxCapacity())
                && Objects.equals(scaleInCooldown(), other.scaleInCooldown())
                && Objects.equals(scaleOutCooldown(), other.scaleOutCooldown())
                && hasScalingPolicies() == other.hasScalingPolicies()
                && Objects.equals(scalingPolicies(), other.scalingPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DynamicScalingConfiguration").add("MinCapacity", minCapacity())
                .add("MaxCapacity", maxCapacity()).add("ScaleInCooldown", scaleInCooldown())
                .add("ScaleOutCooldown", scaleOutCooldown())
                .add("ScalingPolicies", hasScalingPolicies() ? scalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MinCapacity":
            return Optional.ofNullable(clazz.cast(minCapacity()));
        case "MaxCapacity":
            return Optional.ofNullable(clazz.cast(maxCapacity()));
        case "ScaleInCooldown":
            return Optional.ofNullable(clazz.cast(scaleInCooldown()));
        case "ScaleOutCooldown":
            return Optional.ofNullable(clazz.cast(scaleOutCooldown()));
        case "ScalingPolicies":
            return Optional.ofNullable(clazz.cast(scalingPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MinCapacity", MIN_CAPACITY_FIELD);
        map.put("MaxCapacity", MAX_CAPACITY_FIELD);
        map.put("ScaleInCooldown", SCALE_IN_COOLDOWN_FIELD);
        map.put("ScaleOutCooldown", SCALE_OUT_COOLDOWN_FIELD);
        map.put("ScalingPolicies", SCALING_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DynamicScalingConfiguration, T> g) {
        return obj -> g.apply((DynamicScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DynamicScalingConfiguration> {
        /**
         * <p>
         * The recommended minimum capacity to specify for your autoscaling policy.
         * </p>
         * 
         * @param minCapacity
         *        The recommended minimum capacity to specify for your autoscaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minCapacity(Integer minCapacity);

        /**
         * <p>
         * The recommended maximum capacity to specify for your autoscaling policy.
         * </p>
         * 
         * @param maxCapacity
         *        The recommended maximum capacity to specify for your autoscaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCapacity(Integer maxCapacity);

        /**
         * <p>
         * The recommended scale in cooldown time for your autoscaling policy.
         * </p>
         * 
         * @param scaleInCooldown
         *        The recommended scale in cooldown time for your autoscaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleInCooldown(Integer scaleInCooldown);

        /**
         * <p>
         * The recommended scale out cooldown time for your autoscaling policy.
         * </p>
         * 
         * @param scaleOutCooldown
         *        The recommended scale out cooldown time for your autoscaling policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scaleOutCooldown(Integer scaleOutCooldown);

        /**
         * <p>
         * An object of the scaling policies for each metric.
         * </p>
         * 
         * @param scalingPolicies
         *        An object of the scaling policies for each metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies);

        /**
         * <p>
         * An object of the scaling policies for each metric.
         * </p>
         * 
         * @param scalingPolicies
         *        An object of the scaling policies for each metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scalingPolicies(ScalingPolicy... scalingPolicies);

        /**
         * <p>
         * An object of the scaling policies for each metric.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ScalingPolicy.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.ScalingPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ScalingPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #scalingPolicies(List<ScalingPolicy>)}.
         * 
         * @param scalingPolicies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ScalingPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scalingPolicies(java.util.Collection<ScalingPolicy>)
         */
        Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies);
    }

    static final class BuilderImpl implements Builder {
        private Integer minCapacity;

        private Integer maxCapacity;

        private Integer scaleInCooldown;

        private Integer scaleOutCooldown;

        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicScalingConfiguration model) {
            minCapacity(model.minCapacity);
            maxCapacity(model.maxCapacity);
            scaleInCooldown(model.scaleInCooldown);
            scaleOutCooldown(model.scaleOutCooldown);
            scalingPolicies(model.scalingPolicies);
        }

        public final Integer getMinCapacity() {
            return minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getScaleInCooldown() {
            return scaleInCooldown;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final Integer getScaleOutCooldown() {
            return scaleOutCooldown;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final List<ScalingPolicy.Builder> getScalingPolicies() {
            List<ScalingPolicy.Builder> result = ScalingPoliciesCopier.copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy... scalingPolicies) {
            scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder>... scalingPolicies) {
            scalingPolicies(Stream.of(scalingPolicies).map(c -> ScalingPolicy.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DynamicScalingConfiguration build() {
            return new DynamicScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
