/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of a model in a deployment.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EdgeDeploymentModelConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<EdgeDeploymentModelConfig.Builder, EdgeDeploymentModelConfig> {
    private static final SdkField<String> MODEL_HANDLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelHandle").getter(getter(EdgeDeploymentModelConfig::modelHandle))
            .setter(setter(Builder::modelHandle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelHandle").build()).build();

    private static final SdkField<String> EDGE_PACKAGING_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EdgePackagingJobName").getter(getter(EdgeDeploymentModelConfig::edgePackagingJobName))
            .setter(setter(Builder::edgePackagingJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgePackagingJobName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_HANDLE_FIELD,
            EDGE_PACKAGING_JOB_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelHandle;

    private final String edgePackagingJobName;

    private EdgeDeploymentModelConfig(BuilderImpl builder) {
        this.modelHandle = builder.modelHandle;
        this.edgePackagingJobName = builder.edgePackagingJobName;
    }

    /**
     * <p>
     * The name the device application uses to reference this model.
     * </p>
     * 
     * @return The name the device application uses to reference this model.
     */
    public final String modelHandle() {
        return modelHandle;
    }

    /**
     * <p>
     * The edge packaging job associated with this deployment.
     * </p>
     * 
     * @return The edge packaging job associated with this deployment.
     */
    public final String edgePackagingJobName() {
        return edgePackagingJobName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelHandle());
        hashCode = 31 * hashCode + Objects.hashCode(edgePackagingJobName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EdgeDeploymentModelConfig)) {
            return false;
        }
        EdgeDeploymentModelConfig other = (EdgeDeploymentModelConfig) obj;
        return Objects.equals(modelHandle(), other.modelHandle())
                && Objects.equals(edgePackagingJobName(), other.edgePackagingJobName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EdgeDeploymentModelConfig").add("ModelHandle", modelHandle())
                .add("EdgePackagingJobName", edgePackagingJobName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelHandle":
            return Optional.ofNullable(clazz.cast(modelHandle()));
        case "EdgePackagingJobName":
            return Optional.ofNullable(clazz.cast(edgePackagingJobName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelHandle", MODEL_HANDLE_FIELD);
        map.put("EdgePackagingJobName", EDGE_PACKAGING_JOB_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EdgeDeploymentModelConfig, T> g) {
        return obj -> g.apply((EdgeDeploymentModelConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EdgeDeploymentModelConfig> {
        /**
         * <p>
         * The name the device application uses to reference this model.
         * </p>
         * 
         * @param modelHandle
         *        The name the device application uses to reference this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelHandle(String modelHandle);

        /**
         * <p>
         * The edge packaging job associated with this deployment.
         * </p>
         * 
         * @param edgePackagingJobName
         *        The edge packaging job associated with this deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder edgePackagingJobName(String edgePackagingJobName);
    }

    static final class BuilderImpl implements Builder {
        private String modelHandle;

        private String edgePackagingJobName;

        private BuilderImpl() {
        }

        private BuilderImpl(EdgeDeploymentModelConfig model) {
            modelHandle(model.modelHandle);
            edgePackagingJobName(model.edgePackagingJobName);
        }

        public final String getModelHandle() {
            return modelHandle;
        }

        public final void setModelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
        }

        @Override
        public final Builder modelHandle(String modelHandle) {
            this.modelHandle = modelHandle;
            return this;
        }

        public final String getEdgePackagingJobName() {
            return edgePackagingJobName;
        }

        public final void setEdgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
        }

        @Override
        public final Builder edgePackagingJobName(String edgePackagingJobName) {
            this.edgePackagingJobName = edgePackagingJobName;
            return this;
        }

        @Override
        public EdgeDeploymentModelConfig build() {
            return new EdgeDeploymentModelConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
