/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The performance results from running an Inference Recommender job on an existing endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EndpointPerformance implements SdkPojo, Serializable,
        ToCopyableBuilder<EndpointPerformance.Builder, EndpointPerformance> {
    private static final SdkField<InferenceMetrics> METRICS_FIELD = SdkField.<InferenceMetrics> builder(MarshallingType.SDK_POJO)
            .memberName("Metrics").getter(getter(EndpointPerformance::metrics)).setter(setter(Builder::metrics))
            .constructor(InferenceMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()).build();

    private static final SdkField<EndpointInfo> ENDPOINT_INFO_FIELD = SdkField.<EndpointInfo> builder(MarshallingType.SDK_POJO)
            .memberName("EndpointInfo").getter(getter(EndpointPerformance::endpointInfo)).setter(setter(Builder::endpointInfo))
            .constructor(EndpointInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD,
            ENDPOINT_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InferenceMetrics metrics;

    private final EndpointInfo endpointInfo;

    private EndpointPerformance(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.endpointInfo = builder.endpointInfo;
    }

    /**
     * <p>
     * The metrics for an existing endpoint.
     * </p>
     * 
     * @return The metrics for an existing endpoint.
     */
    public final InferenceMetrics metrics() {
        return metrics;
    }

    /**
     * Returns the value of the EndpointInfo property for this object.
     * 
     * @return The value of the EndpointInfo property for this object.
     */
    public final EndpointInfo endpointInfo() {
        return endpointInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metrics());
        hashCode = 31 * hashCode + Objects.hashCode(endpointInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EndpointPerformance)) {
            return false;
        }
        EndpointPerformance other = (EndpointPerformance) obj;
        return Objects.equals(metrics(), other.metrics()) && Objects.equals(endpointInfo(), other.endpointInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EndpointPerformance").add("Metrics", metrics()).add("EndpointInfo", endpointInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metrics":
            return Optional.ofNullable(clazz.cast(metrics()));
        case "EndpointInfo":
            return Optional.ofNullable(clazz.cast(endpointInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Metrics", METRICS_FIELD);
        map.put("EndpointInfo", ENDPOINT_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EndpointPerformance, T> g) {
        return obj -> g.apply((EndpointPerformance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EndpointPerformance> {
        /**
         * <p>
         * The metrics for an existing endpoint.
         * </p>
         * 
         * @param metrics
         *        The metrics for an existing endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metrics(InferenceMetrics metrics);

        /**
         * <p>
         * The metrics for an existing endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link InferenceMetrics.Builder} avoiding the
         * need to create one manually via {@link InferenceMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #metrics(InferenceMetrics)}.
         * 
         * @param metrics
         *        a consumer that will call methods on {@link InferenceMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metrics(InferenceMetrics)
         */
        default Builder metrics(Consumer<InferenceMetrics.Builder> metrics) {
            return metrics(InferenceMetrics.builder().applyMutation(metrics).build());
        }

        /**
         * Sets the value of the EndpointInfo property for this object.
         *
         * @param endpointInfo
         *        The new value for the EndpointInfo property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointInfo(EndpointInfo endpointInfo);

        /**
         * Sets the value of the EndpointInfo property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EndpointInfo.Builder} avoiding the need
         * to create one manually via {@link EndpointInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EndpointInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #endpointInfo(EndpointInfo)}.
         * 
         * @param endpointInfo
         *        a consumer that will call methods on {@link EndpointInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpointInfo(EndpointInfo)
         */
        default Builder endpointInfo(Consumer<EndpointInfo.Builder> endpointInfo) {
            return endpointInfo(EndpointInfo.builder().applyMutation(endpointInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private InferenceMetrics metrics;

        private EndpointInfo endpointInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(EndpointPerformance model) {
            metrics(model.metrics);
            endpointInfo(model.endpointInfo);
        }

        public final InferenceMetrics.Builder getMetrics() {
            return metrics != null ? metrics.toBuilder() : null;
        }

        public final void setMetrics(InferenceMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(InferenceMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointInfo.Builder getEndpointInfo() {
            return endpointInfo != null ? endpointInfo.toBuilder() : null;
        }

        public final void setEndpointInfo(EndpointInfo.BuilderImpl endpointInfo) {
            this.endpointInfo = endpointInfo != null ? endpointInfo.build() : null;
        }

        @Override
        public final Builder endpointInfo(EndpointInfo endpointInfo) {
            this.endpointInfo = endpointInfo;
            return this;
        }

        @Override
        public EndpointPerformance build() {
            return new EndpointPerformance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
