/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter to activate explainers.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExplainerConfig implements SdkPojo, Serializable, ToCopyableBuilder<ExplainerConfig.Builder, ExplainerConfig> {
    private static final SdkField<ClarifyExplainerConfig> CLARIFY_EXPLAINER_CONFIG_FIELD = SdkField
            .<ClarifyExplainerConfig> builder(MarshallingType.SDK_POJO).memberName("ClarifyExplainerConfig")
            .getter(getter(ExplainerConfig::clarifyExplainerConfig)).setter(setter(Builder::clarifyExplainerConfig))
            .constructor(ClarifyExplainerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClarifyExplainerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLARIFY_EXPLAINER_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ClarifyExplainerConfig clarifyExplainerConfig;

    private ExplainerConfig(BuilderImpl builder) {
        this.clarifyExplainerConfig = builder.clarifyExplainerConfig;
    }

    /**
     * <p>
     * A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify
     * explainer.
     * </p>
     * 
     * @return A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify
     *         explainer.
     */
    public final ClarifyExplainerConfig clarifyExplainerConfig() {
        return clarifyExplainerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(clarifyExplainerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExplainerConfig)) {
            return false;
        }
        ExplainerConfig other = (ExplainerConfig) obj;
        return Objects.equals(clarifyExplainerConfig(), other.clarifyExplainerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExplainerConfig").add("ClarifyExplainerConfig", clarifyExplainerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClarifyExplainerConfig":
            return Optional.ofNullable(clazz.cast(clarifyExplainerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClarifyExplainerConfig", CLARIFY_EXPLAINER_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExplainerConfig, T> g) {
        return obj -> g.apply((ExplainerConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExplainerConfig> {
        /**
         * <p>
         * A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify
         * explainer.
         * </p>
         * 
         * @param clarifyExplainerConfig
         *        A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker
         *        Clarify explainer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clarifyExplainerConfig(ClarifyExplainerConfig clarifyExplainerConfig);

        /**
         * <p>
         * A member of <code>ExplainerConfig</code> that contains configuration parameters for the SageMaker Clarify
         * explainer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ClarifyExplainerConfig.Builder} avoiding
         * the need to create one manually via {@link ClarifyExplainerConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ClarifyExplainerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #clarifyExplainerConfig(ClarifyExplainerConfig)}.
         * 
         * @param clarifyExplainerConfig
         *        a consumer that will call methods on {@link ClarifyExplainerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clarifyExplainerConfig(ClarifyExplainerConfig)
         */
        default Builder clarifyExplainerConfig(Consumer<ClarifyExplainerConfig.Builder> clarifyExplainerConfig) {
            return clarifyExplainerConfig(ClarifyExplainerConfig.builder().applyMutation(clarifyExplainerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ClarifyExplainerConfig clarifyExplainerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ExplainerConfig model) {
            clarifyExplainerConfig(model.clarifyExplainerConfig);
        }

        public final ClarifyExplainerConfig.Builder getClarifyExplainerConfig() {
            return clarifyExplainerConfig != null ? clarifyExplainerConfig.toBuilder() : null;
        }

        public final void setClarifyExplainerConfig(ClarifyExplainerConfig.BuilderImpl clarifyExplainerConfig) {
            this.clarifyExplainerConfig = clarifyExplainerConfig != null ? clarifyExplainerConfig.build() : null;
        }

        @Override
        public final Builder clarifyExplainerConfig(ClarifyExplainerConfig clarifyExplainerConfig) {
            this.clarifyExplainerConfig = clarifyExplainerConfig;
            return this;
        }

        @Override
        public ExplainerConfig build() {
            return new ExplainerConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
