/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The generative AI settings for the SageMaker Canvas application.
 * </p>
 * <p>
 * Configure these settings for Canvas users starting chats with generative AI foundation models. For more information,
 * see <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/canvas-fm-chat.html"> Use generative AI with foundation
 * models</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerativeAiSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<GenerativeAiSettings.Builder, GenerativeAiSettings> {
    private static final SdkField<String> AMAZON_BEDROCK_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AmazonBedrockRoleArn").getter(getter(GenerativeAiSettings::amazonBedrockRoleArn))
            .setter(setter(Builder::amazonBedrockRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmazonBedrockRoleArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(AMAZON_BEDROCK_ROLE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amazonBedrockRoleArn;

    private GenerativeAiSettings(BuilderImpl builder) {
        this.amazonBedrockRoleArn = builder.amazonBedrockRoleArn;
    }

    /**
     * <p>
     * The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in Amazon
     * Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust relationship that
     * establishes <code>bedrock.amazonaws.com</code> as a service principal.
     * </p>
     * 
     * @return The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in
     *         Amazon Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust
     *         relationship that establishes <code>bedrock.amazonaws.com</code> as a service principal.
     */
    public final String amazonBedrockRoleArn() {
        return amazonBedrockRoleArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amazonBedrockRoleArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerativeAiSettings)) {
            return false;
        }
        GenerativeAiSettings other = (GenerativeAiSettings) obj;
        return Objects.equals(amazonBedrockRoleArn(), other.amazonBedrockRoleArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerativeAiSettings").add("AmazonBedrockRoleArn", amazonBedrockRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AmazonBedrockRoleArn":
            return Optional.ofNullable(clazz.cast(amazonBedrockRoleArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AmazonBedrockRoleArn", AMAZON_BEDROCK_ROLE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GenerativeAiSettings, T> g) {
        return obj -> g.apply((GenerativeAiSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GenerativeAiSettings> {
        /**
         * <p>
         * The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in Amazon
         * Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust relationship that
         * establishes <code>bedrock.amazonaws.com</code> as a service principal.
         * </p>
         * 
         * @param amazonBedrockRoleArn
         *        The ARN of an Amazon Web Services IAM role that allows fine-tuning of large language models (LLMs) in
         *        Amazon Bedrock. The IAM role should have Amazon S3 read and write permissions, as well as a trust
         *        relationship that establishes <code>bedrock.amazonaws.com</code> as a service principal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amazonBedrockRoleArn(String amazonBedrockRoleArn);
    }

    static final class BuilderImpl implements Builder {
        private String amazonBedrockRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(GenerativeAiSettings model) {
            amazonBedrockRoleArn(model.amazonBedrockRoleArn);
        }

        public final String getAmazonBedrockRoleArn() {
            return amazonBedrockRoleArn;
        }

        public final void setAmazonBedrockRoleArn(String amazonBedrockRoleArn) {
            this.amazonBedrockRoleArn = amazonBedrockRoleArn;
        }

        @Override
        public final Builder amazonBedrockRoleArn(String amazonBedrockRoleArn) {
            this.amazonBedrockRoleArn = amazonBedrockRoleArn;
            return this;
        }

        @Override
        public GenerativeAiSettings build() {
            return new GenerativeAiSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
