/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use this parameter to specify a supported global condition key that is added to the IAM policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamPolicyConstraints implements SdkPojo, Serializable,
        ToCopyableBuilder<IamPolicyConstraints.Builder, IamPolicyConstraints> {
    private static final SdkField<String> SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceIp").getter(getter(IamPolicyConstraints::sourceIpAsString)).setter(setter(Builder::sourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceIp").build()).build();

    private static final SdkField<String> VPC_SOURCE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VpcSourceIp").getter(getter(IamPolicyConstraints::vpcSourceIpAsString))
            .setter(setter(Builder::vpcSourceIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSourceIp").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IP_FIELD,
            VPC_SOURCE_IP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceIp;

    private final String vpcSourceIp;

    private IamPolicyConstraints(BuilderImpl builder) {
        this.sourceIp = builder.sourceIp;
        this.vpcSourceIp = builder.vpcSourceIp;
    }

    /**
     * <p>
     * When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the worker
     * portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned URL. This
     * IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the
     * worker portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceIp} will
     * return {@link EnabledOrDisabled#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceIpAsString}.
     * </p>
     * 
     * @return When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the
     *         worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3
     *         presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource
     *         to be rendered in the worker portal.
     * @see EnabledOrDisabled
     */
    public final EnabledOrDisabled sourceIp() {
        return EnabledOrDisabled.fromValue(sourceIp);
    }

    /**
     * <p>
     * When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the worker
     * portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned URL. This
     * IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be rendered in the
     * worker portal.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourceIp} will
     * return {@link EnabledOrDisabled#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceIpAsString}.
     * </p>
     * 
     * @return When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the
     *         worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3
     *         presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource
     *         to be rendered in the worker portal.
     * @see EnabledOrDisabled
     */
    public final String sourceIpAsString() {
        return sourceIp;
    }

    /**
     * <p>
     * When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in private
     * worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to generate the Amazon
     * S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over
     * an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM policy. To learn
     * more about configuring private worker portal, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode from a
     * private worker portal</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcSourceIp} will
     * return {@link EnabledOrDisabled#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcSourceIpAsString}.
     * </p>
     * 
     * @return When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
     *         private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to
     *         generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned
     *         URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP
     *         address in the IAM policy. To learn more about configuring private worker portal, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode
     *         from a private worker portal</a>.
     * @see EnabledOrDisabled
     */
    public final EnabledOrDisabled vpcSourceIp() {
        return EnabledOrDisabled.fromValue(vpcSourceIp);
    }

    /**
     * <p>
     * When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in private
     * worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to generate the Amazon
     * S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being accessed over
     * an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM policy. To learn
     * more about configuring private worker portal, see <a
     * href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode from a
     * private worker portal</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vpcSourceIp} will
     * return {@link EnabledOrDisabled#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vpcSourceIpAsString}.
     * </p>
     * 
     * @return When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
     *         private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to
     *         generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned
     *         URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP
     *         address in the IAM policy. To learn more about configuring private worker portal, see <a
     *         href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode
     *         from a private worker portal</a>.
     * @see EnabledOrDisabled
     */
    public final String vpcSourceIpAsString() {
        return vpcSourceIp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceIpAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcSourceIpAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamPolicyConstraints)) {
            return false;
        }
        IamPolicyConstraints other = (IamPolicyConstraints) obj;
        return Objects.equals(sourceIpAsString(), other.sourceIpAsString())
                && Objects.equals(vpcSourceIpAsString(), other.vpcSourceIpAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamPolicyConstraints").add("SourceIp", sourceIpAsString())
                .add("VpcSourceIp", vpcSourceIpAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceIp":
            return Optional.ofNullable(clazz.cast(sourceIpAsString()));
        case "VpcSourceIp":
            return Optional.ofNullable(clazz.cast(vpcSourceIpAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SourceIp", SOURCE_IP_FIELD);
        map.put("VpcSourceIp", VPC_SOURCE_IP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamPolicyConstraints, T> g) {
        return obj -> g.apply((IamPolicyConstraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamPolicyConstraints> {
        /**
         * <p>
         * When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the
         * worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned
         * URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be
         * rendered in the worker portal.
         * </p>
         * 
         * @param sourceIp
         *        When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
         *        the worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon
         *        S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3
         *        resource to be rendered in the worker portal.
         * @see EnabledOrDisabled
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledOrDisabled
         */
        Builder sourceIp(String sourceIp);

        /**
         * <p>
         * When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in the
         * worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon S3 presigned
         * URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3 resource to be
         * rendered in the worker portal.
         * </p>
         * 
         * @param sourceIp
         *        When <code>SourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
         *        the worker portal is added to the IAM policy as a <code>Condition</code> used to generate the Amazon
         *        S3 presigned URL. This IP address is checked by Amazon S3 and must match in order for the Amazon S3
         *        resource to be rendered in the worker portal.
         * @see EnabledOrDisabled
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledOrDisabled
         */
        Builder sourceIp(EnabledOrDisabled sourceIp);

        /**
         * <p>
         * When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
         * private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to generate
         * the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being
         * accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM
         * policy. To learn more about configuring private worker portal, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode
         * from a private worker portal</a>.
         * </p>
         * 
         * @param vpcSourceIp
         *        When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered
         *        in private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to
         *        generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the
         *        presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address
         *        matches the IP address in the IAM policy. To learn more about configuring private worker portal, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon
         *        VPC mode from a private worker portal</a>.
         * @see EnabledOrDisabled
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledOrDisabled
         */
        Builder vpcSourceIp(String vpcSourceIp);

        /**
         * <p>
         * When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered in
         * private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to generate
         * the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the presigned URL is being
         * accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address matches the IP address in the IAM
         * policy. To learn more about configuring private worker portal, see <a
         * href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon VPC mode
         * from a private worker portal</a>.
         * </p>
         * 
         * @param vpcSourceIp
         *        When <code>VpcSourceIp</code> is <code>Enabled</code> the worker's IP address when a task is rendered
         *        in private worker portal inside the VPC is added to the IAM policy as a <code>Condition</code> used to
         *        generate the Amazon S3 presigned URL. To render the task successfully Amazon S3 checks that the
         *        presigned URL is being accessed over an Amazon S3 VPC Endpoint, and that the worker's IP address
         *        matches the IP address in the IAM policy. To learn more about configuring private worker portal, see
         *        <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/samurai-vpc-worker-portal.html">Use Amazon
         *        VPC mode from a private worker portal</a>.
         * @see EnabledOrDisabled
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnabledOrDisabled
         */
        Builder vpcSourceIp(EnabledOrDisabled vpcSourceIp);
    }

    static final class BuilderImpl implements Builder {
        private String sourceIp;

        private String vpcSourceIp;

        private BuilderImpl() {
        }

        private BuilderImpl(IamPolicyConstraints model) {
            sourceIp(model.sourceIp);
            vpcSourceIp(model.vpcSourceIp);
        }

        public final String getSourceIp() {
            return sourceIp;
        }

        public final void setSourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
        }

        @Override
        public final Builder sourceIp(String sourceIp) {
            this.sourceIp = sourceIp;
            return this;
        }

        @Override
        public final Builder sourceIp(EnabledOrDisabled sourceIp) {
            this.sourceIp(sourceIp == null ? null : sourceIp.toString());
            return this;
        }

        public final String getVpcSourceIp() {
            return vpcSourceIp;
        }

        public final void setVpcSourceIp(String vpcSourceIp) {
            this.vpcSourceIp = vpcSourceIp;
        }

        @Override
        public final Builder vpcSourceIp(String vpcSourceIp) {
            this.vpcSourceIp = vpcSourceIp;
            return this;
        }

        @Override
        public final Builder vpcSourceIp(EnabledOrDisabled vpcSourceIp) {
            this.vpcSourceIp(vpcSourceIp == null ? null : vpcSourceIp.toString());
            return this;
        }

        @Override
        public IamPolicyConstraints build() {
            return new IamPolicyConstraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
