/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImportHubContentRequest extends SageMakerRequest implements
        ToCopyableBuilder<ImportHubContentRequest.Builder, ImportHubContentRequest> {
    private static final SdkField<String> HUB_CONTENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentName").getter(getter(ImportHubContentRequest::hubContentName))
            .setter(setter(Builder::hubContentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentName").build()).build();

    private static final SdkField<String> HUB_CONTENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentVersion").getter(getter(ImportHubContentRequest::hubContentVersion))
            .setter(setter(Builder::hubContentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentVersion").build()).build();

    private static final SdkField<String> HUB_CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentType").getter(getter(ImportHubContentRequest::hubContentTypeAsString))
            .setter(setter(Builder::hubContentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentType").build()).build();

    private static final SdkField<String> DOCUMENT_SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentSchemaVersion").getter(getter(ImportHubContentRequest::documentSchemaVersion))
            .setter(setter(Builder::documentSchemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentSchemaVersion").build())
            .build();

    private static final SdkField<String> HUB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubName").getter(getter(ImportHubContentRequest::hubName)).setter(setter(Builder::hubName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()).build();

    private static final SdkField<String> HUB_CONTENT_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDisplayName").getter(getter(ImportHubContentRequest::hubContentDisplayName))
            .setter(setter(Builder::hubContentDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDisplayName").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDescription").getter(getter(ImportHubContentRequest::hubContentDescription))
            .setter(setter(Builder::hubContentDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDescription").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_MARKDOWN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentMarkdown").getter(getter(ImportHubContentRequest::hubContentMarkdown))
            .setter(setter(Builder::hubContentMarkdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentMarkdown").build())
            .build();

    private static final SdkField<String> HUB_CONTENT_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("HubContentDocument").getter(getter(ImportHubContentRequest::hubContentDocument))
            .setter(setter(Builder::hubContentDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentDocument").build())
            .build();

    private static final SdkField<List<String>> HUB_CONTENT_SEARCH_KEYWORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("HubContentSearchKeywords")
            .getter(getter(ImportHubContentRequest::hubContentSearchKeywords))
            .setter(setter(Builder::hubContentSearchKeywords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSearchKeywords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(ImportHubContentRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_NAME_FIELD,
            HUB_CONTENT_VERSION_FIELD, HUB_CONTENT_TYPE_FIELD, DOCUMENT_SCHEMA_VERSION_FIELD, HUB_NAME_FIELD,
            HUB_CONTENT_DISPLAY_NAME_FIELD, HUB_CONTENT_DESCRIPTION_FIELD, HUB_CONTENT_MARKDOWN_FIELD,
            HUB_CONTENT_DOCUMENT_FIELD, HUB_CONTENT_SEARCH_KEYWORDS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String hubContentName;

    private final String hubContentVersion;

    private final String hubContentType;

    private final String documentSchemaVersion;

    private final String hubName;

    private final String hubContentDisplayName;

    private final String hubContentDescription;

    private final String hubContentMarkdown;

    private final String hubContentDocument;

    private final List<String> hubContentSearchKeywords;

    private final List<Tag> tags;

    private ImportHubContentRequest(BuilderImpl builder) {
        super(builder);
        this.hubContentName = builder.hubContentName;
        this.hubContentVersion = builder.hubContentVersion;
        this.hubContentType = builder.hubContentType;
        this.documentSchemaVersion = builder.documentSchemaVersion;
        this.hubName = builder.hubName;
        this.hubContentDisplayName = builder.hubContentDisplayName;
        this.hubContentDescription = builder.hubContentDescription;
        this.hubContentMarkdown = builder.hubContentMarkdown;
        this.hubContentDocument = builder.hubContentDocument;
        this.hubContentSearchKeywords = builder.hubContentSearchKeywords;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the hub content to import.
     * </p>
     * 
     * @return The name of the hub content to import.
     */
    public final String hubContentName() {
        return hubContentName;
    }

    /**
     * <p>
     * The version of the hub content to import.
     * </p>
     * 
     * @return The version of the hub content to import.
     */
    public final String hubContentVersion() {
        return hubContentVersion;
    }

    /**
     * <p>
     * The type of hub content to import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to import.
     * @see HubContentType
     */
    public final HubContentType hubContentType() {
        return HubContentType.fromValue(hubContentType);
    }

    /**
     * <p>
     * The type of hub content to import.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #hubContentType}
     * will return {@link HubContentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #hubContentTypeAsString}.
     * </p>
     * 
     * @return The type of hub content to import.
     * @see HubContentType
     */
    public final String hubContentTypeAsString() {
        return hubContentType;
    }

    /**
     * <p>
     * The version of the hub content schema to import.
     * </p>
     * 
     * @return The version of the hub content schema to import.
     */
    public final String documentSchemaVersion() {
        return documentSchemaVersion;
    }

    /**
     * <p>
     * The name of the hub to import content into.
     * </p>
     * 
     * @return The name of the hub to import content into.
     */
    public final String hubName() {
        return hubName;
    }

    /**
     * <p>
     * The display name of the hub content to import.
     * </p>
     * 
     * @return The display name of the hub content to import.
     */
    public final String hubContentDisplayName() {
        return hubContentDisplayName;
    }

    /**
     * <p>
     * A description of the hub content to import.
     * </p>
     * 
     * @return A description of the hub content to import.
     */
    public final String hubContentDescription() {
        return hubContentDescription;
    }

    /**
     * <p>
     * A string that provides a description of the hub content. This string can include links, tables, and standard
     * markdown formating.
     * </p>
     * 
     * @return A string that provides a description of the hub content. This string can include links, tables, and
     *         standard markdown formating.
     */
    public final String hubContentMarkdown() {
        return hubContentMarkdown;
    }

    /**
     * <p>
     * The hub content document that describes information about the hub content such as type, associated containers,
     * scripts, and more.
     * </p>
     * 
     * @return The hub content document that describes information about the hub content such as type, associated
     *         containers, scripts, and more.
     */
    public final String hubContentDocument() {
        return hubContentDocument;
    }

    /**
     * For responses, this returns true if the service returned a value for the HubContentSearchKeywords property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasHubContentSearchKeywords() {
        return hubContentSearchKeywords != null && !(hubContentSearchKeywords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The searchable keywords of the hub content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHubContentSearchKeywords} method.
     * </p>
     * 
     * @return The searchable keywords of the hub content.
     */
    public final List<String> hubContentSearchKeywords() {
        return hubContentSearchKeywords;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any tags associated with the hub content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Any tags associated with the hub content.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hubContentName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentSchemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hubName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDescription());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(hubContentDocument());
        hashCode = 31 * hashCode + Objects.hashCode(hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportHubContentRequest)) {
            return false;
        }
        ImportHubContentRequest other = (ImportHubContentRequest) obj;
        return Objects.equals(hubContentName(), other.hubContentName())
                && Objects.equals(hubContentVersion(), other.hubContentVersion())
                && Objects.equals(hubContentTypeAsString(), other.hubContentTypeAsString())
                && Objects.equals(documentSchemaVersion(), other.documentSchemaVersion())
                && Objects.equals(hubName(), other.hubName())
                && Objects.equals(hubContentDisplayName(), other.hubContentDisplayName())
                && Objects.equals(hubContentDescription(), other.hubContentDescription())
                && Objects.equals(hubContentMarkdown(), other.hubContentMarkdown())
                && Objects.equals(hubContentDocument(), other.hubContentDocument())
                && hasHubContentSearchKeywords() == other.hasHubContentSearchKeywords()
                && Objects.equals(hubContentSearchKeywords(), other.hubContentSearchKeywords()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImportHubContentRequest").add("HubContentName", hubContentName())
                .add("HubContentVersion", hubContentVersion()).add("HubContentType", hubContentTypeAsString())
                .add("DocumentSchemaVersion", documentSchemaVersion()).add("HubName", hubName())
                .add("HubContentDisplayName", hubContentDisplayName()).add("HubContentDescription", hubContentDescription())
                .add("HubContentMarkdown", hubContentMarkdown()).add("HubContentDocument", hubContentDocument())
                .add("HubContentSearchKeywords", hasHubContentSearchKeywords() ? hubContentSearchKeywords() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "HubContentName":
            return Optional.ofNullable(clazz.cast(hubContentName()));
        case "HubContentVersion":
            return Optional.ofNullable(clazz.cast(hubContentVersion()));
        case "HubContentType":
            return Optional.ofNullable(clazz.cast(hubContentTypeAsString()));
        case "DocumentSchemaVersion":
            return Optional.ofNullable(clazz.cast(documentSchemaVersion()));
        case "HubName":
            return Optional.ofNullable(clazz.cast(hubName()));
        case "HubContentDisplayName":
            return Optional.ofNullable(clazz.cast(hubContentDisplayName()));
        case "HubContentDescription":
            return Optional.ofNullable(clazz.cast(hubContentDescription()));
        case "HubContentMarkdown":
            return Optional.ofNullable(clazz.cast(hubContentMarkdown()));
        case "HubContentDocument":
            return Optional.ofNullable(clazz.cast(hubContentDocument()));
        case "HubContentSearchKeywords":
            return Optional.ofNullable(clazz.cast(hubContentSearchKeywords()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("HubContentName", HUB_CONTENT_NAME_FIELD);
        map.put("HubContentVersion", HUB_CONTENT_VERSION_FIELD);
        map.put("HubContentType", HUB_CONTENT_TYPE_FIELD);
        map.put("DocumentSchemaVersion", DOCUMENT_SCHEMA_VERSION_FIELD);
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubContentDisplayName", HUB_CONTENT_DISPLAY_NAME_FIELD);
        map.put("HubContentDescription", HUB_CONTENT_DESCRIPTION_FIELD);
        map.put("HubContentMarkdown", HUB_CONTENT_MARKDOWN_FIELD);
        map.put("HubContentDocument", HUB_CONTENT_DOCUMENT_FIELD);
        map.put("HubContentSearchKeywords", HUB_CONTENT_SEARCH_KEYWORDS_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImportHubContentRequest, T> g) {
        return obj -> g.apply((ImportHubContentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ImportHubContentRequest> {
        /**
         * <p>
         * The name of the hub content to import.
         * </p>
         * 
         * @param hubContentName
         *        The name of the hub content to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentName(String hubContentName);

        /**
         * <p>
         * The version of the hub content to import.
         * </p>
         * 
         * @param hubContentVersion
         *        The version of the hub content to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentVersion(String hubContentVersion);

        /**
         * <p>
         * The type of hub content to import.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to import.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(String hubContentType);

        /**
         * <p>
         * The type of hub content to import.
         * </p>
         * 
         * @param hubContentType
         *        The type of hub content to import.
         * @see HubContentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see HubContentType
         */
        Builder hubContentType(HubContentType hubContentType);

        /**
         * <p>
         * The version of the hub content schema to import.
         * </p>
         * 
         * @param documentSchemaVersion
         *        The version of the hub content schema to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentSchemaVersion(String documentSchemaVersion);

        /**
         * <p>
         * The name of the hub to import content into.
         * </p>
         * 
         * @param hubName
         *        The name of the hub to import content into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubName(String hubName);

        /**
         * <p>
         * The display name of the hub content to import.
         * </p>
         * 
         * @param hubContentDisplayName
         *        The display name of the hub content to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDisplayName(String hubContentDisplayName);

        /**
         * <p>
         * A description of the hub content to import.
         * </p>
         * 
         * @param hubContentDescription
         *        A description of the hub content to import.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDescription(String hubContentDescription);

        /**
         * <p>
         * A string that provides a description of the hub content. This string can include links, tables, and standard
         * markdown formating.
         * </p>
         * 
         * @param hubContentMarkdown
         *        A string that provides a description of the hub content. This string can include links, tables, and
         *        standard markdown formating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentMarkdown(String hubContentMarkdown);

        /**
         * <p>
         * The hub content document that describes information about the hub content such as type, associated
         * containers, scripts, and more.
         * </p>
         * 
         * @param hubContentDocument
         *        The hub content document that describes information about the hub content such as type, associated
         *        containers, scripts, and more.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentDocument(String hubContentDocument);

        /**
         * <p>
         * The searchable keywords of the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords);

        /**
         * <p>
         * The searchable keywords of the hub content.
         * </p>
         * 
         * @param hubContentSearchKeywords
         *        The searchable keywords of the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hubContentSearchKeywords(String... hubContentSearchKeywords);

        /**
         * <p>
         * Any tags associated with the hub content.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags associated with the hub content.
         * </p>
         * 
         * @param tags
         *        Any tags associated with the hub content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Any tags associated with the hub content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.sagemaker.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String hubContentName;

        private String hubContentVersion;

        private String hubContentType;

        private String documentSchemaVersion;

        private String hubName;

        private String hubContentDisplayName;

        private String hubContentDescription;

        private String hubContentMarkdown;

        private String hubContentDocument;

        private List<String> hubContentSearchKeywords = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportHubContentRequest model) {
            super(model);
            hubContentName(model.hubContentName);
            hubContentVersion(model.hubContentVersion);
            hubContentType(model.hubContentType);
            documentSchemaVersion(model.documentSchemaVersion);
            hubName(model.hubName);
            hubContentDisplayName(model.hubContentDisplayName);
            hubContentDescription(model.hubContentDescription);
            hubContentMarkdown(model.hubContentMarkdown);
            hubContentDocument(model.hubContentDocument);
            hubContentSearchKeywords(model.hubContentSearchKeywords);
            tags(model.tags);
        }

        public final String getHubContentName() {
            return hubContentName;
        }

        public final void setHubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
        }

        @Override
        public final Builder hubContentName(String hubContentName) {
            this.hubContentName = hubContentName;
            return this;
        }

        public final String getHubContentVersion() {
            return hubContentVersion;
        }

        public final void setHubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
        }

        @Override
        public final Builder hubContentVersion(String hubContentVersion) {
            this.hubContentVersion = hubContentVersion;
            return this;
        }

        public final String getHubContentType() {
            return hubContentType;
        }

        public final void setHubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
        }

        @Override
        public final Builder hubContentType(String hubContentType) {
            this.hubContentType = hubContentType;
            return this;
        }

        @Override
        public final Builder hubContentType(HubContentType hubContentType) {
            this.hubContentType(hubContentType == null ? null : hubContentType.toString());
            return this;
        }

        public final String getDocumentSchemaVersion() {
            return documentSchemaVersion;
        }

        public final void setDocumentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
        }

        @Override
        public final Builder documentSchemaVersion(String documentSchemaVersion) {
            this.documentSchemaVersion = documentSchemaVersion;
            return this;
        }

        public final String getHubName() {
            return hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubContentDisplayName() {
            return hubContentDisplayName;
        }

        public final void setHubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
        }

        @Override
        public final Builder hubContentDisplayName(String hubContentDisplayName) {
            this.hubContentDisplayName = hubContentDisplayName;
            return this;
        }

        public final String getHubContentDescription() {
            return hubContentDescription;
        }

        public final void setHubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
        }

        @Override
        public final Builder hubContentDescription(String hubContentDescription) {
            this.hubContentDescription = hubContentDescription;
            return this;
        }

        public final String getHubContentMarkdown() {
            return hubContentMarkdown;
        }

        public final void setHubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
        }

        @Override
        public final Builder hubContentMarkdown(String hubContentMarkdown) {
            this.hubContentMarkdown = hubContentMarkdown;
            return this;
        }

        public final String getHubContentDocument() {
            return hubContentDocument;
        }

        public final void setHubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
        }

        @Override
        public final Builder hubContentDocument(String hubContentDocument) {
            this.hubContentDocument = hubContentDocument;
            return this;
        }

        public final Collection<String> getHubContentSearchKeywords() {
            if (hubContentSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return hubContentSearchKeywords;
        }

        public final void setHubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
        }

        @Override
        public final Builder hubContentSearchKeywords(Collection<String> hubContentSearchKeywords) {
            this.hubContentSearchKeywords = HubContentSearchKeywordListCopier.copy(hubContentSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSearchKeywords(String... hubContentSearchKeywords) {
            hubContentSearchKeywords(Arrays.asList(hubContentSearchKeywords));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ImportHubContentRequest build() {
            return new ImportHubContentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
