/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the resources that are deployed with this inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentContainerSpecificationSummary
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<InferenceComponentContainerSpecificationSummary.Builder, InferenceComponentContainerSpecificationSummary> {
    private static final SdkField<DeployedImage> DEPLOYED_IMAGE_FIELD = SdkField
            .<DeployedImage> builder(MarshallingType.SDK_POJO).memberName("DeployedImage")
            .getter(getter(InferenceComponentContainerSpecificationSummary::deployedImage))
            .setter(setter(Builder::deployedImage)).constructor(DeployedImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeployedImage").build()).build();

    private static final SdkField<String> ARTIFACT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArtifactUrl").getter(getter(InferenceComponentContainerSpecificationSummary::artifactUrl))
            .setter(setter(Builder::artifactUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactUrl").build()).build();

    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Environment")
            .getter(getter(InferenceComponentContainerSpecificationSummary::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYED_IMAGE_FIELD,
            ARTIFACT_URL_FIELD, ENVIRONMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DeployedImage deployedImage;

    private final String artifactUrl;

    private final Map<String, String> environment;

    private InferenceComponentContainerSpecificationSummary(BuilderImpl builder) {
        this.deployedImage = builder.deployedImage;
        this.artifactUrl = builder.artifactUrl;
        this.environment = builder.environment;
    }

    /**
     * Returns the value of the DeployedImage property for this object.
     * 
     * @return The value of the DeployedImage property for this object.
     */
    public final DeployedImage deployedImage() {
        return deployedImage;
    }

    /**
     * <p>
     * The Amazon S3 path where the model artifacts are stored.
     * </p>
     * 
     * @return The Amazon S3 path where the model artifacts are stored.
     */
    public final String artifactUrl() {
        return artifactUrl;
    }

    /**
     * For responses, this returns true if the service returned a value for the Environment property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEnvironment() {
        return environment != null && !(environment instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The environment variables to set in the Docker container.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnvironment} method.
     * </p>
     * 
     * @return The environment variables to set in the Docker container.
     */
    public final Map<String, String> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deployedImage());
        hashCode = 31 * hashCode + Objects.hashCode(artifactUrl());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnvironment() ? environment() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentContainerSpecificationSummary)) {
            return false;
        }
        InferenceComponentContainerSpecificationSummary other = (InferenceComponentContainerSpecificationSummary) obj;
        return Objects.equals(deployedImage(), other.deployedImage()) && Objects.equals(artifactUrl(), other.artifactUrl())
                && hasEnvironment() == other.hasEnvironment() && Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentContainerSpecificationSummary").add("DeployedImage", deployedImage())
                .add("ArtifactUrl", artifactUrl()).add("Environment", hasEnvironment() ? environment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeployedImage":
            return Optional.ofNullable(clazz.cast(deployedImage()));
        case "ArtifactUrl":
            return Optional.ofNullable(clazz.cast(artifactUrl()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeployedImage", DEPLOYED_IMAGE_FIELD);
        map.put("ArtifactUrl", ARTIFACT_URL_FIELD);
        map.put("Environment", ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentContainerSpecificationSummary, T> g) {
        return obj -> g.apply((InferenceComponentContainerSpecificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentContainerSpecificationSummary> {
        /**
         * Sets the value of the DeployedImage property for this object.
         *
         * @param deployedImage
         *        The new value for the DeployedImage property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployedImage(DeployedImage deployedImage);

        /**
         * Sets the value of the DeployedImage property for this object.
         *
         * This is a convenience method that creates an instance of the {@link DeployedImage.Builder} avoiding the need
         * to create one manually via {@link DeployedImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeployedImage.Builder#build()} is called immediately and its
         * result is passed to {@link #deployedImage(DeployedImage)}.
         * 
         * @param deployedImage
         *        a consumer that will call methods on {@link DeployedImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployedImage(DeployedImage)
         */
        default Builder deployedImage(Consumer<DeployedImage.Builder> deployedImage) {
            return deployedImage(DeployedImage.builder().applyMutation(deployedImage).build());
        }

        /**
         * <p>
         * The Amazon S3 path where the model artifacts are stored.
         * </p>
         * 
         * @param artifactUrl
         *        The Amazon S3 path where the model artifacts are stored.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder artifactUrl(String artifactUrl);

        /**
         * <p>
         * The environment variables to set in the Docker container.
         * </p>
         * 
         * @param environment
         *        The environment variables to set in the Docker container.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Map<String, String> environment);
    }

    static final class BuilderImpl implements Builder {
        private DeployedImage deployedImage;

        private String artifactUrl;

        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentContainerSpecificationSummary model) {
            deployedImage(model.deployedImage);
            artifactUrl(model.artifactUrl);
            environment(model.environment);
        }

        public final DeployedImage.Builder getDeployedImage() {
            return deployedImage != null ? deployedImage.toBuilder() : null;
        }

        public final void setDeployedImage(DeployedImage.BuilderImpl deployedImage) {
            this.deployedImage = deployedImage != null ? deployedImage.build() : null;
        }

        @Override
        public final Builder deployedImage(DeployedImage deployedImage) {
            this.deployedImage = deployedImage;
            return this;
        }

        public final String getArtifactUrl() {
            return artifactUrl;
        }

        public final void setArtifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
        }

        @Override
        public final Builder artifactUrl(String artifactUrl) {
            this.artifactUrl = artifactUrl;
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = EnvironmentMapCopier.copy(environment);
            return this;
        }

        @Override
        public InferenceComponentContainerSpecificationSummary build() {
            return new InferenceComponentContainerSpecificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
