/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the runtime settings for the model that is deployed with the inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentRuntimeConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentRuntimeConfigSummary.Builder, InferenceComponentRuntimeConfigSummary> {
    private static final SdkField<Integer> DESIRED_COPY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCopyCount").getter(getter(InferenceComponentRuntimeConfigSummary::desiredCopyCount))
            .setter(setter(Builder::desiredCopyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCopyCount").build()).build();

    private static final SdkField<Integer> CURRENT_COPY_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CurrentCopyCount").getter(getter(InferenceComponentRuntimeConfigSummary::currentCopyCount))
            .setter(setter(Builder::currentCopyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCopyCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_COPY_COUNT_FIELD,
            CURRENT_COPY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer desiredCopyCount;

    private final Integer currentCopyCount;

    private InferenceComponentRuntimeConfigSummary(BuilderImpl builder) {
        this.desiredCopyCount = builder.desiredCopyCount;
        this.currentCopyCount = builder.currentCopyCount;
    }

    /**
     * <p>
     * The number of runtime copies of the model container that you requested to deploy with the inference component.
     * </p>
     * 
     * @return The number of runtime copies of the model container that you requested to deploy with the inference
     *         component.
     */
    public final Integer desiredCopyCount() {
        return desiredCopyCount;
    }

    /**
     * <p>
     * The number of runtime copies of the model container that are currently deployed.
     * </p>
     * 
     * @return The number of runtime copies of the model container that are currently deployed.
     */
    public final Integer currentCopyCount() {
        return currentCopyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredCopyCount());
        hashCode = 31 * hashCode + Objects.hashCode(currentCopyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentRuntimeConfigSummary)) {
            return false;
        }
        InferenceComponentRuntimeConfigSummary other = (InferenceComponentRuntimeConfigSummary) obj;
        return Objects.equals(desiredCopyCount(), other.desiredCopyCount())
                && Objects.equals(currentCopyCount(), other.currentCopyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentRuntimeConfigSummary").add("DesiredCopyCount", desiredCopyCount())
                .add("CurrentCopyCount", currentCopyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredCopyCount":
            return Optional.ofNullable(clazz.cast(desiredCopyCount()));
        case "CurrentCopyCount":
            return Optional.ofNullable(clazz.cast(currentCopyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DesiredCopyCount", DESIRED_COPY_COUNT_FIELD);
        map.put("CurrentCopyCount", CURRENT_COPY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentRuntimeConfigSummary, T> g) {
        return obj -> g.apply((InferenceComponentRuntimeConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentRuntimeConfigSummary> {
        /**
         * <p>
         * The number of runtime copies of the model container that you requested to deploy with the inference
         * component.
         * </p>
         * 
         * @param desiredCopyCount
         *        The number of runtime copies of the model container that you requested to deploy with the inference
         *        component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCopyCount(Integer desiredCopyCount);

        /**
         * <p>
         * The number of runtime copies of the model container that are currently deployed.
         * </p>
         * 
         * @param currentCopyCount
         *        The number of runtime copies of the model container that are currently deployed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentCopyCount(Integer currentCopyCount);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredCopyCount;

        private Integer currentCopyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentRuntimeConfigSummary model) {
            desiredCopyCount(model.desiredCopyCount);
            currentCopyCount(model.currentCopyCount);
        }

        public final Integer getDesiredCopyCount() {
            return desiredCopyCount;
        }

        public final void setDesiredCopyCount(Integer desiredCopyCount) {
            this.desiredCopyCount = desiredCopyCount;
        }

        @Override
        public final Builder desiredCopyCount(Integer desiredCopyCount) {
            this.desiredCopyCount = desiredCopyCount;
            return this;
        }

        public final Integer getCurrentCopyCount() {
            return currentCopyCount;
        }

        public final void setCurrentCopyCount(Integer currentCopyCount) {
            this.currentCopyCount = currentCopyCount;
        }

        @Override
        public final Builder currentCopyCount(Integer currentCopyCount) {
            this.currentCopyCount = currentCopyCount;
            return this;
        }

        @Override
        public InferenceComponentRuntimeConfigSummary build() {
            return new InferenceComponentRuntimeConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
