/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the resources that are deployed with this inference component.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InferenceComponentSpecificationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<InferenceComponentSpecificationSummary.Builder, InferenceComponentSpecificationSummary> {
    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelName").getter(getter(InferenceComponentSpecificationSummary::modelName))
            .setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelName").build()).build();

    private static final SdkField<InferenceComponentContainerSpecificationSummary> CONTAINER_FIELD = SdkField
            .<InferenceComponentContainerSpecificationSummary> builder(MarshallingType.SDK_POJO).memberName("Container")
            .getter(getter(InferenceComponentSpecificationSummary::container)).setter(setter(Builder::container))
            .constructor(InferenceComponentContainerSpecificationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Container").build()).build();

    private static final SdkField<InferenceComponentStartupParameters> STARTUP_PARAMETERS_FIELD = SdkField
            .<InferenceComponentStartupParameters> builder(MarshallingType.SDK_POJO).memberName("StartupParameters")
            .getter(getter(InferenceComponentSpecificationSummary::startupParameters)).setter(setter(Builder::startupParameters))
            .constructor(InferenceComponentStartupParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartupParameters").build()).build();

    private static final SdkField<InferenceComponentComputeResourceRequirements> COMPUTE_RESOURCE_REQUIREMENTS_FIELD = SdkField
            .<InferenceComponentComputeResourceRequirements> builder(MarshallingType.SDK_POJO)
            .memberName("ComputeResourceRequirements")
            .getter(getter(InferenceComponentSpecificationSummary::computeResourceRequirements))
            .setter(setter(Builder::computeResourceRequirements))
            .constructor(InferenceComponentComputeResourceRequirements::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeResourceRequirements")
                    .build()).build();

    private static final SdkField<String> BASE_INFERENCE_COMPONENT_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("BaseInferenceComponentName")
            .getter(getter(InferenceComponentSpecificationSummary::baseInferenceComponentName))
            .setter(setter(Builder::baseInferenceComponentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BaseInferenceComponentName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_NAME_FIELD,
            CONTAINER_FIELD, STARTUP_PARAMETERS_FIELD, COMPUTE_RESOURCE_REQUIREMENTS_FIELD, BASE_INFERENCE_COMPONENT_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelName;

    private final InferenceComponentContainerSpecificationSummary container;

    private final InferenceComponentStartupParameters startupParameters;

    private final InferenceComponentComputeResourceRequirements computeResourceRequirements;

    private final String baseInferenceComponentName;

    private InferenceComponentSpecificationSummary(BuilderImpl builder) {
        this.modelName = builder.modelName;
        this.container = builder.container;
        this.startupParameters = builder.startupParameters;
        this.computeResourceRequirements = builder.computeResourceRequirements;
        this.baseInferenceComponentName = builder.baseInferenceComponentName;
    }

    /**
     * <p>
     * The name of the SageMaker AI model object that is deployed with the inference component.
     * </p>
     * 
     * @return The name of the SageMaker AI model object that is deployed with the inference component.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Details about the container that provides the runtime environment for the model that is deployed with the
     * inference component.
     * </p>
     * 
     * @return Details about the container that provides the runtime environment for the model that is deployed with the
     *         inference component.
     */
    public final InferenceComponentContainerSpecificationSummary container() {
        return container;
    }

    /**
     * <p>
     * Settings that take effect while the model container starts up.
     * </p>
     * 
     * @return Settings that take effect while the model container starts up.
     */
    public final InferenceComponentStartupParameters startupParameters() {
        return startupParameters;
    }

    /**
     * <p>
     * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
     * component.
     * </p>
     * 
     * @return The compute resources allocated to run the model, plus any adapter models, that you assign to the
     *         inference component.
     */
    public final InferenceComponentComputeResourceRequirements computeResourceRequirements() {
        return computeResourceRequirements;
    }

    /**
     * <p>
     * The name of the base inference component that contains this inference component.
     * </p>
     * 
     * @return The name of the base inference component that contains this inference component.
     */
    public final String baseInferenceComponentName() {
        return baseInferenceComponentName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(container());
        hashCode = 31 * hashCode + Objects.hashCode(startupParameters());
        hashCode = 31 * hashCode + Objects.hashCode(computeResourceRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(baseInferenceComponentName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceComponentSpecificationSummary)) {
            return false;
        }
        InferenceComponentSpecificationSummary other = (InferenceComponentSpecificationSummary) obj;
        return Objects.equals(modelName(), other.modelName()) && Objects.equals(container(), other.container())
                && Objects.equals(startupParameters(), other.startupParameters())
                && Objects.equals(computeResourceRequirements(), other.computeResourceRequirements())
                && Objects.equals(baseInferenceComponentName(), other.baseInferenceComponentName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InferenceComponentSpecificationSummary").add("ModelName", modelName())
                .add("Container", container()).add("StartupParameters", startupParameters())
                .add("ComputeResourceRequirements", computeResourceRequirements())
                .add("BaseInferenceComponentName", baseInferenceComponentName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "Container":
            return Optional.ofNullable(clazz.cast(container()));
        case "StartupParameters":
            return Optional.ofNullable(clazz.cast(startupParameters()));
        case "ComputeResourceRequirements":
            return Optional.ofNullable(clazz.cast(computeResourceRequirements()));
        case "BaseInferenceComponentName":
            return Optional.ofNullable(clazz.cast(baseInferenceComponentName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelName", MODEL_NAME_FIELD);
        map.put("Container", CONTAINER_FIELD);
        map.put("StartupParameters", STARTUP_PARAMETERS_FIELD);
        map.put("ComputeResourceRequirements", COMPUTE_RESOURCE_REQUIREMENTS_FIELD);
        map.put("BaseInferenceComponentName", BASE_INFERENCE_COMPONENT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InferenceComponentSpecificationSummary, T> g) {
        return obj -> g.apply((InferenceComponentSpecificationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InferenceComponentSpecificationSummary> {
        /**
         * <p>
         * The name of the SageMaker AI model object that is deployed with the inference component.
         * </p>
         * 
         * @param modelName
         *        The name of the SageMaker AI model object that is deployed with the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Details about the container that provides the runtime environment for the model that is deployed with the
         * inference component.
         * </p>
         * 
         * @param container
         *        Details about the container that provides the runtime environment for the model that is deployed with
         *        the inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder container(InferenceComponentContainerSpecificationSummary container);

        /**
         * <p>
         * Details about the container that provides the runtime environment for the model that is deployed with the
         * inference component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentContainerSpecificationSummary.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentContainerSpecificationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentContainerSpecificationSummary.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #container(InferenceComponentContainerSpecificationSummary)}.
         * 
         * @param container
         *        a consumer that will call methods on {@link InferenceComponentContainerSpecificationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #container(InferenceComponentContainerSpecificationSummary)
         */
        default Builder container(Consumer<InferenceComponentContainerSpecificationSummary.Builder> container) {
            return container(InferenceComponentContainerSpecificationSummary.builder().applyMutation(container).build());
        }

        /**
         * <p>
         * Settings that take effect while the model container starts up.
         * </p>
         * 
         * @param startupParameters
         *        Settings that take effect while the model container starts up.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startupParameters(InferenceComponentStartupParameters startupParameters);

        /**
         * <p>
         * Settings that take effect while the model container starts up.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentStartupParameters.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentStartupParameters#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentStartupParameters.Builder#build()} is called
         * immediately and its result is passed to {@link #startupParameters(InferenceComponentStartupParameters)}.
         * 
         * @param startupParameters
         *        a consumer that will call methods on {@link InferenceComponentStartupParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #startupParameters(InferenceComponentStartupParameters)
         */
        default Builder startupParameters(Consumer<InferenceComponentStartupParameters.Builder> startupParameters) {
            return startupParameters(InferenceComponentStartupParameters.builder().applyMutation(startupParameters).build());
        }

        /**
         * <p>
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
         * component.
         * </p>
         * 
         * @param computeResourceRequirements
         *        The compute resources allocated to run the model, plus any adapter models, that you assign to the
         *        inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements);

        /**
         * <p>
         * The compute resources allocated to run the model, plus any adapter models, that you assign to the inference
         * component.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InferenceComponentComputeResourceRequirements.Builder} avoiding the need to create one manually via
         * {@link InferenceComponentComputeResourceRequirements#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceComponentComputeResourceRequirements.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #computeResourceRequirements(InferenceComponentComputeResourceRequirements)}.
         * 
         * @param computeResourceRequirements
         *        a consumer that will call methods on {@link InferenceComponentComputeResourceRequirements.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeResourceRequirements(InferenceComponentComputeResourceRequirements)
         */
        default Builder computeResourceRequirements(
                Consumer<InferenceComponentComputeResourceRequirements.Builder> computeResourceRequirements) {
            return computeResourceRequirements(InferenceComponentComputeResourceRequirements.builder()
                    .applyMutation(computeResourceRequirements).build());
        }

        /**
         * <p>
         * The name of the base inference component that contains this inference component.
         * </p>
         * 
         * @param baseInferenceComponentName
         *        The name of the base inference component that contains this inference component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseInferenceComponentName(String baseInferenceComponentName);
    }

    static final class BuilderImpl implements Builder {
        private String modelName;

        private InferenceComponentContainerSpecificationSummary container;

        private InferenceComponentStartupParameters startupParameters;

        private InferenceComponentComputeResourceRequirements computeResourceRequirements;

        private String baseInferenceComponentName;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceComponentSpecificationSummary model) {
            modelName(model.modelName);
            container(model.container);
            startupParameters(model.startupParameters);
            computeResourceRequirements(model.computeResourceRequirements);
            baseInferenceComponentName(model.baseInferenceComponentName);
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final InferenceComponentContainerSpecificationSummary.Builder getContainer() {
            return container != null ? container.toBuilder() : null;
        }

        public final void setContainer(InferenceComponentContainerSpecificationSummary.BuilderImpl container) {
            this.container = container != null ? container.build() : null;
        }

        @Override
        public final Builder container(InferenceComponentContainerSpecificationSummary container) {
            this.container = container;
            return this;
        }

        public final InferenceComponentStartupParameters.Builder getStartupParameters() {
            return startupParameters != null ? startupParameters.toBuilder() : null;
        }

        public final void setStartupParameters(InferenceComponentStartupParameters.BuilderImpl startupParameters) {
            this.startupParameters = startupParameters != null ? startupParameters.build() : null;
        }

        @Override
        public final Builder startupParameters(InferenceComponentStartupParameters startupParameters) {
            this.startupParameters = startupParameters;
            return this;
        }

        public final InferenceComponentComputeResourceRequirements.Builder getComputeResourceRequirements() {
            return computeResourceRequirements != null ? computeResourceRequirements.toBuilder() : null;
        }

        public final void setComputeResourceRequirements(
                InferenceComponentComputeResourceRequirements.BuilderImpl computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements != null ? computeResourceRequirements.build() : null;
        }

        @Override
        public final Builder computeResourceRequirements(InferenceComponentComputeResourceRequirements computeResourceRequirements) {
            this.computeResourceRequirements = computeResourceRequirements;
            return this;
        }

        public final String getBaseInferenceComponentName() {
            return baseInferenceComponentName;
        }

        public final void setBaseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
        }

        @Override
        public final Builder baseInferenceComponentName(String baseInferenceComponentName) {
            this.baseInferenceComponentName = baseInferenceComponentName;
            return this;
        }

        @Override
        public InferenceComponentSpecificationSummary build() {
            return new InferenceComponentSpecificationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
