/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines an instance group for heterogeneous cluster training. When requesting a training job using the <a
 * href="https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_CreateTrainingJob.html">CreateTrainingJob</a>
 * API, you can configure multiple instance groups .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceGroup implements SdkPojo, Serializable, ToCopyableBuilder<InstanceGroup.Builder, InstanceGroup> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(InstanceGroup::instanceTypeAsString)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InstanceCount").getter(getter(InstanceGroup::instanceCount)).setter(setter(Builder::instanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()).build();

    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceGroupName").getter(getter(InstanceGroup::instanceGroupName))
            .setter(setter(Builder::instanceGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            INSTANCE_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final Integer instanceCount;

    private final String instanceGroupName;

    private InstanceGroup(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.instanceCount = builder.instanceCount;
        this.instanceGroupName = builder.instanceGroupName;
    }

    /**
     * <p>
     * Specifies the instance type of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TrainingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Specifies the instance type of the instance group.
     * @see TrainingInstanceType
     */
    public final TrainingInstanceType instanceType() {
        return TrainingInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * Specifies the instance type of the instance group.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link TrainingInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return Specifies the instance type of the instance group.
     * @see TrainingInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Specifies the number of instances of the instance group.
     * </p>
     * 
     * @return Specifies the number of instances of the instance group.
     */
    public final Integer instanceCount() {
        return instanceCount;
    }

    /**
     * <p>
     * Specifies the name of the instance group.
     * </p>
     * 
     * @return Specifies the name of the instance group.
     */
    public final String instanceGroupName() {
        return instanceGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(instanceGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroup)) {
            return false;
        }
        InstanceGroup other = (InstanceGroup) obj;
        return Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instanceCount(), other.instanceCount())
                && Objects.equals(instanceGroupName(), other.instanceGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceGroup").add("InstanceType", instanceTypeAsString())
                .add("InstanceCount", instanceCount()).add("InstanceGroupName", instanceGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstanceCount":
            return Optional.ofNullable(clazz.cast(instanceCount()));
        case "InstanceGroupName":
            return Optional.ofNullable(clazz.cast(instanceGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstanceCount", INSTANCE_COUNT_FIELD);
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceGroup, T> g) {
        return obj -> g.apply((InstanceGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceGroup> {
        /**
         * <p>
         * Specifies the instance type of the instance group.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type of the instance group.
         * @see TrainingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * Specifies the instance type of the instance group.
         * </p>
         * 
         * @param instanceType
         *        Specifies the instance type of the instance group.
         * @see TrainingInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TrainingInstanceType
         */
        Builder instanceType(TrainingInstanceType instanceType);

        /**
         * <p>
         * Specifies the number of instances of the instance group.
         * </p>
         * 
         * @param instanceCount
         *        Specifies the number of instances of the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCount(Integer instanceCount);

        /**
         * <p>
         * Specifies the name of the instance group.
         * </p>
         * 
         * @param instanceGroupName
         *        Specifies the name of the instance group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupName(String instanceGroupName);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private Integer instanceCount;

        private String instanceGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroup model) {
            instanceType(model.instanceType);
            instanceCount(model.instanceCount);
            instanceGroupName(model.instanceGroupName);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(TrainingInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Integer getInstanceCount() {
            return instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        @Override
        public InstanceGroup build() {
            return new InstanceGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
