/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAliasesResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListAliasesResponse.Builder, ListAliasesResponse> {
    private static final SdkField<List<String>> SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SageMakerImageVersionAliases")
            .getter(getter(ListAliasesResponse::sageMakerImageVersionAliases))
            .setter(setter(Builder::sageMakerImageVersionAliases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerImageVersionAliases")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListAliasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> sageMakerImageVersionAliases;

    private final String nextToken;

    private ListAliasesResponse(BuilderImpl builder) {
        super(builder);
        this.sageMakerImageVersionAliases = builder.sageMakerImageVersionAliases;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SageMakerImageVersionAliases property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSageMakerImageVersionAliases() {
        return sageMakerImageVersionAliases != null && !(sageMakerImageVersionAliases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SageMaker AI image version aliases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSageMakerImageVersionAliases} method.
     * </p>
     * 
     * @return A list of SageMaker AI image version aliases.
     */
    public final List<String> sageMakerImageVersionAliases() {
        return sageMakerImageVersionAliases;
    }

    /**
     * <p>
     * A token for getting the next set of aliases, if more aliases exist.
     * </p>
     * 
     * @return A token for getting the next set of aliases, if more aliases exist.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSageMakerImageVersionAliases() ? sageMakerImageVersionAliases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAliasesResponse)) {
            return false;
        }
        ListAliasesResponse other = (ListAliasesResponse) obj;
        return hasSageMakerImageVersionAliases() == other.hasSageMakerImageVersionAliases()
                && Objects.equals(sageMakerImageVersionAliases(), other.sageMakerImageVersionAliases())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAliasesResponse")
                .add("SageMakerImageVersionAliases", hasSageMakerImageVersionAliases() ? sageMakerImageVersionAliases() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SageMakerImageVersionAliases":
            return Optional.ofNullable(clazz.cast(sageMakerImageVersionAliases()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SageMakerImageVersionAliases", SAGE_MAKER_IMAGE_VERSION_ALIASES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAliasesResponse, T> g) {
        return obj -> g.apply((ListAliasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAliasesResponse> {
        /**
         * <p>
         * A list of SageMaker AI image version aliases.
         * </p>
         * 
         * @param sageMakerImageVersionAliases
         *        A list of SageMaker AI image version aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerImageVersionAliases(Collection<String> sageMakerImageVersionAliases);

        /**
         * <p>
         * A list of SageMaker AI image version aliases.
         * </p>
         * 
         * @param sageMakerImageVersionAliases
         *        A list of SageMaker AI image version aliases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sageMakerImageVersionAliases(String... sageMakerImageVersionAliases);

        /**
         * <p>
         * A token for getting the next set of aliases, if more aliases exist.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of aliases, if more aliases exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<String> sageMakerImageVersionAliases = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAliasesResponse model) {
            super(model);
            sageMakerImageVersionAliases(model.sageMakerImageVersionAliases);
            nextToken(model.nextToken);
        }

        public final Collection<String> getSageMakerImageVersionAliases() {
            if (sageMakerImageVersionAliases instanceof SdkAutoConstructList) {
                return null;
            }
            return sageMakerImageVersionAliases;
        }

        public final void setSageMakerImageVersionAliases(Collection<String> sageMakerImageVersionAliases) {
            this.sageMakerImageVersionAliases = SageMakerImageVersionAliasesCopier.copy(sageMakerImageVersionAliases);
        }

        @Override
        public final Builder sageMakerImageVersionAliases(Collection<String> sageMakerImageVersionAliases) {
            this.sageMakerImageVersionAliases = SageMakerImageVersionAliasesCopier.copy(sageMakerImageVersionAliases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sageMakerImageVersionAliases(String... sageMakerImageVersionAliases) {
            sageMakerImageVersionAliases(Arrays.asList(sageMakerImageVersionAliases));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAliasesResponse build() {
            return new ListAliasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
