/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListClusterSchedulerConfigsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListClusterSchedulerConfigsRequest.Builder, ListClusterSchedulerConfigsRequest> {
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAfter").getter(getter(ListClusterSchedulerConfigsRequest::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedBefore").getter(getter(ListClusterSchedulerConfigsRequest::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()).build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListClusterSchedulerConfigsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(ListClusterSchedulerConfigsRequest::clusterArn))
            .setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListClusterSchedulerConfigsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListClusterSchedulerConfigsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListClusterSchedulerConfigsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListClusterSchedulerConfigsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListClusterSchedulerConfigsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AFTER_FIELD,
            CREATED_BEFORE_FIELD, NAME_CONTAINS_FIELD, CLUSTER_ARN_FIELD, STATUS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String nameContains;

    private final String clusterArn;

    private final String status;

    private final String sortBy;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListClusterSchedulerConfigsRequest(BuilderImpl builder) {
        super(builder);
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.nameContains = builder.nameContains;
        this.clusterArn = builder.clusterArn;
        this.status = builder.status;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Filter for after this creation time. The input for this parameter is a Unix timestamp. To convert a date and time
     * into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     * </p>
     * 
     * @return Filter for after this creation time. The input for this parameter is a Unix timestamp. To convert a date
     *         and time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * Filter for before this creation time. The input for this parameter is a Unix timestamp. To convert a date and
     * time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     * </p>
     * 
     * @return Filter for before this creation time. The input for this parameter is a Unix timestamp. To convert a date
     *         and time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * Filter for name containing this string.
     * </p>
     * 
     * @return Filter for name containing this string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Filter for ARN of the cluster.
     * </p>
     * 
     * @return Filter for ARN of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * Filter for status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter for status.
     * @see SchedulerResourceStatus
     */
    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(status);
    }

    /**
     * <p>
     * Filter for status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SchedulerResourceStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter for status.
     * @see SchedulerResourceStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortClusterSchedulerConfigBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
     * @see SortClusterSchedulerConfigBy
     */
    public final SortClusterSchedulerConfigBy sortBy() {
        return SortClusterSchedulerConfigBy.fromValue(sortBy);
    }

    /**
     * <p>
     * Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link SortClusterSchedulerConfigBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
     * @see SortClusterSchedulerConfigBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The order of the list. By default, listed in <code>Descending</code> order according to by <code>SortBy</code>.
     * To change the list order, you can specify <code>SortOrder</code> to be <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order of the list. By default, listed in <code>Descending</code> order according to by
     *         <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
     *         <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The order of the list. By default, listed in <code>Descending</code> order according to by <code>SortBy</code>.
     * To change the list order, you can specify <code>SortOrder</code> to be <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The order of the list. By default, listed in <code>Descending</code> order according to by
     *         <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
     *         <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * If the previous response was truncated, you will receive this token. Use it in your next request to receive the
     * next set of results.
     * </p>
     * 
     * @return If the previous response was truncated, you will receive this token. Use it in your next request to
     *         receive the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of cluster policies to list.
     * </p>
     * 
     * @return The maximum number of cluster policies to list.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClusterSchedulerConfigsRequest)) {
            return false;
        }
        ListClusterSchedulerConfigsRequest other = (ListClusterSchedulerConfigsRequest) obj;
        return Objects.equals(createdAfter(), other.createdAfter()) && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(nameContains(), other.nameContains()) && Objects.equals(clusterArn(), other.clusterArn())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListClusterSchedulerConfigsRequest").add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("NameContains", nameContains()).add("ClusterArn", clusterArn())
                .add("Status", statusAsString()).add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "CreatedBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedAfter", CREATED_AFTER_FIELD);
        map.put("CreatedBefore", CREATED_BEFORE_FIELD);
        map.put("NameContains", NAME_CONTAINS_FIELD);
        map.put("ClusterArn", CLUSTER_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListClusterSchedulerConfigsRequest, T> g) {
        return obj -> g.apply((ListClusterSchedulerConfigsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListClusterSchedulerConfigsRequest> {
        /**
         * <p>
         * Filter for after this creation time. The input for this parameter is a Unix timestamp. To convert a date and
         * time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * </p>
         * 
         * @param createdAfter
         *        Filter for after this creation time. The input for this parameter is a Unix timestamp. To convert a
         *        date and time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * Filter for before this creation time. The input for this parameter is a Unix timestamp. To convert a date and
         * time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * </p>
         * 
         * @param createdBefore
         *        Filter for before this creation time. The input for this parameter is a Unix timestamp. To convert a
         *        date and time into a Unix timestamp, see <a href="https://www.epochconverter.com/">EpochConverter</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * Filter for name containing this string.
         * </p>
         * 
         * @param nameContains
         *        Filter for name containing this string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Filter for ARN of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        Filter for ARN of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * Filter for status.
         * </p>
         * 
         * @param status
         *        Filter for status.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filter for status.
         * </p>
         * 
         * @param status
         *        Filter for status.
         * @see SchedulerResourceStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SchedulerResourceStatus
         */
        Builder status(SchedulerResourceStatus status);

        /**
         * <p>
         * Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
         * </p>
         * 
         * @param sortBy
         *        Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
         * @see SortClusterSchedulerConfigBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortClusterSchedulerConfigBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
         * </p>
         * 
         * @param sortBy
         *        Filter for sorting the list by a given value. For example, sort by name, creation time, or status.
         * @see SortClusterSchedulerConfigBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortClusterSchedulerConfigBy
         */
        Builder sortBy(SortClusterSchedulerConfigBy sortBy);

        /**
         * <p>
         * The order of the list. By default, listed in <code>Descending</code> order according to by
         * <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
         * <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The order of the list. By default, listed in <code>Descending</code> order according to by
         *        <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
         *        <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The order of the list. By default, listed in <code>Descending</code> order according to by
         * <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
         * <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The order of the list. By default, listed in <code>Descending</code> order according to by
         *        <code>SortBy</code>. To change the list order, you can specify <code>SortOrder</code> to be
         *        <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * If the previous response was truncated, you will receive this token. Use it in your next request to receive
         * the next set of results.
         * </p>
         * 
         * @param nextToken
         *        If the previous response was truncated, you will receive this token. Use it in your next request to
         *        receive the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of cluster policies to list.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of cluster policies to list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private Instant createdAfter;

        private Instant createdBefore;

        private String nameContains;

        private String clusterArn;

        private String status;

        private String sortBy;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListClusterSchedulerConfigsRequest model) {
            super(model);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            nameContains(model.nameContains);
            clusterArn(model.clusterArn);
            status(model.status);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortClusterSchedulerConfigBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListClusterSchedulerConfigsRequest build() {
            return new ListClusterSchedulerConfigsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
