/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListLabelingJobsForWorkteamRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListLabelingJobsForWorkteamRequest.Builder, ListLabelingJobsForWorkteamRequest> {
    private static final SdkField<String> WORKTEAM_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkteamArn").getter(getter(ListLabelingJobsForWorkteamRequest::workteamArn))
            .setter(setter(Builder::workteamArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkteamArn").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListLabelingJobsForWorkteamRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListLabelingJobsForWorkteamRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListLabelingJobsForWorkteamRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListLabelingJobsForWorkteamRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<String> JOB_REFERENCE_CODE_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobReferenceCodeContains").getter(getter(ListLabelingJobsForWorkteamRequest::jobReferenceCodeContains))
            .setter(setter(Builder::jobReferenceCodeContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCodeContains").build())
            .build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListLabelingJobsForWorkteamRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListLabelingJobsForWorkteamRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKTEAM_ARN_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD,
            JOB_REFERENCE_CODE_CONTAINS_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workteamArn;

    private final Integer maxResults;

    private final String nextToken;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final String jobReferenceCodeContains;

    private final String sortBy;

    private final String sortOrder;

    private ListLabelingJobsForWorkteamRequest(BuilderImpl builder) {
        super(builder);
        this.workteamArn = builder.workteamArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.jobReferenceCodeContains = builder.jobReferenceCodeContains;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.
     */
    public final String workteamArn() {
        return workteamArn;
    }

    /**
     * <p>
     * The maximum number of labeling jobs to return in each page of the response.
     * </p>
     * 
     * @return The maximum number of labeling jobs to return in each page of the response.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response
     * includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next request.
     * </p>
     * 
     * @return If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the
     *         response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in
     *         the next request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter that returns only labeling jobs created after the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only labeling jobs created after the specified time (timestamp).
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * A filter that returns only labeling jobs created before the specified time (timestamp).
     * </p>
     * 
     * @return A filter that returns only labeling jobs created before the specified time (timestamp).
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * A filter the limits jobs to only the ones whose job reference code contains the specified string.
     * </p>
     * 
     * @return A filter the limits jobs to only the ones whose job reference code contains the specified string.
     */
    public final String jobReferenceCodeContains() {
        return jobReferenceCodeContains;
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListLabelingJobsForWorkteamSortByOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>CreationTime</code>.
     * @see ListLabelingJobsForWorkteamSortByOptions
     */
    public final ListLabelingJobsForWorkteamSortByOptions sortBy() {
        return ListLabelingJobsForWorkteamSortByOptions.fromValue(sortBy);
    }

    /**
     * <p>
     * The field to sort results by. The default is <code>CreationTime</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListLabelingJobsForWorkteamSortByOptions#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field to sort results by. The default is <code>CreationTime</code>.
     * @see ListLabelingJobsForWorkteamSortByOptions
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>.
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workteamArn());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(jobReferenceCodeContains());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLabelingJobsForWorkteamRequest)) {
            return false;
        }
        ListLabelingJobsForWorkteamRequest other = (ListLabelingJobsForWorkteamRequest) obj;
        return Objects.equals(workteamArn(), other.workteamArn()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(jobReferenceCodeContains(), other.jobReferenceCodeContains())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListLabelingJobsForWorkteamRequest").add("WorkteamArn", workteamArn())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore()).add("JobReferenceCodeContains", jobReferenceCodeContains())
                .add("SortBy", sortByAsString()).add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WorkteamArn":
            return Optional.ofNullable(clazz.cast(workteamArn()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "JobReferenceCodeContains":
            return Optional.ofNullable(clazz.cast(jobReferenceCodeContains()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("WorkteamArn", WORKTEAM_ARN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("JobReferenceCodeContains", JOB_REFERENCE_CODE_CONTAINS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListLabelingJobsForWorkteamRequest, T> g) {
        return obj -> g.apply((ListLabelingJobsForWorkteamRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListLabelingJobsForWorkteamRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.
         * </p>
         * 
         * @param workteamArn
         *        The Amazon Resource Name (ARN) of the work team for which you want to see labeling jobs for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workteamArn(String workteamArn);

        /**
         * <p>
         * The maximum number of labeling jobs to return in each page of the response.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of labeling jobs to return in each page of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the response
         * includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token in the next
         * request.
         * </p>
         * 
         * @param nextToken
         *        If the result of the previous <code>ListLabelingJobsForWorkteam</code> request was truncated, the
         *        response includes a <code>NextToken</code>. To retrieve the next set of labeling jobs, use the token
         *        in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter that returns only labeling jobs created after the specified time (timestamp).
         * </p>
         * 
         * @param creationTimeAfter
         *        A filter that returns only labeling jobs created after the specified time (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * A filter that returns only labeling jobs created before the specified time (timestamp).
         * </p>
         * 
         * @param creationTimeBefore
         *        A filter that returns only labeling jobs created before the specified time (timestamp).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * A filter the limits jobs to only the ones whose job reference code contains the specified string.
         * </p>
         * 
         * @param jobReferenceCodeContains
         *        A filter the limits jobs to only the ones whose job reference code contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobReferenceCodeContains(String jobReferenceCodeContains);

        /**
         * <p>
         * The field to sort results by. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>CreationTime</code>.
         * @see ListLabelingJobsForWorkteamSortByOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListLabelingJobsForWorkteamSortByOptions
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field to sort results by. The default is <code>CreationTime</code>.
         * </p>
         * 
         * @param sortBy
         *        The field to sort results by. The default is <code>CreationTime</code>.
         * @see ListLabelingJobsForWorkteamSortByOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListLabelingJobsForWorkteamSortByOptions
         */
        Builder sortBy(ListLabelingJobsForWorkteamSortByOptions sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>.
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String workteamArn;

        private Integer maxResults;

        private String nextToken;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private String jobReferenceCodeContains;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLabelingJobsForWorkteamRequest model) {
            super(model);
            workteamArn(model.workteamArn);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            jobReferenceCodeContains(model.jobReferenceCodeContains);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getWorkteamArn() {
            return workteamArn;
        }

        public final void setWorkteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
        }

        @Override
        public final Builder workteamArn(String workteamArn) {
            this.workteamArn = workteamArn;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final String getJobReferenceCodeContains() {
            return jobReferenceCodeContains;
        }

        public final void setJobReferenceCodeContains(String jobReferenceCodeContains) {
            this.jobReferenceCodeContains = jobReferenceCodeContains;
        }

        @Override
        public final Builder jobReferenceCodeContains(String jobReferenceCodeContains) {
            this.jobReferenceCodeContains = jobReferenceCodeContains;
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListLabelingJobsForWorkteamSortByOptions sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListLabelingJobsForWorkteamRequest build() {
            return new ListLabelingJobsForWorkteamRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
