/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelMetadataResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelMetadataResponse.Builder, ListModelMetadataResponse> {
    private static final SdkField<List<ModelMetadataSummary>> MODEL_METADATA_SUMMARIES_FIELD = SdkField
            .<List<ModelMetadataSummary>> builder(MarshallingType.LIST)
            .memberName("ModelMetadataSummaries")
            .getter(getter(ListModelMetadataResponse::modelMetadataSummaries))
            .setter(setter(Builder::modelMetadataSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelMetadataSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ModelMetadataSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ModelMetadataSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelMetadataResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MODEL_METADATA_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<ModelMetadataSummary> modelMetadataSummaries;

    private final String nextToken;

    private ListModelMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.modelMetadataSummaries = builder.modelMetadataSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ModelMetadataSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasModelMetadataSummaries() {
        return modelMetadataSummaries != null && !(modelMetadataSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that holds model metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasModelMetadataSummaries} method.
     * </p>
     * 
     * @return A structure that holds model metadata.
     */
    public final List<ModelMetadataSummary> modelMetadataSummaries() {
        return modelMetadataSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of recommendations, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of recommendations, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasModelMetadataSummaries() ? modelMetadataSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelMetadataResponse)) {
            return false;
        }
        ListModelMetadataResponse other = (ListModelMetadataResponse) obj;
        return hasModelMetadataSummaries() == other.hasModelMetadataSummaries()
                && Objects.equals(modelMetadataSummaries(), other.modelMetadataSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelMetadataResponse")
                .add("ModelMetadataSummaries", hasModelMetadataSummaries() ? modelMetadataSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelMetadataSummaries":
            return Optional.ofNullable(clazz.cast(modelMetadataSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelMetadataSummaries", MODEL_METADATA_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelMetadataResponse, T> g) {
        return obj -> g.apply((ListModelMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListModelMetadataResponse> {
        /**
         * <p>
         * A structure that holds model metadata.
         * </p>
         * 
         * @param modelMetadataSummaries
         *        A structure that holds model metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetadataSummaries(Collection<ModelMetadataSummary> modelMetadataSummaries);

        /**
         * <p>
         * A structure that holds model metadata.
         * </p>
         * 
         * @param modelMetadataSummaries
         *        A structure that holds model metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelMetadataSummaries(ModelMetadataSummary... modelMetadataSummaries);

        /**
         * <p>
         * A structure that holds model metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #modelMetadataSummaries(List<ModelMetadataSummary>)}.
         * 
         * @param modelMetadataSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.ModelMetadataSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #modelMetadataSummaries(java.util.Collection<ModelMetadataSummary>)
         */
        Builder modelMetadataSummaries(Consumer<ModelMetadataSummary.Builder>... modelMetadataSummaries);

        /**
         * <p>
         * A token for getting the next set of recommendations, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of recommendations, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<ModelMetadataSummary> modelMetadataSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelMetadataResponse model) {
            super(model);
            modelMetadataSummaries(model.modelMetadataSummaries);
            nextToken(model.nextToken);
        }

        public final List<ModelMetadataSummary.Builder> getModelMetadataSummaries() {
            List<ModelMetadataSummary.Builder> result = ModelMetadataSummariesCopier.copyToBuilder(this.modelMetadataSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelMetadataSummaries(Collection<ModelMetadataSummary.BuilderImpl> modelMetadataSummaries) {
            this.modelMetadataSummaries = ModelMetadataSummariesCopier.copyFromBuilder(modelMetadataSummaries);
        }

        @Override
        public final Builder modelMetadataSummaries(Collection<ModelMetadataSummary> modelMetadataSummaries) {
            this.modelMetadataSummaries = ModelMetadataSummariesCopier.copy(modelMetadataSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelMetadataSummaries(ModelMetadataSummary... modelMetadataSummaries) {
            modelMetadataSummaries(Arrays.asList(modelMetadataSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelMetadataSummaries(Consumer<ModelMetadataSummary.Builder>... modelMetadataSummaries) {
            modelMetadataSummaries(Stream.of(modelMetadataSummaries)
                    .map(c -> ModelMetadataSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListModelMetadataResponse build() {
            return new ListModelMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
