/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMonitoringAlertsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListMonitoringAlertsResponse.Builder, ListMonitoringAlertsResponse> {
    private static final SdkField<List<MonitoringAlertSummary>> MONITORING_ALERT_SUMMARIES_FIELD = SdkField
            .<List<MonitoringAlertSummary>> builder(MarshallingType.LIST)
            .memberName("MonitoringAlertSummaries")
            .getter(getter(ListMonitoringAlertsResponse::monitoringAlertSummaries))
            .setter(setter(Builder::monitoringAlertSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringAlertSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringAlertSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringAlertSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListMonitoringAlertsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MONITORING_ALERT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<MonitoringAlertSummary> monitoringAlertSummaries;

    private final String nextToken;

    private ListMonitoringAlertsResponse(BuilderImpl builder) {
        super(builder);
        this.monitoringAlertSummaries = builder.monitoringAlertSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the MonitoringAlertSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasMonitoringAlertSummaries() {
        return monitoringAlertSummaries != null && !(monitoringAlertSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON array where each element is a summary for a monitoring alert.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonitoringAlertSummaries} method.
     * </p>
     * 
     * @return A JSON array where each element is a summary for a monitoring alert.
     */
    public final List<MonitoringAlertSummary> monitoringAlertSummaries() {
        return monitoringAlertSummaries;
    }

    /**
     * <p>
     * If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the
     * subsequent request.
     * </p>
     * 
     * @return If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in
     *         the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMonitoringAlertSummaries() ? monitoringAlertSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMonitoringAlertsResponse)) {
            return false;
        }
        ListMonitoringAlertsResponse other = (ListMonitoringAlertsResponse) obj;
        return hasMonitoringAlertSummaries() == other.hasMonitoringAlertSummaries()
                && Objects.equals(monitoringAlertSummaries(), other.monitoringAlertSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListMonitoringAlertsResponse")
                .add("MonitoringAlertSummaries", hasMonitoringAlertSummaries() ? monitoringAlertSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MonitoringAlertSummaries":
            return Optional.ofNullable(clazz.cast(monitoringAlertSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MonitoringAlertSummaries", MONITORING_ALERT_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListMonitoringAlertsResponse, T> g) {
        return obj -> g.apply((ListMonitoringAlertsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMonitoringAlertsResponse> {
        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertSummaries
         *        A JSON array where each element is a summary for a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> monitoringAlertSummaries);

        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * 
         * @param monitoringAlertSummaries
         *        A JSON array where each element is a summary for a monitoring alert.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringAlertSummaries(MonitoringAlertSummary... monitoringAlertSummaries);

        /**
         * <p>
         * A JSON array where each element is a summary for a monitoring alert.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #monitoringAlertSummaries(List<MonitoringAlertSummary>)}.
         * 
         * @param monitoringAlertSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.MonitoringAlertSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #monitoringAlertSummaries(java.util.Collection<MonitoringAlertSummary>)
         */
        Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder>... monitoringAlertSummaries);

        /**
         * <p>
         * If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it in the
         * subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, SageMaker returns this token. To retrieve the next set of alerts, use it
         *        in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<MonitoringAlertSummary> monitoringAlertSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMonitoringAlertsResponse model) {
            super(model);
            monitoringAlertSummaries(model.monitoringAlertSummaries);
            nextToken(model.nextToken);
        }

        public final List<MonitoringAlertSummary.Builder> getMonitoringAlertSummaries() {
            List<MonitoringAlertSummary.Builder> result = MonitoringAlertSummaryListCopier
                    .copyToBuilder(this.monitoringAlertSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMonitoringAlertSummaries(Collection<MonitoringAlertSummary.BuilderImpl> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copyFromBuilder(monitoringAlertSummaries);
        }

        @Override
        public final Builder monitoringAlertSummaries(Collection<MonitoringAlertSummary> monitoringAlertSummaries) {
            this.monitoringAlertSummaries = MonitoringAlertSummaryListCopier.copy(monitoringAlertSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(MonitoringAlertSummary... monitoringAlertSummaries) {
            monitoringAlertSummaries(Arrays.asList(monitoringAlertSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder monitoringAlertSummaries(Consumer<MonitoringAlertSummary.Builder>... monitoringAlertSummaries) {
            monitoringAlertSummaries(Stream.of(monitoringAlertSummaries)
                    .map(c -> MonitoringAlertSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListMonitoringAlertsResponse build() {
            return new ListMonitoringAlertsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
