/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOptimizationJobsRequest extends SageMakerRequest implements
        ToCopyableBuilder<ListOptimizationJobsRequest.Builder, ListOptimizationJobsRequest> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOptimizationJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListOptimizationJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListOptimizationJobsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeAfter").build()).build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListOptimizationJobsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeAfter").getter(getter(ListOptimizationJobsRequest::lastModifiedTimeAfter))
            .setter(setter(Builder::lastModifiedTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeAfter").build())
            .build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTimeBefore").getter(getter(ListOptimizationJobsRequest::lastModifiedTimeBefore))
            .setter(setter(Builder::lastModifiedTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTimeBefore").build())
            .build();

    private static final SdkField<String> OPTIMIZATION_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OptimizationContains").getter(getter(ListOptimizationJobsRequest::optimizationContains))
            .setter(setter(Builder::optimizationContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptimizationContains").build())
            .build();

    private static final SdkField<String> NAME_CONTAINS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NameContains").getter(getter(ListOptimizationJobsRequest::nameContains))
            .setter(setter(Builder::nameContains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameContains").build()).build();

    private static final SdkField<String> STATUS_EQUALS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusEquals").getter(getter(ListOptimizationJobsRequest::statusEqualsAsString))
            .setter(setter(Builder::statusEquals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusEquals").build()).build();

    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(ListOptimizationJobsRequest::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListOptimizationJobsRequest::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            MAX_RESULTS_FIELD, CREATION_TIME_AFTER_FIELD, CREATION_TIME_BEFORE_FIELD, LAST_MODIFIED_TIME_AFTER_FIELD,
            LAST_MODIFIED_TIME_BEFORE_FIELD, OPTIMIZATION_CONTAINS_FIELD, NAME_CONTAINS_FIELD, STATUS_EQUALS_FIELD,
            SORT_BY_FIELD, SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final Integer maxResults;

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final Instant lastModifiedTimeAfter;

    private final Instant lastModifiedTimeBefore;

    private final String optimizationContains;

    private final String nameContains;

    private final String statusEquals;

    private final String sortBy;

    private final String sortOrder;

    private ListOptimizationJobsRequest(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.lastModifiedTimeAfter = builder.lastModifiedTimeAfter;
        this.lastModifiedTimeBefore = builder.lastModifiedTimeBefore;
        this.optimizationContains = builder.optimizationContains;
        this.nameContains = builder.nameContains;
        this.statusEquals = builder.statusEquals;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * A token that you use to get the next set of results following a truncated response. If the response to the
     * previous request was truncated, that response provides the value for this token.
     * </p>
     * 
     * @return A token that you use to get the next set of results following a truncated response. If the response to
     *         the previous request was truncated, that response provides the value for this token.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of optimization jobs to return in the response. The default is 50.
     * </p>
     * 
     * @return The maximum number of optimization jobs to return in the response. The default is 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs that were created after the specified time.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs that were created after the specified time.
     */
    public final Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs that were created before the specified time.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs that were created before the specified time.
     */
    public final Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs that were updated after the specified time.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs that were updated after the specified time.
     */
    public final Instant lastModifiedTimeAfter() {
        return lastModifiedTimeAfter;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs that were updated before the specified time.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs that were updated before the specified time.
     */
    public final Instant lastModifiedTimeBefore() {
        return lastModifiedTimeBefore;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs that apply the specified optimization techniques. You can
     * specify either <code>Quantization</code> or <code>Compilation</code>.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs that apply the specified optimization techniques. You
     *         can specify either <code>Quantization</code> or <code>Compilation</code>.
     */
    public final String optimizationContains() {
        return optimizationContains;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs with a name that contains the specified string.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs with a name that contains the specified string.
     */
    public final String nameContains() {
        return nameContains;
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs with the specified status.
     * @see OptimizationJobStatus
     */
    public final OptimizationJobStatus statusEquals() {
        return OptimizationJobStatus.fromValue(statusEquals);
    }

    /**
     * <p>
     * Filters the results to only those optimization jobs with the specified status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #statusEquals} will
     * return {@link OptimizationJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusEqualsAsString}.
     * </p>
     * 
     * @return Filters the results to only those optimization jobs with the specified status.
     * @see OptimizationJobStatus
     */
    public final String statusEqualsAsString() {
        return statusEquals;
    }

    /**
     * <p>
     * The field by which to sort the optimization jobs in the response. The default is <code>CreationTime</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListOptimizationJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort the optimization jobs in the response. The default is
     *         <code>CreationTime</code>
     * @see ListOptimizationJobsSortBy
     */
    public final ListOptimizationJobsSortBy sortBy() {
        return ListOptimizationJobsSortBy.fromValue(sortBy);
    }

    /**
     * <p>
     * The field by which to sort the optimization jobs in the response. The default is <code>CreationTime</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link ListOptimizationJobsSortBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #sortByAsString}.
     * </p>
     * 
     * @return The field by which to sort the optimization jobs in the response. The default is
     *         <code>CreationTime</code>
     * @see ListOptimizationJobsSortBy
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * The sort order for results. The default is <code>Ascending</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return The sort order for results. The default is <code>Ascending</code>
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(optimizationContains());
        hashCode = 31 * hashCode + Objects.hashCode(nameContains());
        hashCode = 31 * hashCode + Objects.hashCode(statusEqualsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOptimizationJobsRequest)) {
            return false;
        }
        ListOptimizationJobsRequest other = (ListOptimizationJobsRequest) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(lastModifiedTimeAfter(), other.lastModifiedTimeAfter())
                && Objects.equals(lastModifiedTimeBefore(), other.lastModifiedTimeBefore())
                && Objects.equals(optimizationContains(), other.optimizationContains())
                && Objects.equals(nameContains(), other.nameContains())
                && Objects.equals(statusEqualsAsString(), other.statusEqualsAsString())
                && Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOptimizationJobsRequest").add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("CreationTimeAfter", creationTimeAfter()).add("CreationTimeBefore", creationTimeBefore())
                .add("LastModifiedTimeAfter", lastModifiedTimeAfter()).add("LastModifiedTimeBefore", lastModifiedTimeBefore())
                .add("OptimizationContains", optimizationContains()).add("NameContains", nameContains())
                .add("StatusEquals", statusEqualsAsString()).add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "LastModifiedTimeAfter":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeAfter()));
        case "LastModifiedTimeBefore":
            return Optional.ofNullable(clazz.cast(lastModifiedTimeBefore()));
        case "OptimizationContains":
            return Optional.ofNullable(clazz.cast(optimizationContains()));
        case "NameContains":
            return Optional.ofNullable(clazz.cast(nameContains()));
        case "StatusEquals":
            return Optional.ofNullable(clazz.cast(statusEqualsAsString()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("CreationTimeAfter", CREATION_TIME_AFTER_FIELD);
        map.put("CreationTimeBefore", CREATION_TIME_BEFORE_FIELD);
        map.put("LastModifiedTimeAfter", LAST_MODIFIED_TIME_AFTER_FIELD);
        map.put("LastModifiedTimeBefore", LAST_MODIFIED_TIME_BEFORE_FIELD);
        map.put("OptimizationContains", OPTIMIZATION_CONTAINS_FIELD);
        map.put("NameContains", NAME_CONTAINS_FIELD);
        map.put("StatusEquals", STATUS_EQUALS_FIELD);
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOptimizationJobsRequest, T> g) {
        return obj -> g.apply((ListOptimizationJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListOptimizationJobsRequest> {
        /**
         * <p>
         * A token that you use to get the next set of results following a truncated response. If the response to the
         * previous request was truncated, that response provides the value for this token.
         * </p>
         * 
         * @param nextToken
         *        A token that you use to get the next set of results following a truncated response. If the response to
         *        the previous request was truncated, that response provides the value for this token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of optimization jobs to return in the response. The default is 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of optimization jobs to return in the response. The default is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Filters the results to only those optimization jobs that were created after the specified time.
         * </p>
         * 
         * @param creationTimeAfter
         *        Filters the results to only those optimization jobs that were created after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * Filters the results to only those optimization jobs that were created before the specified time.
         * </p>
         * 
         * @param creationTimeBefore
         *        Filters the results to only those optimization jobs that were created before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * Filters the results to only those optimization jobs that were updated after the specified time.
         * </p>
         * 
         * @param lastModifiedTimeAfter
         *        Filters the results to only those optimization jobs that were updated after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter);

        /**
         * <p>
         * Filters the results to only those optimization jobs that were updated before the specified time.
         * </p>
         * 
         * @param lastModifiedTimeBefore
         *        Filters the results to only those optimization jobs that were updated before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore);

        /**
         * <p>
         * Filters the results to only those optimization jobs that apply the specified optimization techniques. You can
         * specify either <code>Quantization</code> or <code>Compilation</code>.
         * </p>
         * 
         * @param optimizationContains
         *        Filters the results to only those optimization jobs that apply the specified optimization techniques.
         *        You can specify either <code>Quantization</code> or <code>Compilation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optimizationContains(String optimizationContains);

        /**
         * <p>
         * Filters the results to only those optimization jobs with a name that contains the specified string.
         * </p>
         * 
         * @param nameContains
         *        Filters the results to only those optimization jobs with a name that contains the specified string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nameContains(String nameContains);

        /**
         * <p>
         * Filters the results to only those optimization jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Filters the results to only those optimization jobs with the specified status.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder statusEquals(String statusEquals);

        /**
         * <p>
         * Filters the results to only those optimization jobs with the specified status.
         * </p>
         * 
         * @param statusEquals
         *        Filters the results to only those optimization jobs with the specified status.
         * @see OptimizationJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptimizationJobStatus
         */
        Builder statusEquals(OptimizationJobStatus statusEquals);

        /**
         * <p>
         * The field by which to sort the optimization jobs in the response. The default is <code>CreationTime</code>
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort the optimization jobs in the response. The default is
         *        <code>CreationTime</code>
         * @see ListOptimizationJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListOptimizationJobsSortBy
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * The field by which to sort the optimization jobs in the response. The default is <code>CreationTime</code>
         * </p>
         * 
         * @param sortBy
         *        The field by which to sort the optimization jobs in the response. The default is
         *        <code>CreationTime</code>
         * @see ListOptimizationJobsSortBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ListOptimizationJobsSortBy
         */
        Builder sortBy(ListOptimizationJobsSortBy sortBy);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * The sort order for results. The default is <code>Ascending</code>
         * </p>
         * 
         * @param sortOrder
         *        The sort order for results. The default is <code>Ascending</code>
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String nextToken;

        private Integer maxResults;

        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private Instant lastModifiedTimeAfter;

        private Instant lastModifiedTimeBefore;

        private String optimizationContains;

        private String nameContains;

        private String statusEquals;

        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOptimizationJobsRequest model) {
            super(model);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            lastModifiedTimeAfter(model.lastModifiedTimeAfter);
            lastModifiedTimeBefore(model.lastModifiedTimeBefore);
            optimizationContains(model.optimizationContains);
            nameContains(model.nameContains);
            statusEquals(model.statusEquals);
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final Instant getLastModifiedTimeAfter() {
            return lastModifiedTimeAfter;
        }

        public final void setLastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
        }

        @Override
        public final Builder lastModifiedTimeAfter(Instant lastModifiedTimeAfter) {
            this.lastModifiedTimeAfter = lastModifiedTimeAfter;
            return this;
        }

        public final Instant getLastModifiedTimeBefore() {
            return lastModifiedTimeBefore;
        }

        public final void setLastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
        }

        @Override
        public final Builder lastModifiedTimeBefore(Instant lastModifiedTimeBefore) {
            this.lastModifiedTimeBefore = lastModifiedTimeBefore;
            return this;
        }

        public final String getOptimizationContains() {
            return optimizationContains;
        }

        public final void setOptimizationContains(String optimizationContains) {
            this.optimizationContains = optimizationContains;
        }

        @Override
        public final Builder optimizationContains(String optimizationContains) {
            this.optimizationContains = optimizationContains;
            return this;
        }

        public final String getNameContains() {
            return nameContains;
        }

        public final void setNameContains(String nameContains) {
            this.nameContains = nameContains;
        }

        @Override
        public final Builder nameContains(String nameContains) {
            this.nameContains = nameContains;
            return this;
        }

        public final String getStatusEquals() {
            return statusEquals;
        }

        public final void setStatusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
        }

        @Override
        public final Builder statusEquals(String statusEquals) {
            this.statusEquals = statusEquals;
            return this;
        }

        @Override
        public final Builder statusEquals(OptimizationJobStatus statusEquals) {
            this.statusEquals(statusEquals == null ? null : statusEquals.toString());
            return this;
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(ListOptimizationJobsSortBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOptimizationJobsRequest build() {
            return new ListOptimizationJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
