/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTrialsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListTrialsResponse.Builder, ListTrialsResponse> {
    private static final SdkField<List<TrialSummary>> TRIAL_SUMMARIES_FIELD = SdkField
            .<List<TrialSummary>> builder(MarshallingType.LIST)
            .memberName("TrialSummaries")
            .getter(getter(ListTrialsResponse::trialSummaries))
            .setter(setter(Builder::trialSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TrialSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TrialSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTrialsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRIAL_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TrialSummary> trialSummaries;

    private final String nextToken;

    private ListTrialsResponse(BuilderImpl builder) {
        super(builder);
        this.trialSummaries = builder.trialSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TrialSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTrialSummaries() {
        return trialSummaries != null && !(trialSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the summaries of your trials.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTrialSummaries} method.
     * </p>
     * 
     * @return A list of the summaries of your trials.
     */
    public final List<TrialSummary> trialSummaries() {
        return trialSummaries;
    }

    /**
     * <p>
     * A token for getting the next set of trials, if there are any.
     * </p>
     * 
     * @return A token for getting the next set of trials, if there are any.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTrialSummaries() ? trialSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialsResponse)) {
            return false;
        }
        ListTrialsResponse other = (ListTrialsResponse) obj;
        return hasTrialSummaries() == other.hasTrialSummaries() && Objects.equals(trialSummaries(), other.trialSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTrialsResponse").add("TrialSummaries", hasTrialSummaries() ? trialSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TrialSummaries":
            return Optional.ofNullable(clazz.cast(trialSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TrialSummaries", TRIAL_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTrialsResponse, T> g) {
        return obj -> g.apply((ListTrialsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTrialsResponse> {
        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * 
         * @param trialSummaries
         *        A list of the summaries of your trials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialSummaries(Collection<TrialSummary> trialSummaries);

        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * 
         * @param trialSummaries
         *        A list of the summaries of your trials.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trialSummaries(TrialSummary... trialSummaries);

        /**
         * <p>
         * A list of the summaries of your trials.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.sagemaker.model.TrialSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.sagemaker.model.TrialSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #trialSummaries(List<TrialSummary>)}.
         * 
         * @param trialSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.sagemaker.model.TrialSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trialSummaries(java.util.Collection<TrialSummary>)
         */
        Builder trialSummaries(Consumer<TrialSummary.Builder>... trialSummaries);

        /**
         * <p>
         * A token for getting the next set of trials, if there are any.
         * </p>
         * 
         * @param nextToken
         *        A token for getting the next set of trials, if there are any.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<TrialSummary> trialSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialsResponse model) {
            super(model);
            trialSummaries(model.trialSummaries);
            nextToken(model.nextToken);
        }

        public final List<TrialSummary.Builder> getTrialSummaries() {
            List<TrialSummary.Builder> result = TrialSummariesCopier.copyToBuilder(this.trialSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTrialSummaries(Collection<TrialSummary.BuilderImpl> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copyFromBuilder(trialSummaries);
        }

        @Override
        public final Builder trialSummaries(Collection<TrialSummary> trialSummaries) {
            this.trialSummaries = TrialSummariesCopier.copy(trialSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(TrialSummary... trialSummaries) {
            trialSummaries(Arrays.asList(trialSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trialSummaries(Consumer<TrialSummary.Builder>... trialSummaries) {
            trialSummaries(Stream.of(trialSummaries).map(c -> TrialSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTrialsResponse build() {
            return new ListTrialsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
