/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object containing information about a metric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricSpecification implements SdkPojo, Serializable,
        ToCopyableBuilder<MetricSpecification.Builder, MetricSpecification> {
    private static final SdkField<PredefinedMetricSpecification> PREDEFINED_FIELD = SdkField
            .<PredefinedMetricSpecification> builder(MarshallingType.SDK_POJO).memberName("Predefined")
            .getter(getter(MetricSpecification::predefined)).setter(setter(Builder::predefined))
            .constructor(PredefinedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Predefined").build()).build();

    private static final SdkField<CustomizedMetricSpecification> CUSTOMIZED_FIELD = SdkField
            .<CustomizedMetricSpecification> builder(MarshallingType.SDK_POJO).memberName("Customized")
            .getter(getter(MetricSpecification::customized)).setter(setter(Builder::customized))
            .constructor(CustomizedMetricSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREDEFINED_FIELD,
            CUSTOMIZED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PredefinedMetricSpecification predefined;

    private final CustomizedMetricSpecification customized;

    private final Type type;

    private MetricSpecification(BuilderImpl builder) {
        this.predefined = builder.predefined;
        this.customized = builder.customized;
        this.type = builder.type;
    }

    /**
     * <p>
     * Information about a predefined metric.
     * </p>
     * 
     * @return Information about a predefined metric.
     */
    public final PredefinedMetricSpecification predefined() {
        return predefined;
    }

    /**
     * <p>
     * Information about a customized metric.
     * </p>
     * 
     * @return Information about a customized metric.
     */
    public final CustomizedMetricSpecification customized() {
        return customized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(predefined());
        hashCode = 31 * hashCode + Objects.hashCode(customized());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricSpecification)) {
            return false;
        }
        MetricSpecification other = (MetricSpecification) obj;
        return Objects.equals(predefined(), other.predefined()) && Objects.equals(customized(), other.customized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricSpecification").add("Predefined", predefined()).add("Customized", customized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Predefined":
            return Optional.ofNullable(clazz.cast(predefined()));
        case "Customized":
            return Optional.ofNullable(clazz.cast(customized()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #predefined()} initialized to the given value.
     *
     * <p>
     * Information about a predefined metric.
     * </p>
     * 
     * @param predefined
     *        Information about a predefined metric.
     */
    public static MetricSpecification fromPredefined(PredefinedMetricSpecification predefined) {
        return builder().predefined(predefined).build();
    }

    /**
     * Create an instance of this class with {@link #predefined()} initialized to the given value.
     *
     * <p>
     * Information about a predefined metric.
     * </p>
     * 
     * @param predefined
     *        Information about a predefined metric.
     */
    public static MetricSpecification fromPredefined(Consumer<PredefinedMetricSpecification.Builder> predefined) {
        PredefinedMetricSpecification.Builder builder = PredefinedMetricSpecification.builder();
        predefined.accept(builder);
        return fromPredefined(builder.build());
    }

    /**
     * Create an instance of this class with {@link #customized()} initialized to the given value.
     *
     * <p>
     * Information about a customized metric.
     * </p>
     * 
     * @param customized
     *        Information about a customized metric.
     */
    public static MetricSpecification fromCustomized(CustomizedMetricSpecification customized) {
        return builder().customized(customized).build();
    }

    /**
     * Create an instance of this class with {@link #customized()} initialized to the given value.
     *
     * <p>
     * Information about a customized metric.
     * </p>
     * 
     * @param customized
     *        Information about a customized metric.
     */
    public static MetricSpecification fromCustomized(Consumer<CustomizedMetricSpecification.Builder> customized) {
        CustomizedMetricSpecification.Builder builder = CustomizedMetricSpecification.builder();
        customized.accept(builder);
        return fromCustomized(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Predefined", PREDEFINED_FIELD);
        map.put("Customized", CUSTOMIZED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricSpecification, T> g) {
        return obj -> g.apply((MetricSpecification) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricSpecification> {
        /**
         * <p>
         * Information about a predefined metric.
         * </p>
         * 
         * @param predefined
         *        Information about a predefined metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder predefined(PredefinedMetricSpecification predefined);

        /**
         * <p>
         * Information about a predefined metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link PredefinedMetricSpecification.Builder}
         * avoiding the need to create one manually via {@link PredefinedMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PredefinedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #predefined(PredefinedMetricSpecification)}.
         * 
         * @param predefined
         *        a consumer that will call methods on {@link PredefinedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #predefined(PredefinedMetricSpecification)
         */
        default Builder predefined(Consumer<PredefinedMetricSpecification.Builder> predefined) {
            return predefined(PredefinedMetricSpecification.builder().applyMutation(predefined).build());
        }

        /**
         * <p>
         * Information about a customized metric.
         * </p>
         * 
         * @param customized
         *        Information about a customized metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customized(CustomizedMetricSpecification customized);

        /**
         * <p>
         * Information about a customized metric.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomizedMetricSpecification.Builder}
         * avoiding the need to create one manually via {@link CustomizedMetricSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomizedMetricSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #customized(CustomizedMetricSpecification)}.
         * 
         * @param customized
         *        a consumer that will call methods on {@link CustomizedMetricSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customized(CustomizedMetricSpecification)
         */
        default Builder customized(Consumer<CustomizedMetricSpecification.Builder> customized) {
            return customized(CustomizedMetricSpecification.builder().applyMutation(customized).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private PredefinedMetricSpecification predefined;

        private CustomizedMetricSpecification customized;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MetricSpecification model) {
            predefined(model.predefined);
            customized(model.customized);
        }

        public final PredefinedMetricSpecification.Builder getPredefined() {
            return predefined != null ? predefined.toBuilder() : null;
        }

        public final void setPredefined(PredefinedMetricSpecification.BuilderImpl predefined) {
            Object oldValue = this.predefined;
            this.predefined = predefined != null ? predefined.build() : null;
            handleUnionValueChange(Type.PREDEFINED, oldValue, this.predefined);
        }

        @Override
        public final Builder predefined(PredefinedMetricSpecification predefined) {
            Object oldValue = this.predefined;
            this.predefined = predefined;
            handleUnionValueChange(Type.PREDEFINED, oldValue, this.predefined);
            return this;
        }

        public final CustomizedMetricSpecification.Builder getCustomized() {
            return customized != null ? customized.toBuilder() : null;
        }

        public final void setCustomized(CustomizedMetricSpecification.BuilderImpl customized) {
            Object oldValue = this.customized;
            this.customized = customized != null ? customized.build() : null;
            handleUnionValueChange(Type.CUSTOMIZED, oldValue, this.customized);
        }

        @Override
        public final Builder customized(CustomizedMetricSpecification customized) {
            Object oldValue = this.customized;
            this.customized = customized;
            handleUnionValueChange(Type.CUSTOMIZED, oldValue, this.customized);
            return this;
        }

        @Override
        public MetricSpecification build() {
            return new MetricSpecification(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MetricSpecification#type()
     */
    public enum Type {
        PREDEFINED,

        CUSTOMIZED,

        UNKNOWN_TO_SDK_VERSION
    }
}
