/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of the model card.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelCardSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelCardSummary.Builder, ModelCardSummary> {
    private static final SdkField<String> MODEL_CARD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardName").getter(getter(ModelCardSummary::modelCardName)).setter(setter(Builder::modelCardName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardName").build()).build();

    private static final SdkField<String> MODEL_CARD_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardArn").getter(getter(ModelCardSummary::modelCardArn)).setter(setter(Builder::modelCardArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardArn").build()).build();

    private static final SdkField<String> MODEL_CARD_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ModelCardStatus").getter(getter(ModelCardSummary::modelCardStatusAsString))
            .setter(setter(Builder::modelCardStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelCardStatus").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelCardSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ModelCardSummary::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_CARD_NAME_FIELD,
            MODEL_CARD_ARN_FIELD, MODEL_CARD_STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelCardName;

    private final String modelCardArn;

    private final String modelCardStatus;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private ModelCardSummary(BuilderImpl builder) {
        this.modelCardName = builder.modelCardName;
        this.modelCardArn = builder.modelCardArn;
        this.modelCardStatus = builder.modelCardStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    /**
     * <p>
     * The name of the model card.
     * </p>
     * 
     * @return The name of the model card.
     */
    public final String modelCardName() {
        return modelCardName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the model card.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the model card.
     */
    public final String modelCardArn() {
        return modelCardArn;
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final ModelCardStatus modelCardStatus() {
        return ModelCardStatus.fromValue(modelCardStatus);
    }

    /**
     * <p>
     * The approval status of the model card within your organization. Different organizations might have different
     * criteria for model card review and approval.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Draft</code>: The model card is a work in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PendingReview</code>: The model card is pending review.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Approved</code>: The model card is approved.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it can
     * still be exported.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #modelCardStatus}
     * will return {@link ModelCardStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #modelCardStatusAsString}.
     * </p>
     * 
     * @return The approval status of the model card within your organization. Different organizations might have
     *         different criteria for model card review and approval.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Draft</code>: The model card is a work in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PendingReview</code>: The model card is pending review.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Approved</code>: The model card is approved.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but
     *         it can still be exported.
     *         </p>
     *         </li>
     * @see ModelCardStatus
     */
    public final String modelCardStatusAsString() {
        return modelCardStatus;
    }

    /**
     * <p>
     * The date and time that the model card was created.
     * </p>
     * 
     * @return The date and time that the model card was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time that the model card was last modified.
     * </p>
     * 
     * @return The date and time that the model card was last modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelCardName());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelCardStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelCardSummary)) {
            return false;
        }
        ModelCardSummary other = (ModelCardSummary) obj;
        return Objects.equals(modelCardName(), other.modelCardName()) && Objects.equals(modelCardArn(), other.modelCardArn())
                && Objects.equals(modelCardStatusAsString(), other.modelCardStatusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelCardSummary").add("ModelCardName", modelCardName()).add("ModelCardArn", modelCardArn())
                .add("ModelCardStatus", modelCardStatusAsString()).add("CreationTime", creationTime())
                .add("LastModifiedTime", lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ModelCardName":
            return Optional.ofNullable(clazz.cast(modelCardName()));
        case "ModelCardArn":
            return Optional.ofNullable(clazz.cast(modelCardArn()));
        case "ModelCardStatus":
            return Optional.ofNullable(clazz.cast(modelCardStatusAsString()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ModelCardName", MODEL_CARD_NAME_FIELD);
        map.put("ModelCardArn", MODEL_CARD_ARN_FIELD);
        map.put("ModelCardStatus", MODEL_CARD_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelCardSummary, T> g) {
        return obj -> g.apply((ModelCardSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelCardSummary> {
        /**
         * <p>
         * The name of the model card.
         * </p>
         * 
         * @param modelCardName
         *        The name of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardName(String modelCardName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the model card.
         * </p>
         * 
         * @param modelCardArn
         *        The Amazon Resource Name (ARN) of the model card.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelCardArn(String modelCardArn);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(String modelCardStatus);

        /**
         * <p>
         * The approval status of the model card within your organization. Different organizations might have different
         * criteria for model card review and approval.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Draft</code>: The model card is a work in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PendingReview</code>: The model card is pending review.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Approved</code>: The model card is approved.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Archived</code>: The model card is archived. No more updates should be made to the model card, but it
         * can still be exported.
         * </p>
         * </li>
         * </ul>
         * 
         * @param modelCardStatus
         *        The approval status of the model card within your organization. Different organizations might have
         *        different criteria for model card review and approval.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Draft</code>: The model card is a work in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PendingReview</code>: The model card is pending review.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Approved</code>: The model card is approved.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Archived</code>: The model card is archived. No more updates should be made to the model card,
         *        but it can still be exported.
         *        </p>
         *        </li>
         * @see ModelCardStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelCardStatus
         */
        Builder modelCardStatus(ModelCardStatus modelCardStatus);

        /**
         * <p>
         * The date and time that the model card was created.
         * </p>
         * 
         * @param creationTime
         *        The date and time that the model card was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time that the model card was last modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The date and time that the model card was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);
    }

    static final class BuilderImpl implements Builder {
        private String modelCardName;

        private String modelCardArn;

        private String modelCardStatus;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelCardSummary model) {
            modelCardName(model.modelCardName);
            modelCardArn(model.modelCardArn);
            modelCardStatus(model.modelCardStatus);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
        }

        public final String getModelCardName() {
            return modelCardName;
        }

        public final void setModelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
        }

        @Override
        public final Builder modelCardName(String modelCardName) {
            this.modelCardName = modelCardName;
            return this;
        }

        public final String getModelCardArn() {
            return modelCardArn;
        }

        public final void setModelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
        }

        @Override
        public final Builder modelCardArn(String modelCardArn) {
            this.modelCardArn = modelCardArn;
            return this;
        }

        public final String getModelCardStatus() {
            return modelCardStatus;
        }

        public final void setModelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
        }

        @Override
        public final Builder modelCardStatus(String modelCardStatus) {
            this.modelCardStatus = modelCardStatus;
            return this;
        }

        @Override
        public final Builder modelCardStatus(ModelCardStatus modelCardStatus) {
            this.modelCardStatus(modelCardStatus == null ? null : modelCardStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        @Override
        public ModelCardSummary build() {
            return new ModelCardSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
