/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configures the timeout and maximum number of retries for processing a transform job invocation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelClientConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelClientConfig.Builder, ModelClientConfig> {
    private static final SdkField<Integer> INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvocationsTimeoutInSeconds")
            .getter(getter(ModelClientConfig::invocationsTimeoutInSeconds))
            .setter(setter(Builder::invocationsTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<Integer> INVOCATIONS_MAX_RETRIES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("InvocationsMaxRetries").getter(getter(ModelClientConfig::invocationsMaxRetries))
            .setter(setter(Builder::invocationsMaxRetries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationsMaxRetries").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD, INVOCATIONS_MAX_RETRIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer invocationsTimeoutInSeconds;

    private final Integer invocationsMaxRetries;

    private ModelClientConfig(BuilderImpl builder) {
        this.invocationsTimeoutInSeconds = builder.invocationsTimeoutInSeconds;
        this.invocationsMaxRetries = builder.invocationsMaxRetries;
    }

    /**
     * <p>
     * The timeout value in seconds for an invocation request. The default value is 600.
     * </p>
     * 
     * @return The timeout value in seconds for an invocation request. The default value is 600.
     */
    public final Integer invocationsTimeoutInSeconds() {
        return invocationsTimeoutInSeconds;
    }

    /**
     * <p>
     * The maximum number of retries when invocation requests are failing. The default value is 3.
     * </p>
     * 
     * @return The maximum number of retries when invocation requests are failing. The default value is 3.
     */
    public final Integer invocationsMaxRetries() {
        return invocationsMaxRetries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(invocationsTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(invocationsMaxRetries());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelClientConfig)) {
            return false;
        }
        ModelClientConfig other = (ModelClientConfig) obj;
        return Objects.equals(invocationsTimeoutInSeconds(), other.invocationsTimeoutInSeconds())
                && Objects.equals(invocationsMaxRetries(), other.invocationsMaxRetries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelClientConfig").add("InvocationsTimeoutInSeconds", invocationsTimeoutInSeconds())
                .add("InvocationsMaxRetries", invocationsMaxRetries()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InvocationsTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(invocationsTimeoutInSeconds()));
        case "InvocationsMaxRetries":
            return Optional.ofNullable(clazz.cast(invocationsMaxRetries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InvocationsTimeoutInSeconds", INVOCATIONS_TIMEOUT_IN_SECONDS_FIELD);
        map.put("InvocationsMaxRetries", INVOCATIONS_MAX_RETRIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelClientConfig, T> g) {
        return obj -> g.apply((ModelClientConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelClientConfig> {
        /**
         * <p>
         * The timeout value in seconds for an invocation request. The default value is 600.
         * </p>
         * 
         * @param invocationsTimeoutInSeconds
         *        The timeout value in seconds for an invocation request. The default value is 600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationsTimeoutInSeconds(Integer invocationsTimeoutInSeconds);

        /**
         * <p>
         * The maximum number of retries when invocation requests are failing. The default value is 3.
         * </p>
         * 
         * @param invocationsMaxRetries
         *        The maximum number of retries when invocation requests are failing. The default value is 3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationsMaxRetries(Integer invocationsMaxRetries);
    }

    static final class BuilderImpl implements Builder {
        private Integer invocationsTimeoutInSeconds;

        private Integer invocationsMaxRetries;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelClientConfig model) {
            invocationsTimeoutInSeconds(model.invocationsTimeoutInSeconds);
            invocationsMaxRetries(model.invocationsMaxRetries);
        }

        public final Integer getInvocationsTimeoutInSeconds() {
            return invocationsTimeoutInSeconds;
        }

        public final void setInvocationsTimeoutInSeconds(Integer invocationsTimeoutInSeconds) {
            this.invocationsTimeoutInSeconds = invocationsTimeoutInSeconds;
        }

        @Override
        public final Builder invocationsTimeoutInSeconds(Integer invocationsTimeoutInSeconds) {
            this.invocationsTimeoutInSeconds = invocationsTimeoutInSeconds;
            return this;
        }

        public final Integer getInvocationsMaxRetries() {
            return invocationsMaxRetries;
        }

        public final void setInvocationsMaxRetries(Integer invocationsMaxRetries) {
            this.invocationsMaxRetries = invocationsMaxRetries;
        }

        @Override
        public final Builder invocationsMaxRetries(Integer invocationsMaxRetries) {
            this.invocationsMaxRetries = invocationsMaxRetries;
            return this;
        }

        @Override
        public ModelClientConfig build() {
            return new ModelClientConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
