/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An endpoint that hosts a model displayed in the Amazon SageMaker Model Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelDashboardEndpoint implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelDashboardEndpoint.Builder, ModelDashboardEndpoint> {
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointName").getter(getter(ModelDashboardEndpoint::endpointName))
            .setter(setter(Builder::endpointName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()).build();

    private static final SdkField<String> ENDPOINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointArn").getter(getter(ModelDashboardEndpoint::endpointArn)).setter(setter(Builder::endpointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(ModelDashboardEndpoint::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedTime").getter(getter(ModelDashboardEndpoint::lastModifiedTime))
            .setter(setter(Builder::lastModifiedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()).build();

    private static final SdkField<String> ENDPOINT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndpointStatus").getter(getter(ModelDashboardEndpoint::endpointStatusAsString))
            .setter(setter(Builder::endpointStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENDPOINT_NAME_FIELD,
            ENDPOINT_ARN_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, ENDPOINT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String endpointName;

    private final String endpointArn;

    private final Instant creationTime;

    private final Instant lastModifiedTime;

    private final String endpointStatus;

    private ModelDashboardEndpoint(BuilderImpl builder) {
        this.endpointName = builder.endpointName;
        this.endpointArn = builder.endpointArn;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.endpointStatus = builder.endpointStatus;
    }

    /**
     * <p>
     * The endpoint name.
     * </p>
     * 
     * @return The endpoint name.
     */
    public final String endpointName() {
        return endpointName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the endpoint.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the endpoint.
     */
    public final String endpointArn() {
        return endpointArn;
    }

    /**
     * <p>
     * A timestamp that indicates when the endpoint was created.
     * </p>
     * 
     * @return A timestamp that indicates when the endpoint was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last time the endpoint was modified.
     * </p>
     * 
     * @return The last time the endpoint was modified.
     */
    public final Instant lastModifiedTime() {
        return lastModifiedTime;
    }

    /**
     * <p>
     * The endpoint status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The endpoint status.
     * @see EndpointStatus
     */
    public final EndpointStatus endpointStatus() {
        return EndpointStatus.fromValue(endpointStatus);
    }

    /**
     * <p>
     * The endpoint status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #endpointStatus}
     * will return {@link EndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #endpointStatusAsString}.
     * </p>
     * 
     * @return The endpoint status.
     * @see EndpointStatus
     */
    public final String endpointStatusAsString() {
        return endpointStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(endpointArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(endpointStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelDashboardEndpoint)) {
            return false;
        }
        ModelDashboardEndpoint other = (ModelDashboardEndpoint) obj;
        return Objects.equals(endpointName(), other.endpointName()) && Objects.equals(endpointArn(), other.endpointArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastModifiedTime(), other.lastModifiedTime())
                && Objects.equals(endpointStatusAsString(), other.endpointStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelDashboardEndpoint").add("EndpointName", endpointName()).add("EndpointArn", endpointArn())
                .add("CreationTime", creationTime()).add("LastModifiedTime", lastModifiedTime())
                .add("EndpointStatus", endpointStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EndpointName":
            return Optional.ofNullable(clazz.cast(endpointName()));
        case "EndpointArn":
            return Optional.ofNullable(clazz.cast(endpointArn()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastModifiedTime":
            return Optional.ofNullable(clazz.cast(lastModifiedTime()));
        case "EndpointStatus":
            return Optional.ofNullable(clazz.cast(endpointStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EndpointName", ENDPOINT_NAME_FIELD);
        map.put("EndpointArn", ENDPOINT_ARN_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        map.put("EndpointStatus", ENDPOINT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelDashboardEndpoint, T> g) {
        return obj -> g.apply((ModelDashboardEndpoint) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelDashboardEndpoint> {
        /**
         * <p>
         * The endpoint name.
         * </p>
         * 
         * @param endpointName
         *        The endpoint name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointName(String endpointName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the endpoint.
         * </p>
         * 
         * @param endpointArn
         *        The Amazon Resource Name (ARN) of the endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointArn(String endpointArn);

        /**
         * <p>
         * A timestamp that indicates when the endpoint was created.
         * </p>
         * 
         * @param creationTime
         *        A timestamp that indicates when the endpoint was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last time the endpoint was modified.
         * </p>
         * 
         * @param lastModifiedTime
         *        The last time the endpoint was modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedTime(Instant lastModifiedTime);

        /**
         * <p>
         * The endpoint status.
         * </p>
         * 
         * @param endpointStatus
         *        The endpoint status.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(String endpointStatus);

        /**
         * <p>
         * The endpoint status.
         * </p>
         * 
         * @param endpointStatus
         *        The endpoint status.
         * @see EndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EndpointStatus
         */
        Builder endpointStatus(EndpointStatus endpointStatus);
    }

    static final class BuilderImpl implements Builder {
        private String endpointName;

        private String endpointArn;

        private Instant creationTime;

        private Instant lastModifiedTime;

        private String endpointStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelDashboardEndpoint model) {
            endpointName(model.endpointName);
            endpointArn(model.endpointArn);
            creationTime(model.creationTime);
            lastModifiedTime(model.lastModifiedTime);
            endpointStatus(model.endpointStatus);
        }

        public final String getEndpointName() {
            return endpointName;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final String getEndpointArn() {
            return endpointArn;
        }

        public final void setEndpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
        }

        @Override
        public final Builder endpointArn(String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final String getEndpointStatus() {
            return endpointStatus;
        }

        public final void setEndpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
        }

        @Override
        public final Builder endpointStatus(String endpointStatus) {
            this.endpointStatus = endpointStatus;
            return this;
        }

        @Override
        public final Builder endpointStatus(EndpointStatus endpointStatus) {
            this.endpointStatus(endpointStatus == null ? null : endpointStatus.toString());
            return this;
        }

        @Override
        public ModelDashboardEndpoint build() {
            return new ModelDashboardEndpoint(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
