/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for the infrastructure that the model will be deployed to.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInfrastructureConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInfrastructureConfig.Builder, ModelInfrastructureConfig> {
    private static final SdkField<String> INFRASTRUCTURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InfrastructureType").getter(getter(ModelInfrastructureConfig::infrastructureTypeAsString))
            .setter(setter(Builder::infrastructureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureType").build())
            .build();

    private static final SdkField<RealTimeInferenceConfig> REAL_TIME_INFERENCE_CONFIG_FIELD = SdkField
            .<RealTimeInferenceConfig> builder(MarshallingType.SDK_POJO).memberName("RealTimeInferenceConfig")
            .getter(getter(ModelInfrastructureConfig::realTimeInferenceConfig)).setter(setter(Builder::realTimeInferenceConfig))
            .constructor(RealTimeInferenceConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeInferenceConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFRASTRUCTURE_TYPE_FIELD,
            REAL_TIME_INFERENCE_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String infrastructureType;

    private final RealTimeInferenceConfig realTimeInferenceConfig;

    private ModelInfrastructureConfig(BuilderImpl builder) {
        this.infrastructureType = builder.infrastructureType;
        this.realTimeInferenceConfig = builder.realTimeInferenceConfig;
    }

    /**
     * <p>
     * The inference option to which to deploy your model. Possible values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RealTime</code>: Deploy to real-time inference.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #infrastructureType} will return {@link ModelInfrastructureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #infrastructureTypeAsString}.
     * </p>
     * 
     * @return The inference option to which to deploy your model. Possible values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RealTime</code>: Deploy to real-time inference.
     *         </p>
     *         </li>
     * @see ModelInfrastructureType
     */
    public final ModelInfrastructureType infrastructureType() {
        return ModelInfrastructureType.fromValue(infrastructureType);
    }

    /**
     * <p>
     * The inference option to which to deploy your model. Possible values are the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>RealTime</code>: Deploy to real-time inference.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #infrastructureType} will return {@link ModelInfrastructureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #infrastructureTypeAsString}.
     * </p>
     * 
     * @return The inference option to which to deploy your model. Possible values are the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>RealTime</code>: Deploy to real-time inference.
     *         </p>
     *         </li>
     * @see ModelInfrastructureType
     */
    public final String infrastructureTypeAsString() {
        return infrastructureType;
    }

    /**
     * <p>
     * The infrastructure configuration for deploying the model to real-time inference.
     * </p>
     * 
     * @return The infrastructure configuration for deploying the model to real-time inference.
     */
    public final RealTimeInferenceConfig realTimeInferenceConfig() {
        return realTimeInferenceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(realTimeInferenceConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInfrastructureConfig)) {
            return false;
        }
        ModelInfrastructureConfig other = (ModelInfrastructureConfig) obj;
        return Objects.equals(infrastructureTypeAsString(), other.infrastructureTypeAsString())
                && Objects.equals(realTimeInferenceConfig(), other.realTimeInferenceConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInfrastructureConfig").add("InfrastructureType", infrastructureTypeAsString())
                .add("RealTimeInferenceConfig", realTimeInferenceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InfrastructureType":
            return Optional.ofNullable(clazz.cast(infrastructureTypeAsString()));
        case "RealTimeInferenceConfig":
            return Optional.ofNullable(clazz.cast(realTimeInferenceConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InfrastructureType", INFRASTRUCTURE_TYPE_FIELD);
        map.put("RealTimeInferenceConfig", REAL_TIME_INFERENCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModelInfrastructureConfig, T> g) {
        return obj -> g.apply((ModelInfrastructureConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInfrastructureConfig> {
        /**
         * <p>
         * The inference option to which to deploy your model. Possible values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RealTime</code>: Deploy to real-time inference.
         * </p>
         * </li>
         * </ul>
         * 
         * @param infrastructureType
         *        The inference option to which to deploy your model. Possible values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RealTime</code>: Deploy to real-time inference.
         *        </p>
         *        </li>
         * @see ModelInfrastructureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInfrastructureType
         */
        Builder infrastructureType(String infrastructureType);

        /**
         * <p>
         * The inference option to which to deploy your model. Possible values are the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>RealTime</code>: Deploy to real-time inference.
         * </p>
         * </li>
         * </ul>
         * 
         * @param infrastructureType
         *        The inference option to which to deploy your model. Possible values are the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>RealTime</code>: Deploy to real-time inference.
         *        </p>
         *        </li>
         * @see ModelInfrastructureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ModelInfrastructureType
         */
        Builder infrastructureType(ModelInfrastructureType infrastructureType);

        /**
         * <p>
         * The infrastructure configuration for deploying the model to real-time inference.
         * </p>
         * 
         * @param realTimeInferenceConfig
         *        The infrastructure configuration for deploying the model to real-time inference.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realTimeInferenceConfig(RealTimeInferenceConfig realTimeInferenceConfig);

        /**
         * <p>
         * The infrastructure configuration for deploying the model to real-time inference.
         * </p>
         * This is a convenience method that creates an instance of the {@link RealTimeInferenceConfig.Builder} avoiding
         * the need to create one manually via {@link RealTimeInferenceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RealTimeInferenceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #realTimeInferenceConfig(RealTimeInferenceConfig)}.
         * 
         * @param realTimeInferenceConfig
         *        a consumer that will call methods on {@link RealTimeInferenceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #realTimeInferenceConfig(RealTimeInferenceConfig)
         */
        default Builder realTimeInferenceConfig(Consumer<RealTimeInferenceConfig.Builder> realTimeInferenceConfig) {
            return realTimeInferenceConfig(RealTimeInferenceConfig.builder().applyMutation(realTimeInferenceConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String infrastructureType;

        private RealTimeInferenceConfig realTimeInferenceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInfrastructureConfig model) {
            infrastructureType(model.infrastructureType);
            realTimeInferenceConfig(model.realTimeInferenceConfig);
        }

        public final String getInfrastructureType() {
            return infrastructureType;
        }

        public final void setInfrastructureType(String infrastructureType) {
            this.infrastructureType = infrastructureType;
        }

        @Override
        public final Builder infrastructureType(String infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        @Override
        public final Builder infrastructureType(ModelInfrastructureType infrastructureType) {
            this.infrastructureType(infrastructureType == null ? null : infrastructureType.toString());
            return this;
        }

        public final RealTimeInferenceConfig.Builder getRealTimeInferenceConfig() {
            return realTimeInferenceConfig != null ? realTimeInferenceConfig.toBuilder() : null;
        }

        public final void setRealTimeInferenceConfig(RealTimeInferenceConfig.BuilderImpl realTimeInferenceConfig) {
            this.realTimeInferenceConfig = realTimeInferenceConfig != null ? realTimeInferenceConfig.build() : null;
        }

        @Override
        public final Builder realTimeInferenceConfig(RealTimeInferenceConfig realTimeInferenceConfig) {
            this.realTimeInferenceConfig = realTimeInferenceConfig;
            return this;
        }

        @Override
        public ModelInfrastructureConfig build() {
            return new ModelInfrastructureConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
